% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Getters.R
\docType{methods}
\name{classes}
\alias{classes}
\alias{names}
\alias{compare}
\alias{model}
\alias{link}
\alias{classes,pim.environment-method}
\alias{names,pim.environment-method}
\alias{names,pim.poset-method}
\alias{compare}
\alias{compare,pim.environment-method}
\alias{compare,pim.poset-method}
\alias{model}
\alias{model,pim-method}
\alias{model,pim.summary-method}
\alias{link}
\alias{link,pim-method}
\alias{link,pim.summary-method}
\title{Extract information from pim.environment and pim.poset objects}
\usage{
classes(x)

\S4method{classes}{pim.environment}(x)

\S4method{names}{pim.environment}(x)

\S4method{names}{pim.poset}(x)

compare(x)

\S4method{compare}{pim.environment}(x)

\S4method{compare}{pim.poset}(x)

model(object, ...)

\S4method{model}{pim}(object)

\S4method{model}{pim.summary}(object)

link(object, ...)

\S4method{link}{pim}(object)

\S4method{link}{pim.summary}(object)
}
\arguments{
\item{x}{an object of class \code{pim.environment} or \code{pim.poset}}

\item{object}{an object of class \code{pim} or \code{pim.summary}}

\item{...}{arguments passed to and from other methods.}
}
\value{
\code{classes()}: A named vector with the classes of the data 
contained in the \code{pim.environment}

\code{names()}: For an object of class \code{pim.environment} the names
of the variables in the object. For an object of class \code{pim.poset},
the name of the poset functions inside the environment

\code{compare()}: A character value indicating how the comparison
is defined in a \code{pim.poset} object, or the poset-slot of 
a \code{pim.environment} object respectively.

\code{model()}: a character value that displays
the type of model (difference, marginal, regular or customized)

\code{link()}: a character value that displays
the type of link (difference, marginal, regular or customized)
}
\description{
These functions serve to extract the information contained
in the objects of class \code{\link{pim.environment}} and 
\code{\link{pim.poset}}.
}
\examples{
data(DysData)
DysPimEnv <- new.pim.env(DysData,poset=TRUE)
classes(DysPimEnv)
names(DysPimEnv)
compare(DysPimEnv)

themodel <- pim(SPC_D2 ~ Chemo, data = DysData, model = 'difference')
model(themodel)
thesummary <- summary(themodel)
model(thesummary)

}
\seealso{
\code{\link{nobs}}, \code{\link{poset}}, \code{\link{is.complete}},
\code{\link{pim.environment-class}}, \code{\link{pim.poset-class}}, 
\code{\link{pim-class}}, \code{\link{pim.summary-class}}
}
