% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oldFunctions.R
\name{sem.basis.set}
\alias{sem.basis.set}
\title{sem.basis.set}
\usage{
sem.basis.set(modelList, corr.errors = NULL, add.vars = NULL)
}
\arguments{
\item{modelList}{a \code{list} of regressions representing the structural equation model}

\item{corr.errors}{a vector of variables with correlated errors (separated by "~~")}

\item{add.vars}{a vector of additional variables whose independence claims should be}
}
\value{
eturns a \code{list} of independence claims. Each entry in the \code{list} is a vector 
where the first entry is the predictor whose independence from the response is being evaluated, 
the second is the response, and remaining entries represent the variables on which the independence 
claim are conditional
}
\description{
Derive independence claims for SEM (old)
}
\details{
Variables with correlated errors have no direct relationship but rather are hypothesized to be driven 
by the same underlying factor. This covariance should be reflected as correlated errors 
(double-headed arrow). 
Correlated errors are specified using the same syntax as the \code{lavaan} package: 
\code{var1 ~~ var2}. Variables with correlated errors are ignored in the basis set under the 
assumption that their correlations will be quantified later using the function \code{sem.coefs}. 
The argument \code{add.vars} requires a vector of character strings corresponding to column names
in the dataset used to construct the models in \code{modelList}. This is useful if comparing 
nested SEMs where one wishes to account for additional variables whose independence claims should 
be evaluated, but which do not have any hypothesized paths in the current SEM. The default assumes
 there is no additional independence claims that do not appear in the model list.
}
