% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.piar_index.R
\name{[.piar_index}
\alias{[.piar_index}
\alias{[<-.piar_index}
\title{Extract and replace index values}
\usage{
\method{[}{piar_index}(x, i, j, ...)

\method{[}{piar_index}(x, i, j, ...) <- value
}
\arguments{
\item{x}{A price index, as made by, e.g., \code{\link[=elemental_index]{elemental_index()}}.}

\item{i, j}{Indices for the levels and time periods of a price index. See
details.}

\item{...}{Ignored.}

\item{value}{A numeric vector.}
}
\value{
A price index that inherits from \code{\link{chainable_piar_index}} if \code{x} is a
period-over-period index, or \code{\link{direct_piar_index}} if \code{x} is a
fixed-base index. If \code{x} inherits from \code{\link{aggregate_piar_index}} then
\code{[} returns an aggregate index if the levels are unchanged.
}
\description{
Methods to extract and replace index values like a matrix.
}
\details{
The extraction methods treat \code{x} as a matrix of index values with
(named) rows for each \code{level} and columns for each \code{period} in
\code{x}. Unlike a matrix, dimensions are never dropped as subscripting
\code{x} always returns an index object. This means that subscripting with a
matrix is not possible, and only a submatrix can be extracted. As \code{x}
is not an atomic vector, subscripting with a single index like \code{x[1]}
extracts all time periods for that level.

The replacement methods similarly treat \code{x} as a matrix, and behave the
same as replacing values in a matrix (except that \code{value} is coerced to
numeric). Note that replacing the values of an index will remove the
corresponding percent-change contributions (if any).

Subscripting an aggregate index cannot generally preserve the aggregation
structure if any levels are removed or rearranged, and in this case the
resulting index is \emph{not} an aggregate index. Similarly, replacing the
values for an aggregate index generally breaks consistency in aggregation,
and therefore the result is \emph{not} an aggregate index.
}
\examples{
prices <- data.frame(
  rel = 1:8,
  period = rep(1:2, each = 4),
  ea = rep(letters[1:2], 4)
)

# Calculate Jevons elemental indexes

epr <- with(prices, elemental_index(rel, period, ea))

# Extract the indexes like a matrix

epr["a", ]

epr[, 2]

epr[1, ] <- 1 # can be useful for doing specific imputations
epr

}
\seealso{
Other index methods: 
\code{\link{aggregate.piar_index}()},
\code{\link{as.data.frame.piar_index}()},
\code{\link{chain}()},
\code{\link{contrib}()},
\code{\link{head.piar_index}()},
\code{\link{levels.piar_index}()},
\code{\link{mean.piar_index}()},
\code{\link{merge.piar_index}()},
\code{\link{stack.piar_index}()},
\code{\link{time.piar_index}()},
\code{\link{vcov.aggregate_piar_index}()}
}
\concept{index methods}
