% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/head.piar_index.R
\name{head.piar_index}
\alias{head.piar_index}
\alias{tail.piar_index}
\title{Return the first/last parts of an index}
\usage{
\method{head}{piar_index}(x, n = 6L, ...)

\method{tail}{piar_index}(x, n = 6L, ...)
}
\arguments{
\item{x}{A price index, as made by, e.g., \code{\link[=elemental_index]{elemental_index()}}.}

\item{n}{See \code{\link[=head]{head()}}/\code{\link[=tail]{tail()}}. The default takes the
first/last 6 levels of \code{x}.}

\item{...}{Further arguments passed to or used by methods.}
}
\value{
A price index that inherits from \code{\link{chainable_piar_index}} if \code{x} is a
period-over-period index, or \code{direct_piar_index()} if \code{x} is a
fixed-base index.
}
\description{
Extract the first/last parts of an index as if it were a matrix.
}
\examples{
prices <- data.frame(
  rel = 1:8,
  period = rep(1:2, each = 4),
  ea = rep(letters[1:2], 4)
)

# Calculate Jevons elemental indexes

epr <- with(prices, elemental_index(rel, period, ea))

# Get the first/last time series

head(epr, 1)

tail(epr, 1)

}
\seealso{
Other index methods: 
\code{\link{[.piar_index}()},
\code{\link{aggregate.piar_index}()},
\code{\link{as.data.frame.piar_index}()},
\code{\link{chain}()},
\code{\link{contrib}()},
\code{\link{levels.piar_index}()},
\code{\link{mean.piar_index}()},
\code{\link{merge.piar_index}()},
\code{\link{stack.piar_index}()},
\code{\link{time.piar_index}()},
\code{\link{vcov.aggregate_piar_index}()}
}
\concept{index methods}
