% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAG.R
\name{DAG}
\alias{DAG}
\title{Directed acyclic graphs (DAGs)}
\usage{
DAG(..., order = TRUE)
}
\arguments{
\item{...}{a sequence of model formulae}

\item{order}{logical, defaulting to \code{FALSE}. If \code{TRUE} the nodes of the
    DAG are permuted according to the topological order. If
    \code{FALSE} the nodes are in the order they first appear in the model
    formulae (from left to right).}
}
\value{
An object of classes \code{matrix} and \code{DAG}
}
\description{
This function is a simple wrapper around the function from the \code{ggm}
package. The only differences are that the \code{order} argument defaults
to \code{TRUE} and that it adds a \code{DAG} class for easy plotting.
}
\examples{
  # Use formula notation to create DAGs:
  plot(DAG(A~B, B~C))
  # Use + to easily add multiple parents to a node:
  plot(DAG(A~B+C))
  # Add a node as it's own parent to create an isolate:
  plot(DAG(A~B+C, D~D))
}
