% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{font_size}
\alias{font_size}
\alias{font_size<-}
\alias{set_font_size}
\title{Return or set font size}
\usage{
font_size(x, ...)

font_size(x) <- value

set_font_size(x, value)
}
\arguments{
\item{x}{\code{rtf_doc} object or a \code{hf_line} object.}

\item{...}{Additonal arguments passed to method dispatch.}

\item{value}{A numeric value for font size in points.}
}
\value{
For \code{font_size()}, the font_size attribute of the supplied
  \code{rtf_doc} or \code{hf_line}. For \code{`font_size<-`()} and
  \code{set_font_size}, the modified object.
}
\description{
These property functions modify or return the font sizes of an \code{rtf_doc} object
or individual titles/footnotes objects of the \code{hf_line} class.

When used on an rtf_doc object to retrieve font sizes, the document level
default font size within the \code{rtf_doc} is returned. When used on an \code{rtf_doc} to
set fonts, the default font size for the RTF document is set.

When used on titles/footnotes (\code{hf_line} objects), the font size is either
returned of set for that individual line.
}
\examples{
library(huxtable)
ht <- huxtable(
  column1 = 1:5,
  column2 = letters[1:5]
)
rtf <- rtf_doc(ht, list(hf_line("aTitle", font_size = 15)))

pharmaRTF::font_size(rtf)
# Returns 12

pharmaRTF::font_size(rtf) <- 14

pharmaRTF::font_size(rtf$titles[[1]])
# Returns 15
pharmaRTF::font_size(rtf)
# Returns 14


}
