% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{handlers-management}
\alias{handlers-management}
\alias{addHandler}
\alias{removeHandler}
\title{Add a handler to or remove one from a logger.}
\usage{
addHandler(handler, ..., logger = "")

removeHandler(handler, logger = "")
}
\arguments{
\item{handler}{The name of the handler, or its action}

\item{...}{Extra parameters, to be stored in the handler list

\dots may contain extra parameters that will be passed to the handler
action. Some elements in the \dots will be interpreted here.}

\item{logger}{the name of the logger to which to attach the new handler,
defaults to the root logger.}
}
\description{
Use this function to maintain the list of handlers attached to a logger.\cr
\cr
\code{addHandler} and \code{removeHandler} are also offered as methods of the
\var{Logger} S4 class.
}
\details{
Handlers are implemented as environments. Within a logger a handler is
identified by its \var{name} and all handlers define at least the
three variables:
\describe{
  \item{level}{all records at level lower than this are skipped.}
  \item{formatter}{a function getting a record and returning a string}
  \item{\code{action(msg, handler)}}{a function accepting two parameters: a
     formatted log record and the handler itself. making the handler a
     parameter of the action allows us to have reusable action functions.}
}

Being an environment, a handler may define as many variables as you
think you need.  keep in mind the handler is passed to the action
function, which can check for existence and can use all variables that
the handler defines.
}
