\name{makeparma}
\alias{makeparma}
\alias{makepar}
\title{
Simulation of PARMA sequence
}
\description{
Procedures \code{makeparma} and \code{makepar}  enable to construct PARMA and PAR type sequence of length \code{n} 
according to inputed matrices \code{phi}, \code{theta}, \code{del}. 
The optional parameter \code{nprep} defines the number of 
periods of simulated output \code{y} that will be discarded to let 
the start-up transients settle.
}
\usage{
makeparma(n, phi, theta, del, nprep)
makepar(n, phi, del, nprep)
}
\arguments{
  \item{n}{
length of simulated series.
}
  \item{phi}{
matrix of size \eqn{T \times p} containing periodic AR parameters.
}
  \item{theta}{
matrix of size \eqn{T \times q} containing periodic MA parameters.
}
  \item{del}{
vector of length \eqn{T} containing the periodic sigmas (shock weights), which are
sometimes denoted also as \eqn{\sigma(t)} or as \eqn{ \theta_{0}(t)}.
}
  \item{nprep}{
number of periods of simulated output; for \code{p>0} the computation of new 
\code{y} values depends on old ones through the autoregressive part. Starting 
a PARMA with the assumption that old values of \code{y} are equal to zero causes
 a transient in the output. This transient dies out as time goes on. So to avoid this transient problem, 
we compute \code{nprep} periods of simulated output to allow the transient to die out.\cr
This parameter is optional, because by default  \code{nprep=50} (for \code{makeparma} procedure) or \code{nprep=10}
(for \code{makepar} procedure). Later we will provide a function to compute an
appropriate value of \code{nprep} that 
depends on the PARMA parameters.
}
}
\details{
A vector \eqn{ \xi(t)} of independent \eqn{N(0,1)} variates is generated by 
the standard 
random number generator \code{rnorm}. This vector series is filtered 
by \code{parmafil}, which parameters are set by \code{phi}, \code{theta}
 and \code{del}, 
to generate the filtered series (pre-iterates and the \code{n} desired data). 
The last \code{n} data of the filtered series are output in the vector \code{y}.
}
\value{
PARMA or PAR sequence returned as \code{y}.
}
\author{
Harry Hurd 
}
\seealso{
 \code{\link{parmafil}}
}

\examples{
##################### simulation of PARMA(2,1)
T=12
nlen=480
p=2
 a=matrix(0,T,p)
q=1
 b=matrix(0,T,q)

a[1,1]=.8                 
a[2,1]=.3                                     
phia<-ab2phth(a) 
phi0=phia$phi         
phi0=as.matrix(phi0)       
      
b[1,1]=-.7	          
b[2,1]=-.6                  
thetab<-ab2phth(b)         
theta0=thetab$phi  
theta0=as.matrix(theta0) 

del0=matrix(1,T,1)       

PARMA21<-makeparma(nlen,phi0,theta0,del0)
parma<-PARMA21$y
plot(ts(parma))

##################### simulation of PAR(2)
T=24
nlen=1000
p=2
a=matrix(0,T,p)
a[1,1]=.5
a[2,2]=.4

phia<-ab2phth(a)
phi0=phia$phi
phi0=as.matrix(phi0)

del0=matrix(1,T,1)

PAR1<-makepar(nlen,phi0,del0)
par<-PAR1$y
plot(ts(par))
}