% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitGrowth.R
\name{fitGrowth}
\alias{fitGrowth}
\title{Ease of use wrapper function for fitting various growth models specified by \link{growthSS}}
\usage{
fitGrowth(ss, ...)
}
\arguments{
\item{ss}{A list generated by \code{growthSS}.}

\item{...}{Additional arguments passed to model fitting functions determined by \code{ss$type}.
For type = "nlme" these are passed to \code{nlme::nlmeControl}, not \code{nlme::nlme}.
Additional arguments are documented in \link{fitGrowthbrms}, \link{fitGrowthnlme},
\link{fitGrowthnls}, \link{fitGrowthnlrq}, \link{fitGrowthmgcvgam}, \link{fitGrowthsurvreg},
\link{fitGrowthflexsurv}.}
}
\value{
A fit model from the selected type.
}
\description{
Ease of use wrapper function for fitting various growth models specified by \link{growthSS}
}
\examples{

simdf <- growthSim("logistic",
  n = 20, t = 25,
  params = list("A" = c(200, 160), "B" = c(13, 11), "C" = c(3, 3.5))
)
ss <- growthSS(
  model = "logistic", form = y ~ time | group,
  df = simdf, type = "nls"
)
fitGrowth(ss)
ss <- growthSS(
  model = "gam", form = y ~ time | group,
  df = simdf, type = "nls"
)
fitGrowth(ss)

}
\seealso{
\link{growthPlot} for model visualization, \link{testGrowth} for hypothesis testing,
\link{barg} for Bayesian model reporting metrics.
}
\keyword{Bayesian}
\keyword{brms}
\keyword{nlme}
\keyword{nlrq}
\keyword{nls}
