% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{my_lm}
\alias{my_lm}
\title{Fit a linear model and plot}
\usage{
my_lm(
  tab,
  var,
  metadata = NULL,
  smooth_param = list(),
  facet = TRUE,
  formula_size = 2.5,
  ...
)
}
\arguments{
\item{tab}{your dataframe}

\item{var}{which colname choose for var or a vector}

\item{metadata}{the dataframe contains the var}

\item{smooth_param}{parameters parse to \code{\link[ggplot2]{geom_smooth}}}

\item{facet}{whether facet?}

\item{formula_size}{formula font size, default is 2.5}

\item{...}{parameters parse to \code{\link[ggplot2]{geom_point}}}
}
\value{
a ggplot
}
\description{
Fit a linear model and plot
}
\examples{
\donttest{
if (requireNamespace("ggpmisc")) {
  my_lm(runif(50), var = 1:50)
  my_lm(c(1:50) + runif(50, 0, 5), var = 1:50)
}
}
}
