% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{my_circo}
\alias{my_circo}
\title{My circo plot}
\usage{
my_circo(
  df,
  reorder = TRUE,
  pal = NULL,
  mode = c("circlize", "chorddiag")[1],
  legend = TRUE,
  ...
)
}
\arguments{
\item{df}{dataframe with three column}

\item{reorder}{reorder by number?}

\item{pal}{a vector of colors, you can get from here too: \code{RColorBrewer::brewer.pal(5,"Set2")} or \code{ggsci::pal_aaas()(5)}}

\item{mode}{"circlize","chorddiag"}

\item{legend}{plot legend?}

\item{...}{\code{\link[circlize]{chordDiagram}}}
}
\value{
chordDiagram
}
\description{
My circo plot
}
\examples{
\donttest{
if (requireNamespace("circlize")) {
  data.frame(
    a = c("a", "a", "b", "b", "c"),
    b = c("a", LETTERS[2:5]), c = 1:5
  ) \%>\% my_circo(mode = "circlize")
  data(otutab)
  cbind(taxonomy, num = rowSums(otutab))[1:10, c(2, 6, 8)] -> test
  my_circo(test)
}
}

}
