% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_delete_tape}
\alias{storagegateway_delete_tape}
\title{Deletes the specified virtual tape}
\usage{
storagegateway_delete_tape(GatewayARN, TapeARN,
  BypassGovernanceRetention)
}
\arguments{
\item{GatewayARN}{[required] The unique Amazon Resource Name (ARN) of the gateway that the virtual
tape to delete is associated with. Use the
\code{\link[=storagegateway_list_gateways]{list_gateways}} operation to return a
list of gateways for your account and AWS Region.}

\item{TapeARN}{[required] The Amazon Resource Name (ARN) of the virtual tape to delete.}

\item{BypassGovernanceRetention}{Set to \code{TRUE} to delete an archived tape that belongs to a custom pool
with tape retention lock. Only archived tapes with tape retention lock
set to \code{governance} can be deleted. Archived tapes with tape retention
lock set to \code{compliance} can't be deleted.}
}
\value{
A list with the following syntax:\preformatted{list(
  TapeARN = "string"
)
}
}
\description{
Deletes the specified virtual tape. This operation is only supported in
the tape gateway type.
}
\section{Request syntax}{
\preformatted{svc$delete_tape(
  GatewayARN = "string",
  TapeARN = "string",
  BypassGovernanceRetention = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example deletes the specified virtual tape.
svc$delete_tape(
  GatewayARN = "arn:aws:storagegateway:us-east-1:204469490176:gateway/sgw-12A3456B",
  TapeARN = "arn:aws:storagegateway:us-east-1:204469490176:tape/TEST05A2A0"
)
}

}
\keyword{internal}
