% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_describe_job}
\alias{glacier_describe_job}
\title{This operation returns information about a job you previously initiated,
including the job initiation date, the user who initiated the job, the
job status code/message and the Amazon SNS topic to notify after Amazon
S3 Glacier (Glacier) completes the job}
\usage{
glacier_describe_job(accountId, vaultName, jobId)
}
\arguments{
\item{accountId}{[required] The \code{AccountId} value is the AWS account ID of the account that owns the
vault. You can either specify an AWS account ID or optionally a single
'\code{-}' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
associated with the credentials used to sign the request. If you use an
account ID, do not include any hyphens ('-') in the ID.}

\item{vaultName}{[required] The name of the vault.}

\item{jobId}{[required] The ID of the job to describe.}
}
\value{
A list with the following syntax:\preformatted{list(
  JobId = "string",
  JobDescription = "string",
  Action = "ArchiveRetrieval"|"InventoryRetrieval"|"Select",
  ArchiveId = "string",
  VaultARN = "string",
  CreationDate = "string",
  Completed = TRUE|FALSE,
  StatusCode = "InProgress"|"Succeeded"|"Failed",
  StatusMessage = "string",
  ArchiveSizeInBytes = 123,
  InventorySizeInBytes = 123,
  SNSTopic = "string",
  CompletionDate = "string",
  SHA256TreeHash = "string",
  ArchiveSHA256TreeHash = "string",
  RetrievalByteRange = "string",
  Tier = "string",
  InventoryRetrievalParameters = list(
    Format = "string",
    StartDate = "string",
    EndDate = "string",
    Limit = "string",
    Marker = "string"
  ),
  JobOutputPath = "string",
  SelectParameters = list(
    InputSerialization = list(
      csv = list(
        FileHeaderInfo = "USE"|"IGNORE"|"NONE",
        Comments = "string",
        QuoteEscapeCharacter = "string",
        RecordDelimiter = "string",
        FieldDelimiter = "string",
        QuoteCharacter = "string"
      )
    ),
    ExpressionType = "SQL",
    Expression = "string",
    OutputSerialization = list(
      csv = list(
        QuoteFields = "ALWAYS"|"ASNEEDED",
        QuoteEscapeCharacter = "string",
        RecordDelimiter = "string",
        FieldDelimiter = "string",
        QuoteCharacter = "string"
      )
    )
  ),
  OutputLocation = list(
    S3 = list(
      BucketName = "string",
      Prefix = "string",
      Encryption = list(
        EncryptionType = "aws:kms"|"AES256",
        KMSKeyId = "string",
        KMSContext = "string"
      ),
      CannedACL = "private"|"public-read"|"public-read-write"|"aws-exec-read"|"authenticated-read"|"bucket-owner-read"|"bucket-owner-full-control",
      AccessControlList = list(
        list(
          Grantee = list(
            Type = "AmazonCustomerByEmail"|"CanonicalUser"|"Group",
            DisplayName = "string",
            URI = "string",
            ID = "string",
            EmailAddress = "string"
          ),
          Permission = "FULL_CONTROL"|"WRITE"|"WRITE_ACP"|"READ"|"READ_ACP"
        )
      ),
      Tagging = list(
        "string"
      ),
      UserMetadata = list(
        "string"
      ),
      StorageClass = "STANDARD"|"REDUCED_REDUNDANCY"|"STANDARD_IA"
    )
  )
)
}
}
\description{
This operation returns information about a job you previously initiated,
including the job initiation date, the user who initiated the job, the
job status code/message and the Amazon SNS topic to notify after Amazon
S3 Glacier (Glacier) completes the job. For more information about
initiating a job, see \code{\link[=glacier_initiate_job]{initiate_job}}.

This operation enables you to check the status of your job. However, it
is strongly recommended that you set up an Amazon SNS topic and specify
it in your initiate job request so that Glacier can notify the topic
after it completes the job.

A job ID will not expire for at least 24 hours after Glacier completes
the job.

An AWS account has full permission to perform all operations (actions).
However, AWS Identity and Access Management (IAM) users don't have any
permissions by default. You must grant them explicit permission to
perform specific actions. For more information, see \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/auth-and-access-control.html}{Access Control Using AWS Identity and Access Management (IAM)}.

For more information about using this operation, see the documentation
for the underlying REST API \href{https://docs.aws.amazon.com/amazonglacier/latest/dev/api-describe-job-get.html}{Describe Job}
in the \emph{Amazon Glacier Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_job(
  accountId = "string",
  vaultName = "string",
  jobId = "string"
)
}
}

\examples{
\dontrun{
# The example returns information about the previously initiated job
# specified by the job ID.
svc$describe_job(
  accountId = "-",
  jobId = "zbxcm3Z_3z5UkoroF7SuZKrxgGoDc3RloGduS7Eg-RO47Yc6FxsdGBgf_Q2DK5Ej...",
  vaultName = "my-vault"
)
}

}
\keyword{internal}
