% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_get_backup_selection}
\alias{backup_get_backup_selection}
\title{Returns selection metadata and a document in JSON format that specifies
a list of resources that are associated with a backup plan}
\usage{
backup_get_backup_selection(BackupPlanId, SelectionId)
}
\arguments{
\item{BackupPlanId}{[required] Uniquely identifies a backup plan.}

\item{SelectionId}{[required] Uniquely identifies the body of a request to assign a set of resources
to a backup plan.}
}
\value{
A list with the following syntax:\preformatted{list(
  BackupSelection = list(
    SelectionName = "string",
    IamRoleArn = "string",
    Resources = list(
      "string"
    ),
    ListOfTags = list(
      list(
        ConditionType = "STRINGEQUALS",
        ConditionKey = "string",
        ConditionValue = "string"
      )
    )
  ),
  SelectionId = "string",
  BackupPlanId = "string",
  CreationDate = as.POSIXct(
    "2015-01-01"
  ),
  CreatorRequestId = "string"
)
}
}
\description{
Returns selection metadata and a document in JSON format that specifies
a list of resources that are associated with a backup plan.
}
\section{Request syntax}{
\preformatted{svc$get_backup_selection(
  BackupPlanId = "string",
  SelectionId = "string"
)
}
}

\keyword{internal}
