% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_create_bucket}
\alias{s3control_create_bucket}
\title{This API operation creates an Amazon S3 on Outposts bucket}
\usage{
s3control_create_bucket(ACL, Bucket, CreateBucketConfiguration,
  GrantFullControl, GrantRead, GrantReadACP, GrantWrite, GrantWriteACP,
  ObjectLockEnabledForBucket, OutpostId)
}
\arguments{
\item{ACL}{The canned ACL to apply to the bucket.

This is not supported by Amazon S3 on Outposts buckets.}

\item{Bucket}{[required] The name of the bucket.}

\item{CreateBucketConfiguration}{The configuration information for the bucket.

This is not supported by Amazon S3 on Outposts buckets.}

\item{GrantFullControl}{Allows grantee the read, write, read ACP, and write ACP permissions on
the bucket.

This is not supported by Amazon S3 on Outposts buckets.}

\item{GrantRead}{Allows grantee to list the objects in the bucket.

This is not supported by Amazon S3 on Outposts buckets.}

\item{GrantReadACP}{Allows grantee to read the bucket ACL.

This is not supported by Amazon S3 on Outposts buckets.}

\item{GrantWrite}{Allows grantee to create, overwrite, and delete any object in the
bucket.

This is not supported by Amazon S3 on Outposts buckets.}

\item{GrantWriteACP}{Allows grantee to write the ACL for the applicable bucket.

This is not supported by Amazon S3 on Outposts buckets.}

\item{ObjectLockEnabledForBucket}{Specifies whether you want S3 Object Lock to be enabled for the new
bucket.

This is not supported by Amazon S3 on Outposts buckets.}

\item{OutpostId}{The ID of the Outposts where the bucket is being created.

This is required by Amazon S3 on Outposts buckets.}
}
\description{
This API operation creates an Amazon S3 on Outposts bucket. To create an
S3 bucket, see \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html}{Create Bucket}
in the \emph{Amazon Simple Storage Service API}.

Creates a new Outposts bucket. By creating the bucket, you become the
bucket owner. To create an Outposts bucket, you must have S3 on
Outposts. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/S3onOutposts.html}{Using Amazon S3 on Outposts}
in \emph{Amazon Simple Storage Service Developer Guide}.

Not every string is an acceptable bucket name. For information on bucket
naming restrictions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html#bucketnamingrules}{Working with Amazon S3 Buckets}.

S3 on Outposts buckets do not support
\itemize{
\item ACLs. Instead, configure access point policies to manage access to
buckets.
\item Public access.
\item Object Lock
\item Bucket Location constraint
}

For an example of the request syntax for Amazon S3 on Outposts that uses
the S3 on Outposts endpoint hostname prefix and \code{x-amz-outpost-id} in
your API request, see the
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateBucket.html#API_control_CreateBucket_Examples}{Examples}
section.

The following actions are related to \code{CreateBucket} for Amazon S3 on
Outposts:
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html}{PutObject}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetBucket.html}{GetBucket}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteBucket.html}{DeleteBucket}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html}{CreateAccessPoint}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutAccessPointPolicy.html}{PutAccessPointPolicy}
}
}
\section{Request syntax}{
\preformatted{svc$create_bucket(
  ACL = "private"|"public-read"|"public-read-write"|"authenticated-read",
  Bucket = "string",
  CreateBucketConfiguration = list(
    LocationConstraint = "EU"|"eu-west-1"|"us-west-1"|"us-west-2"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"sa-east-1"|"cn-north-1"|"eu-central-1"
  ),
  GrantFullControl = "string",
  GrantRead = "string",
  GrantReadACP = "string",
  GrantWrite = "string",
  GrantWriteACP = "string",
  ObjectLockEnabledForBucket = TRUE|FALSE,
  OutpostId = "string"
)
}
}

\keyword{internal}
