% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_delete_bandwidth_rate_limit}
\alias{storagegateway_delete_bandwidth_rate_limit}
\title{Deletes the bandwidth rate limits of a gateway}
\usage{
storagegateway_delete_bandwidth_rate_limit(GatewayARN, BandwidthType)
}
\arguments{
\item{GatewayARN}{[required]}

\item{BandwidthType}{[required] One of the BandwidthType values that indicates the gateway bandwidth
rate limit to delete.

Valid Values: \code{UPLOAD} | \code{DOWNLOAD} | \code{ALL}}
}
\description{
Deletes the bandwidth rate limits of a gateway. You can delete either
the upload and download bandwidth rate limit, or you can delete both. If
you delete only one of the limits, the other limit remains unchanged. To
specify which gateway to work with, use the Amazon Resource Name (ARN)
of the gateway in your request. This operation is supported for the
stored volume, cached volume and tape gateway types.
}
\section{Request syntax}{
\preformatted{svc$delete_bandwidth_rate_limit(
  GatewayARN = "string",
  BandwidthType = "string"
)
}
}

\examples{
\dontrun{
# Deletes the bandwidth rate limits of a gateway; either the upload or
# download limit, or both.
svc$delete_bandwidth_rate_limit(
  BandwidthType = "All",
  GatewayARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B"
)
}

}
\keyword{internal}
