% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glacier_operations.R
\name{glacier_complete_vault_lock}
\alias{glacier_complete_vault_lock}
\title{This operation completes the vault locking process by transitioning the
vault lock from the InProgress state to the Locked state, which causes
the vault lock policy to become unchangeable}
\usage{
glacier_complete_vault_lock(accountId, vaultName, lockId)
}
\arguments{
\item{accountId}{[required] The \code{AccountId} value is the AWS account ID. This value must match the
AWS account ID associated with the credentials used to sign the request.
You can either specify an AWS account ID or optionally a single '\code{-}'
(hyphen), in which case Amazon Glacier uses the AWS account ID
associated with the credentials used to sign the request. If you specify
your account ID, do not include any hyphens ('-') in the ID.}

\item{vaultName}{[required] The name of the vault.}

\item{lockId}{[required] The \code{lockId} value is the lock ID obtained from a InitiateVaultLock
request.}
}
\description{
This operation completes the vault locking process by transitioning the
vault lock from the \code{InProgress} state to the \code{Locked} state, which
causes the vault lock policy to become unchangeable. A vault lock is put
into the \code{InProgress} state by calling InitiateVaultLock. You can obtain
the state of the vault lock by calling GetVaultLock. For more
information about the vault locking process, \href{http://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html}{Amazon Glacier Vault Lock}.
}
\details{
This operation is idempotent. This request is always successful if the
vault lock is in the \code{Locked} state and the provided lock ID matches the
lock ID originally used to lock the vault.

If an invalid lock ID is passed in the request when the vault lock is in
the \code{Locked} state, the operation returns an \code{AccessDeniedException}
error. If an invalid lock ID is passed in the request when the vault
lock is in the \code{InProgress} state, the operation throws an
\code{InvalidParameter} error.
}
\section{Request syntax}{
\preformatted{svc$complete_vault_lock(
  accountId = "string",
  vaultName = "string",
  lockId = "string"
)
}
}

\examples{
# The example completes the vault locking process by transitioning the
# vault lock from the InProgress state to the Locked state.
\donttest{svc$complete_vault_lock(
  accountId = "-",
  lockId = "AE863rKkWZU53SLW5be4DUcW",
  vaultName = "example-vault"
)}

}
\keyword{internal}
