% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_upload_part}
\alias{s3_upload_part}
\title{Uploads a part in a multipart upload}
\usage{
s3_upload_part(Body, Bucket, ContentLength, ContentMD5, Key, PartNumber,
  UploadId, SSECustomerAlgorithm, SSECustomerKey, SSECustomerKeyMD5,
  RequestPayer)
}
\arguments{
\item{Body}{Object data.}

\item{Bucket}{[required] Name of the bucket to which the multipart upload was initiated.}

\item{ContentLength}{Size of the body in bytes. This parameter is useful when the size of the
body cannot be determined automatically.}

\item{ContentMD5}{The base64-encoded 128-bit MD5 digest of the part data.}

\item{Key}{[required] Object key for which the multipart upload was initiated.}

\item{PartNumber}{[required] Part number of part being uploaded. This is a positive integer between 1
and 10,000.}

\item{UploadId}{[required] Upload ID identifying the multipart upload whose part is being uploaded.}

\item{SSECustomerAlgorithm}{Specifies the algorithm to use to when encrypting the object (e.g.,
AES256).}

\item{SSECustomerKey}{Specifies the customer-provided encryption key for Amazon S3 to use in
encrypting data. This value is used to store the object and then it is
discarded; Amazon does not store the encryption key. The key must be
appropriate for use with the algorithm specified in the
x-amz-server-sideâ€‹-encryptionâ€‹-customer-algorithm header. This must be
the same encryption key specified in the initiate multipart upload
request.}

\item{SSECustomerKeyMD5}{Specifies the 128-bit MD5 digest of the encryption key according to RFC
1321. Amazon S3 uses this header for a message integrity check to ensure
the encryption key was transmitted without error.}

\item{RequestPayer}{}
}
\description{
Uploads a part in a multipart upload.
}
\details{
\strong{Note:} After you initiate multipart upload and upload one or more
parts, you must either complete or abort multipart upload in order to
stop getting charged for storage of the uploaded parts. Only after you
either complete or abort multipart upload, Amazon S3 frees up the parts
storage and stops charging you for the parts storage.
}
\section{Request syntax}{
\preformatted{svc$upload_part(
  Body = raw,
  Bucket = "string",
  ContentLength = 123,
  ContentMD5 = "string",
  Key = "string",
  PartNumber = 123,
  UploadId = "string",
  SSECustomerAlgorithm = "string",
  SSECustomerKey = raw,
  SSECustomerKeyMD5 = "string",
  RequestPayer = "requester"
)
}
}

\examples{
# The following example uploads part 1 of a multipart upload. The example
# specifies a file name for the part data. The Upload ID is same that is
# returned by the initiate multipart upload.
\donttest{svc$upload_part(
  Body = "fileToUpload",
  Bucket = "examplebucket",
  Key = "examplelargeobject",
  PartNumber = "1",
  UploadId = "xadcOB_7YPBOJuoFiQ9cz4P3Pe6FIZwO4f7wN93uHsNBEw97pl5eNwzExg0LAT2dUN91cOmrEQHDsP..."
)}

}
\keyword{internal}
