% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts_operations.R
\name{sts_assume_root}
\alias{sts_assume_root}
\title{Returns a set of short term credentials you can use to perform
privileged tasks on a member account in your organization}
\usage{
sts_assume_root(TargetPrincipal, TaskPolicyArn, DurationSeconds = NULL)
}
\arguments{
\item{TargetPrincipal}{[required] The member account principal ARN or account ID.}

\item{TaskPolicyArn}{[required] The identity based policy that scopes the session to the privileged
tasks that can be performed. You can use one of following Amazon Web
Services managed policies to scope root session actions.
\itemize{
\item \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/security-iam-awsmanpol.html#security-iam-awsmanpol-IAMAuditRootUserCredentials}{IAMAuditRootUserCredentials}
\item \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/security-iam-awsmanpol.html#security-iam-awsmanpol-IAMCreateRootUserPassword}{IAMCreateRootUserPassword}
\item \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/security-iam-awsmanpol.html#security-iam-awsmanpol-IAMDeleteRootUserCredentials}{IAMDeleteRootUserCredentials}
\item \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/security-iam-awsmanpol.html#security-iam-awsmanpol-S3UnlockBucketPolicy}{S3UnlockBucketPolicy}
\item \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/security-iam-awsmanpol.html#security-iam-awsmanpol-SQSUnlockQueuePolicy}{SQSUnlockQueuePolicy}
}}

\item{DurationSeconds}{The duration, in seconds, of the privileged session. The value can range
from 0 seconds up to the maximum session duration of 900 seconds (15
minutes). If you specify a value higher than this setting, the operation
fails.

By default, the value is set to \code{900} seconds.}
}
\description{
Returns a set of short term credentials you can use to perform privileged tasks on a member account in your organization.

See \url{https://www.paws-r-sdk.com/docs/sts_assume_root/} for full documentation.
}
\keyword{internal}
