% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_batch_get_secret_value}
\alias{secretsmanager_batch_get_secret_value}
\title{Retrieves the contents of the encrypted fields SecretString or
SecretBinary for up to 20 secrets}
\usage{
secretsmanager_batch_get_secret_value(
  SecretIdList = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{SecretIdList}{The ARN or names of the secrets to retrieve. You must include \code{Filters}
or \code{SecretIdList}, but not both.}

\item{Filters}{The filters to choose which secrets to retrieve. You must include
\code{Filters} or \code{SecretIdList}, but not both.}

\item{MaxResults}{The number of results to include in the response.

If there are more results available, in the response, Secrets Manager
includes \code{NextToken}. To get the next results, call
\code{\link[=secretsmanager_batch_get_secret_value]{batch_get_secret_value}} again
with the value from \code{NextToken}.}

\item{NextToken}{A token that indicates where the output should continue from, if a
previous call did not show all results. To get the next results, call
\code{\link[=secretsmanager_batch_get_secret_value]{batch_get_secret_value}} again
with this value.}
}
\description{
Retrieves the contents of the encrypted fields \code{SecretString} or \code{SecretBinary} for up to 20 secrets. To retrieve a single secret, call \code{\link[=secretsmanager_get_secret_value]{get_secret_value}}.

See \url{https://www.paws-r-sdk.com/docs/secretsmanager_batch_get_secret_value/} for full documentation.
}
\keyword{internal}
