% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sts_operations.R
\name{sts_assume_role}
\alias{sts_assume_role}
\title{Returns a set of temporary security credentials that you can use to
access Amazon Web Services resources}
\usage{
sts_assume_role(
  RoleArn,
  RoleSessionName,
  PolicyArns = NULL,
  Policy = NULL,
  DurationSeconds = NULL,
  Tags = NULL,
  TransitiveTagKeys = NULL,
  ExternalId = NULL,
  SerialNumber = NULL,
  TokenCode = NULL,
  SourceIdentity = NULL,
  ProvidedContexts = NULL
)
}
\arguments{
\item{RoleArn}{[required] The Amazon Resource Name (ARN) of the role to assume.}

\item{RoleSessionName}{[required] An identifier for the assumed role session.

Use the role session name to uniquely identify a session when the same
role is assumed by different principals or for different reasons. In
cross-account scenarios, the role session name is visible to, and can be
logged by the account that owns the role. The role session name is also
used in the ARN of the assumed role principal. This means that
subsequent cross-account API requests that use the temporary security
credentials will expose the role session name to the external account in
their CloudTrail logs.

The regex used to validate this parameter is a string of characters
consisting of upper- and lower-case alphanumeric characters with no
spaces. You can also include underscores or any of the following
characters: =,.@-}

\item{PolicyArns}{The Amazon Resource Names (ARNs) of the IAM managed policies that you
want to use as managed session policies. The policies must exist in the
same account as the role.

This parameter is optional. You can provide up to 10 managed policy
ARNs. However, the plaintext that you use for both inline and managed
session policies can't exceed 2,048 characters. For more information
about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs) and Amazon Web Services Service Namespaces}
in the Amazon Web Services General Reference.

An Amazon Web Services conversion compresses the passed inline session
policy, managed policy ARNs, and session tags into a packed binary
format that has a separate limit. Your request can fail for this limit
even if your plaintext meets the other requirements. The
\code{PackedPolicySize} response element indicates by percentage how close
the policies and tags for your request are to the upper size limit.

Passing policies to this operation returns new temporary credentials.
The resulting session's permissions are the intersection of the role's
identity-based policy and the session policies. You can use the role's
temporary credentials in subsequent Amazon Web Services API calls to
access resources in the account that owns the role. You cannot use
session policies to grant more permissions than those allowed by the
identity-based policy of the role that is being assumed. For more
information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session}{Session Policies}
in the \emph{IAM User Guide}.}

\item{Policy}{An IAM policy in JSON format that you want to use as an inline session
policy.

This parameter is optional. Passing policies to this operation returns
new temporary credentials. The resulting session's permissions are the
intersection of the role's identity-based policy and the session
policies. You can use the role's temporary credentials in subsequent
Amazon Web Services API calls to access resources in the account that
owns the role. You cannot use session policies to grant more permissions
than those allowed by the identity-based policy of the role that is
being assumed. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#policies_session}{Session Policies}
in the \emph{IAM User Guide}.

The plaintext that you use for both inline and managed session policies
can't exceed 2,048 characters. The JSON policy characters can be any
ASCII character from the space character to the end of the valid
character list (\\code{U+0020} through \\verb{U+00FF}). It can also include the tab
(\\code{U+0009}), linefeed (\\verb{U+000A}), and carriage return (\\verb{U+000D}) characters.

An Amazon Web Services conversion compresses the passed inline session
policy, managed policy ARNs, and session tags into a packed binary
format that has a separate limit. Your request can fail for this limit
even if your plaintext meets the other requirements. The
\code{PackedPolicySize} response element indicates by percentage how close
the policies and tags for your request are to the upper size limit.}

\item{DurationSeconds}{The duration, in seconds, of the role session. The value specified can
range from 900 seconds (15 minutes) up to the maximum session duration
set for the role. The maximum session duration setting can have a value
from 1 hour to 12 hours. If you specify a value higher than this setting
or the administrator setting (whichever is lower), the operation fails.
For example, if you specify a session duration of 12 hours, but your
administrator set the maximum session duration to 6 hours, your
operation fails.

Role chaining limits your Amazon Web Services CLI or Amazon Web Services
API role session to a maximum of one hour. When you use the
\code{\link[=sts_assume_role]{assume_role}} API operation to assume a role, you can
specify the duration of your role session with the \code{DurationSeconds}
parameter. You can specify a parameter value of up to 43200 seconds (12
hours), depending on the maximum session duration setting for your role.
However, if you assume a role using role chaining and provide a
\code{DurationSeconds} parameter value greater than one hour, the operation
fails. To learn how to view the maximum value for your role, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use.html#id_roles_use_view-role-max-session}{View the Maximum Session Duration Setting for a Role}
in the \emph{IAM User Guide}.

By default, the value is set to \code{3600} seconds.

The \code{DurationSeconds} parameter is separate from the duration of a
console session that you might request using the returned credentials.
The request to the federation endpoint for a console sign-in token takes
a \code{SessionDuration} parameter that specifies the maximum length of the
console session. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-custom-url.html}{Creating a URL that Enables Federated Users to Access the Amazon Web Services Management Console}
in the \emph{IAM User Guide}.}

\item{Tags}{A list of session tags that you want to pass. Each session tag consists
of a key name and an associated value. For more information about
session tags, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html}{Tagging Amazon Web Services STS Sessions}
in the \emph{IAM User Guide}.

This parameter is optional. You can pass up to 50 session tags. The
plaintext session tag keys can’t exceed 128 characters, and the values
can’t exceed 256 characters. For these and additional limits, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-limits-entity-length}{IAM and STS Character Limits}
in the \emph{IAM User Guide}.

An Amazon Web Services conversion compresses the passed inline session
policy, managed policy ARNs, and session tags into a packed binary
format that has a separate limit. Your request can fail for this limit
even if your plaintext meets the other requirements. The
\code{PackedPolicySize} response element indicates by percentage how close
the policies and tags for your request are to the upper size limit.

You can pass a session tag with the same key as a tag that is already
attached to the role. When you do, session tags override a role tag with
the same key.

Tag key–value pairs are not case sensitive, but case is preserved. This
means that you cannot have separate \code{Department} and \code{department} tag
keys. Assume that the role has the \code{Department}=\code{Marketing} tag and you
pass the \code{department}=\code{engineering} session tag. \code{Department} and
\code{department} are not saved as separate tags, and the session tag passed
in the request takes precedence over the role tag.

Additionally, if you used temporary credentials to perform this
operation, the new session inherits any transitive session tags from the
calling session. If you pass a session tag with the same key as an
inherited tag, the operation fails. To view the inherited tags for a
session, see the CloudTrail logs. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html#id_session-tags_ctlogs}{Viewing Session Tags in CloudTrail}
in the \emph{IAM User Guide}.}

\item{TransitiveTagKeys}{A list of keys for session tags that you want to set as transitive. If
you set a tag key as transitive, the corresponding key and value passes
to subsequent sessions in a role chain. For more information, see
\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_session-tags.html#id_session-tags_role-chaining}{Chaining Roles with Session Tags}
in the \emph{IAM User Guide}.

This parameter is optional. When you set session tags as transitive, the
session policy and session tags packed binary limit is not affected.

If you choose not to specify a transitive tag key, then no tags are
passed from this session to any subsequent sessions.}

\item{ExternalId}{A unique identifier that might be required when you assume a role in
another account. If the administrator of the account to which the role
belongs provided you with an external ID, then provide that value in the
\code{ExternalId} parameter. This value can be any string, such as a
passphrase or account number. A cross-account role is usually set up to
trust everyone in an account. Therefore, the administrator of the
trusting account might send an external ID to the administrator of the
trusted account. That way, only someone with the ID can assume the role,
rather than everyone in the account. For more information about the
external ID, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create_for-user_externalid.html}{How to Use an External ID When Granting Access to Your Amazon Web Services Resources to a Third Party}
in the \emph{IAM User Guide}.

The regex used to validate this parameter is a string of characters
consisting of upper- and lower-case alphanumeric characters with no
spaces. You can also include underscores or any of the following
characters: =,.@:/-}

\item{SerialNumber}{The identification number of the MFA device that is associated with the
user who is making the \code{\link[=sts_assume_role]{assume_role}} call. Specify
this value if the trust policy of the role being assumed includes a
condition that requires MFA authentication. The value is either the
serial number for a hardware device (such as \code{GAHT12345678}) or an
Amazon Resource Name (ARN) for a virtual device (such as
\verb{arn:aws:iam::123456789012:mfa/user}).

The regex used to validate this parameter is a string of characters
consisting of upper- and lower-case alphanumeric characters with no
spaces. You can also include underscores or any of the following
characters: =,.@-}

\item{TokenCode}{The value provided by the MFA device, if the trust policy of the role
being assumed requires MFA. (In other words, if the policy includes a
condition that tests for MFA). If the role being assumed requires MFA
and if the \code{TokenCode} value is missing or expired, the
\code{\link[=sts_assume_role]{assume_role}} call returns an "access denied" error.

The format for this parameter, as described by its regex pattern, is a
sequence of six numeric digits.}

\item{SourceIdentity}{The source identity specified by the principal that is calling the
\code{\link[=sts_assume_role]{assume_role}} operation.

You can require users to specify a source identity when they assume a
role. You do this by using the \code{sts:SourceIdentity} condition key in a
role trust policy. You can use source identity information in CloudTrail
logs to determine who took actions with a role. You can use the
\code{aws:SourceIdentity} condition key to further control access to Amazon
Web Services resources based on the value of source identity. For more
information about using source identity, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_control-access_monitor.html}{Monitor and control actions taken with assumed roles}
in the \emph{IAM User Guide}.

The regex used to validate this parameter is a string of characters
consisting of upper- and lower-case alphanumeric characters with no
spaces. You can also include underscores or any of the following
characters: =,.@-. You cannot use a value that begins with the text
\verb{aws:}. This prefix is reserved for Amazon Web Services internal use.}

\item{ProvidedContexts}{Reserved for future use.}
}
\description{
Returns a set of temporary security credentials that you can use to access Amazon Web Services resources. These temporary credentials consist of an access key ID, a secret access key, and a security token. Typically, you use \code{\link[=sts_assume_role]{assume_role}} within your account or for cross-account access. For a comparison of \code{\link[=sts_assume_role]{assume_role}} with other API operations that produce temporary credentials, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html}{Requesting Temporary Security Credentials} and \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_request.html#stsapi_comparison}{Comparing the Amazon Web Services STS API operations} in the \emph{IAM User Guide}.

See \url{https://www.paws-r-sdk.com/docs/sts_assume_role/} for full documentation.
}
\keyword{internal}
