% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_retire_grant}
\alias{kms_retire_grant}
\title{Retires a grant}
\usage{
kms_retire_grant(GrantToken, KeyId, GrantId)
}
\arguments{
\item{GrantToken}{Token that identifies the grant to be retired.}

\item{KeyId}{The Amazon Resource Name (ARN) of the CMK associated with the grant.

For example:
\verb{arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab}}

\item{GrantId}{Unique identifier of the grant to retire. The grant ID is returned in
the response to a \code{CreateGrant} operation.
\itemize{
\item Grant ID Example -
0123456789012345678901234567890123456789012345678901234567890123
}}
}
\description{
Retires a grant. To clean up, you can retire a grant when you\'re done
using it. You should revoke a grant when you intend to actively deny
operations that depend on it. The following are permitted to call this
API:
}
\details{
\itemize{
\item The AWS account (root user) under which the grant was created
\item The \code{RetiringPrincipal}, if present in the grant
\item The \code{GranteePrincipal}, if \code{RetireGrant} is an operation specified
in the grant
}

You must identify the grant to retire by its grant token or by a
combination of the grant ID and the Amazon Resource Name (ARN) of the
customer master key (CMK). A grant token is a unique variable-length
base64-encoded string. A grant ID is a 64 character unique identifier of
a grant. The CreateGrant operation returns both.
}
\section{Request syntax}{
\preformatted{svc$retire_grant(
  GrantToken = "string",
  KeyId = "string",
  GrantId = "string"
)
}
}

\examples{
# The following example retires a grant.
\dontrun{svc$retire_grant(
  GrantId = "0c237476b39f8bc44e45212e08498fbe3151305030726c0590dd8d3e9f3d6a60",
  KeyId = "arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab"
)}

}
\keyword{internal}
