% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_get_change_token_status}
\alias{waf_get_change_token_status}
\title{Returns the status of a ChangeToken that you got by calling
GetChangeToken}
\usage{
waf_get_change_token_status(ChangeToken)
}
\arguments{
\item{ChangeToken}{[required] The change token for which you want to get the status. This change token
was previously returned in the \code{GetChangeToken} response.}
}
\description{
Returns the status of a \code{ChangeToken} that you got by calling
GetChangeToken. \code{ChangeTokenStatus} is one of the following values:
}
\details{
\itemize{
\item \code{PROVISIONED}: You requested the change token by calling
\code{GetChangeToken}, but you haven\'t used it yet in a call to create,
update, or delete an AWS WAF object.
\item \code{PENDING}: AWS WAF is propagating the create, update, or delete
request to all AWS WAF servers.
\item \code{INSYNC}: Propagation is complete.
}
}
\section{Request syntax}{
\preformatted{svc$get_change_token_status(
  ChangeToken = "string"
)
}
}

\examples{
# The following example returns the status of a change token with the ID
# abcd12f2-46da-4fdb-b8d5-fbd4c466928f.
\donttest{svc$get_change_token_status(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f"
)}

}
\keyword{internal}
