% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_initiate_auth}
\alias{cognitoidentityprovider_initiate_auth}
\title{Initiates the authentication flow}
\usage{
cognitoidentityprovider_initiate_auth(AuthFlow, AuthParameters,
  ClientMetadata, ClientId, AnalyticsMetadata, UserContextData)
}
\arguments{
\item{AuthFlow}{[required] The authentication flow for this call to execute. The API action will
depend on this value. For example:
\itemize{
\item \code{REFRESH_TOKEN_AUTH} will take in a valid refresh token and return
new tokens.
\item \code{USER_SRP_AUTH} will take in \code{USERNAME} and \code{SRP_A} and return the
SRP variables to be used for next challenge execution.
\item \code{USER_PASSWORD_AUTH} will take in \code{USERNAME} and \code{PASSWORD} and
return the next challenge or tokens.
}

Valid values include:
\itemize{
\item \code{USER_SRP_AUTH}: Authentication flow for the Secure Remote Password
(SRP) protocol.
\item \code{REFRESH_TOKEN_AUTH}/\code{REFRESH_TOKEN}: Authentication flow for
refreshing the access token and ID token by supplying a valid
refresh token.
\item \code{CUSTOM_AUTH}: Custom authentication flow.
\item \code{USER_PASSWORD_AUTH}: Non-SRP authentication flow; USERNAME and
PASSWORD are passed directly. If a user migration Lambda trigger is
set, this flow will invoke the user migration Lambda if the USERNAME
is not found in the user pool.
}

\code{ADMIN_NO_SRP_AUTH} is not a valid value.}

\item{AuthParameters}{The authentication parameters. These are inputs corresponding to the
\code{AuthFlow} that you are invoking. The required values depend on the
value of \code{AuthFlow}:
\itemize{
\item For \code{USER_SRP_AUTH}: \code{USERNAME} (required), \code{SRP_A} (required),
\code{SECRET_HASH} (required if the app client is configured with a
client secret), \code{DEVICE_KEY}
\item For \code{REFRESH_TOKEN_AUTH/REFRESH_TOKEN}: \code{REFRESH_TOKEN} (required),
\code{SECRET_HASH} (required if the app client is configured with a
client secret), \code{DEVICE_KEY}
\item For \code{CUSTOM_AUTH}: \code{USERNAME} (required), \code{SECRET_HASH} (if app
client is configured with client secret), \code{DEVICE_KEY}
}}

\item{ClientMetadata}{This is a random key-value pair map which can contain any key and will
be passed to your PreAuthentication Lambda trigger as-is. It can be used
to implement additional validations around authentication.}

\item{ClientId}{[required] The app client ID.}

\item{AnalyticsMetadata}{The Amazon Pinpoint analytics metadata for collecting metrics for
\code{InitiateAuth} calls.}

\item{UserContextData}{Contextual data such as the user's device fingerprint, IP address, or
location used for evaluating the risk of an unexpected event by Amazon
Cognito advanced security.}
}
\description{
Initiates the authentication flow.
}
\section{Request syntax}{
\preformatted{svc$initiate_auth(
  AuthFlow = "USER_SRP_AUTH"|"REFRESH_TOKEN_AUTH"|"REFRESH_TOKEN"|"CUSTOM_AUTH"|"ADMIN_NO_SRP_AUTH"|"USER_PASSWORD_AUTH",
  AuthParameters = list(
    "string"
  ),
  ClientMetadata = list(
    "string"
  ),
  ClientId = "string",
  AnalyticsMetadata = list(
    AnalyticsEndpointId = "string"
  ),
  UserContextData = list(
    EncodedData = "string"
  )
)
}
}

\keyword{internal}
