# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include kms_service.R
NULL

#' Cancels the deletion of a customer master key (CMK)
#'
#' Cancels the deletion of a customer master key (CMK). When this operation
#' is successful, the CMK is set to the `Disabled` state. To enable a CMK,
#' use EnableKey. You cannot perform this operation on a CMK in a different
#' AWS account.
#' 
#' For more information about scheduling and canceling deletion of a CMK,
#' see [Deleting Customer Master
#' Keys](https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_cancel_key_deletion(KeyId)
#'
#' @param KeyId &#91;required&#93; The unique identifier for the customer master key (CMK) for which to
#' cancel deletion.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_key_deletion(
#'   KeyId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example cancels deletion of the specified CMK.
#' \donttest{svc$cancel_key_deletion(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_cancel_key_deletion
kms_cancel_key_deletion <- function(KeyId) {
  op <- new_operation(
    name = "CancelKeyDeletion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$cancel_key_deletion_input(KeyId = KeyId)
  output <- .kms$cancel_key_deletion_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$cancel_key_deletion <- kms_cancel_key_deletion

#' Connects or reconnects a custom key store to its associated AWS CloudHSM
#' cluster
#'
#' Connects or reconnects a [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' to its associated AWS CloudHSM cluster.
#' 
#' The custom key store must be connected before you can create customer
#' master keys (CMKs) in the key store or use the CMKs it contains. You can
#' disconnect and reconnect a custom key store at any time.
#' 
#' To connect a custom key store, its associated AWS CloudHSM cluster must
#' have at least one active HSM. To get the number of active HSMs in a
#' cluster, use the
#' [DescribeClusters](https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html)
#' operation. To add HSMs to the cluster, use the
#' [CreateHsm](https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_CreateHsm.html)
#' operation.
#' 
#' The connection process can take an extended amount of time to complete;
#' up to 20 minutes. This operation starts the connection process, but it
#' does not wait for it to complete. When it succeeds, this operation
#' quickly returns an HTTP 200 response and a JSON object with no
#' properties. However, this response does not indicate that the custom key
#' store is connected. To get the connection state of the custom key store,
#' use the DescribeCustomKeyStores operation.
#' 
#' During the connection process, AWS KMS finds the AWS CloudHSM cluster
#' that is associated with the custom key store, creates the connection
#' infrastructure, connects to the cluster, logs into the AWS CloudHSM
#' client as the [`kmsuser` crypto
#' user](https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser)
#' (CU), and rotates its password.
#' 
#' The `ConnectCustomKeyStore` operation might fail for various reasons. To
#' find the reason, use the DescribeCustomKeyStores operation and see the
#' `ConnectionErrorCode` in the response. For help interpreting the
#' `ConnectionErrorCode`, see CustomKeyStoresListEntry.
#' 
#' To fix the failure, use the DisconnectCustomKeyStore operation to
#' disconnect the custom key store, correct the error, use the
#' UpdateCustomKeyStore operation if necessary, and then use
#' `ConnectCustomKeyStore` again.
#' 
#' If you are having trouble connecting or disconnecting a custom key
#' store, see [Troubleshooting a Custom Key
#' Store](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_connect_custom_key_store(CustomKeyStoreId)
#'
#' @param CustomKeyStoreId &#91;required&#93; Enter the key store ID of the custom key store that you want to connect.
#' To find the ID of a custom key store, use the DescribeCustomKeyStores
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$connect_custom_key_store(
#'   CustomKeyStoreId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kms_connect_custom_key_store
kms_connect_custom_key_store <- function(CustomKeyStoreId) {
  op <- new_operation(
    name = "ConnectCustomKeyStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$connect_custom_key_store_input(CustomKeyStoreId = CustomKeyStoreId)
  output <- .kms$connect_custom_key_store_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$connect_custom_key_store <- kms_connect_custom_key_store

#' Creates a display name for a customer managed customer master key (CMK)
#'
#' Creates a display name for a customer managed customer master key (CMK).
#' You can use an alias to identify a CMK in selected operations, such as
#' Encrypt and GenerateDataKey.
#' 
#' Each CMK can have multiple aliases, but each alias points to only one
#' CMK. The alias name must be unique in the AWS account and region. To
#' simplify code that runs in multiple regions, use the same alias name,
#' but point it to a different CMK in each region.
#' 
#' Because an alias is not a property of a CMK, you can delete and change
#' the aliases of a CMK without affecting the CMK. Also, aliases do not
#' appear in the response from the DescribeKey operation. To get the
#' aliases of all CMKs, use the ListAliases operation.
#' 
#' The alias name must begin with `alias/` followed by a name, such as
#' `alias/ExampleAlias`. It can contain only alphanumeric characters,
#' forward slashes (/), underscores (\\_), and dashes (-). The alias name
#' cannot begin with `alias/aws/`. The `alias/aws/` prefix is reserved for
#' [AWS managed
#' CMKs](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
#' 
#' The alias and the CMK it is mapped to must be in the same AWS account
#' and the same region. You cannot perform this operation on an alias in a
#' different AWS account.
#' 
#' To map an existing alias to a different CMK, call UpdateAlias.
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_create_alias(AliasName, TargetKeyId)
#'
#' @param AliasName &#91;required&#93; Specifies the alias name. This value must begin with `alias/` followed
#' by a name, such as `alias/ExampleAlias`. The alias name cannot begin
#' with `alias/aws/`. The `alias/aws/` prefix is reserved for AWS managed
#' CMKs.
#' @param TargetKeyId &#91;required&#93; Identifies the CMK to which the alias refers. Specify the key ID or the
#' Amazon Resource Name (ARN) of the CMK. You cannot specify another alias.
#' For help finding the key ID and ARN, see [Finding the Key ID and
#' ARN](https://docs.aws.amazon.com/kms/latest/developerguide/viewing-keys.html#find-cmk-id-arn)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$create_alias(
#'   AliasName = "string",
#'   TargetKeyId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example creates an alias for the specified customer master
#' # key (CMK).
#' \donttest{svc$create_alias(
#'   AliasName = "alias/ExampleAlias",
#'   TargetKeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_create_alias
kms_create_alias <- function(AliasName, TargetKeyId) {
  op <- new_operation(
    name = "CreateAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$create_alias_input(AliasName = AliasName, TargetKeyId = TargetKeyId)
  output <- .kms$create_alias_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$create_alias <- kms_create_alias

#' Creates a custom key store that is associated with an AWS CloudHSM
#' cluster that you own and manage
#'
#' Creates a [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' that is associated with an [AWS CloudHSM
#' cluster](https://docs.aws.amazon.com/cloudhsm/latest/userguide/clusters.html)
#' that you own and manage.
#' 
#' This operation is part of the [Custom Key Store
#' feature](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' feature in AWS KMS, which combines the convenience and extensive
#' integration of AWS KMS with the isolation and control of a single-tenant
#' key store.
#' 
#' Before you create the custom key store, you must assemble the required
#' elements, including an AWS CloudHSM cluster that fulfills the
#' requirements for a custom key store. For details about the required
#' elements, see [Assemble the
#' Prerequisites](https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' When the operation completes successfully, it returns the ID of the new
#' custom key store. Before you can use your new custom key store, you need
#' to use the ConnectCustomKeyStore operation to connect the new key store
#' to its AWS CloudHSM cluster. Even if you are not going to use your
#' custom key store immediately, you might want to connect it to verify
#' that all settings are correct and then disconnect it until you are ready
#' to use it.
#' 
#' For help with failures, see [Troubleshooting a Custom Key
#' Store](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_create_custom_key_store(CustomKeyStoreName, CloudHsmClusterId,
#'   TrustAnchorCertificate, KeyStorePassword)
#'
#' @param CustomKeyStoreName &#91;required&#93; Specifies a friendly name for the custom key store. The name must be
#' unique in your AWS account.
#' @param CloudHsmClusterId &#91;required&#93; Identifies the AWS CloudHSM cluster for the custom key store. Enter the
#' cluster ID of any active AWS CloudHSM cluster that is not already
#' associated with a custom key store. To find the cluster ID, use the
#' [DescribeClusters](https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html)
#' operation.
#' @param TrustAnchorCertificate &#91;required&#93; Enter the content of the trust anchor certificate for the cluster. This
#' is the content of the `customerCA.crt` file that you created when you
#' [initialized the
#' cluster](https://docs.aws.amazon.com/cloudhsm/latest/userguide/initialize-cluster.html).
#' @param KeyStorePassword &#91;required&#93; Enter the password of the [`kmsuser` crypto user (CU)
#' account](https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser)
#' in the specified AWS CloudHSM cluster. AWS KMS logs into the cluster as
#' this user to manage key material on your behalf.
#' 
#' This parameter tells AWS KMS the `kmsuser` account password; it does not
#' change the password in the AWS CloudHSM cluster.
#'
#' @section Request syntax:
#' ```
#' svc$create_custom_key_store(
#'   CustomKeyStoreName = "string",
#'   CloudHsmClusterId = "string",
#'   TrustAnchorCertificate = "string",
#'   KeyStorePassword = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kms_create_custom_key_store
kms_create_custom_key_store <- function(CustomKeyStoreName, CloudHsmClusterId, TrustAnchorCertificate, KeyStorePassword) {
  op <- new_operation(
    name = "CreateCustomKeyStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$create_custom_key_store_input(CustomKeyStoreName = CustomKeyStoreName, CloudHsmClusterId = CloudHsmClusterId, TrustAnchorCertificate = TrustAnchorCertificate, KeyStorePassword = KeyStorePassword)
  output <- .kms$create_custom_key_store_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$create_custom_key_store <- kms_create_custom_key_store

#' Adds a grant to a customer master key (CMK)
#'
#' Adds a grant to a customer master key (CMK). The grant allows the
#' grantee principal to use the CMK when the conditions specified in the
#' grant are met. When setting permissions, grants are an alternative to
#' key policies.
#' 
#' To create a grant that allows a cryptographic operation only when the
#' encryption context in the operation request matches or includes a
#' specified encryption context, use the `Constraints` parameter. For
#' details, see GrantConstraints.
#' 
#' To perform this operation on a CMK in a different AWS account, specify
#' the key ARN in the value of the `KeyId` parameter. For more information
#' about grants, see
#' [Grants](https://docs.aws.amazon.com/kms/latest/developerguide/grants.html)
#' in the **AWS Key Management Service Developer Guide** .
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_create_grant(KeyId, GranteePrincipal, RetiringPrincipal, Operations,
#'   Constraints, GrantTokens, Name)
#'
#' @param KeyId &#91;required&#93; The unique identifier for the customer master key (CMK) that the grant
#' applies to.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To
#' specify a CMK in a different AWS account, you must use the key ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param GranteePrincipal &#91;required&#93; The principal that is given permission to perform the operations that
#' the grant permits.
#' 
#' To specify the principal, use the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of an AWS principal. Valid AWS principals include AWS accounts (root),
#' IAM users, IAM roles, federated users, and assumed role users. For
#' examples of the ARN syntax to use for specifying a principal, see [AWS
#' Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam)
#' in the Example ARNs section of the *AWS General Reference*.
#' @param RetiringPrincipal The principal that is given permission to retire the grant by using
#' RetireGrant operation.
#' 
#' To specify the principal, use the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of an AWS principal. Valid AWS principals include AWS accounts (root),
#' IAM users, federated users, and assumed role users. For examples of the
#' ARN syntax to use for specifying a principal, see [AWS Identity and
#' Access Management
#' (IAM)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam)
#' in the Example ARNs section of the *AWS General Reference*.
#' @param Operations &#91;required&#93; A list of operations that the grant permits.
#' @param Constraints Allows a cryptographic operation only when the encryption context
#' matches or includes the encryption context specified in this structure.
#' For more information about encryption context, see [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the **AWS Key Management Service Developer Guide** .
#' @param GrantTokens A list of grant tokens.
#' 
#' For more information, see [Grant
#' Tokens](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
#' in the *AWS Key Management Service Developer Guide*.
#' @param Name A friendly name for identifying the grant. Use this value to prevent the
#' unintended creation of duplicate grants when retrying this request.
#' 
#' When this value is absent, all `CreateGrant` requests result in a new
#' grant with a unique `GrantId` even if all the supplied parameters are
#' identical. This can result in unintended duplicates when you retry the
#' `CreateGrant` request.
#' 
#' When this value is present, you can retry a `CreateGrant` request with
#' identical parameters; if the grant already exists, the original
#' `GrantId` is returned without creating a new grant. Note that the
#' returned grant token is unique with every `CreateGrant` request, even
#' when a duplicate `GrantId` is returned. All grant tokens obtained in
#' this way can be used interchangeably.
#'
#' @section Request syntax:
#' ```
#' svc$create_grant(
#'   KeyId = "string",
#'   GranteePrincipal = "string",
#'   RetiringPrincipal = "string",
#'   Operations = list(
#'     "Decrypt"|"Encrypt"|"GenerateDataKey"|"GenerateDataKeyWithoutPlaintext"|"ReEncryptFrom"|"ReEncryptTo"|"CreateGrant"|"RetireGrant"|"DescribeKey"
#'   ),
#'   Constraints = list(
#'     EncryptionContextSubset = list(
#'       "string"
#'     ),
#'     EncryptionContextEquals = list(
#'       "string"
#'     )
#'   ),
#'   GrantTokens = list(
#'     "string"
#'   ),
#'   Name = "string"
#' )
#' ```
#'
#' @examples
#' # The following example creates a grant that allows the specified IAM role
#' # to encrypt data with the specified customer master key (CMK).
#' \donttest{svc$create_grant(
#'   GranteePrincipal = "arn:aws:iam::111122223333:role/ExampleRole",
#'   KeyId = "arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab",
#'   Operations = list(
#'     "Encrypt",
#'     "Decrypt"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_create_grant
kms_create_grant <- function(KeyId, GranteePrincipal, RetiringPrincipal = NULL, Operations, Constraints = NULL, GrantTokens = NULL, Name = NULL) {
  op <- new_operation(
    name = "CreateGrant",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$create_grant_input(KeyId = KeyId, GranteePrincipal = GranteePrincipal, RetiringPrincipal = RetiringPrincipal, Operations = Operations, Constraints = Constraints, GrantTokens = GrantTokens, Name = Name)
  output <- .kms$create_grant_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$create_grant <- kms_create_grant

#' Creates a customer managed customer master key (CMK) in your AWS account
#'
#' Creates a customer managed [customer master
#' key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys)
#' (CMK) in your AWS account.
#' 
#' You can use a CMK to encrypt small amounts of data (up to 4096 bytes)
#' directly. But CMKs are more commonly used to encrypt the [data
#' keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#data-keys)
#' that are used to encrypt data.
#' 
#' To create a CMK for imported key material, use the `Origin` parameter
#' with a value of `EXTERNAL`.
#' 
#' To create a CMK in a [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html),
#' use the `CustomKeyStoreId` parameter to specify the custom key store.
#' You must also use the `Origin` parameter with a value of `AWS_CLOUDHSM`.
#' The AWS CloudHSM cluster that is associated with the custom key store
#' must have at least two active HSMs in different Availability Zones in
#' the AWS Region.
#' 
#' You cannot use this operation to create a CMK in a different AWS
#' account.
#'
#' @usage
#' kms_create_key(Policy, Description, KeyUsage, Origin, CustomKeyStoreId,
#'   BypassPolicyLockoutSafetyCheck, Tags)
#'
#' @param Policy The key policy to attach to the CMK.
#' 
#' If you provide a key policy, it must meet the following criteria:
#' 
#' -   If you don\'t set `BypassPolicyLockoutSafetyCheck` to true, the key
#'     policy must allow the principal that is making the `CreateKey`
#'     request to make a subsequent PutKeyPolicy request on the CMK. This
#'     reduces the risk that the CMK becomes unmanageable. For more
#'     information, refer to the scenario in the [Default Key
#'     Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
#'     section of the **AWS Key Management Service Developer Guide** .
#' 
#' -   Each statement in the key policy must contain one or more
#'     principals. The principals in the key policy must exist and be
#'     visible to AWS KMS. When you create a new AWS principal (for
#'     example, an IAM user or role), you might need to enforce a delay
#'     before including the new principal in a key policy because the new
#'     principal might not be immediately visible to AWS KMS. For more
#'     information, see [Changes that I make are not always immediately
#'     visible](https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency)
#'     in the *AWS Identity and Access Management User Guide*.
#' 
#' If you do not provide a key policy, AWS KMS attaches a default key
#' policy to the CMK. For more information, see [Default Key
#' Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' The key policy size limit is 32 kilobytes (32768 bytes).
#' @param Description A description of the CMK.
#' 
#' Use a description that helps you decide whether the CMK is appropriate
#' for a task.
#' @param KeyUsage The cryptographic operations for which you can use the CMK. The only
#' valid value is `ENCRYPT_DECRYPT`, which means you can use the CMK to
#' encrypt and decrypt data.
#' @param Origin The source of the key material for the CMK. You cannot change the origin
#' after you create the CMK.
#' 
#' The default is `AWS_KMS`, which means AWS KMS creates the key material
#' in its own key store.
#' 
#' When the parameter value is `EXTERNAL`, AWS KMS creates a CMK without
#' key material so that you can import key material from your existing key
#' management infrastructure. For more information about importing key
#' material into AWS KMS, see [Importing Key
#' Material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' When the parameter value is `AWS_CLOUDHSM`, AWS KMS creates the CMK in
#' an AWS KMS [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' and creates its key material in the associated AWS CloudHSM cluster. You
#' must also use the `CustomKeyStoreId` parameter to identify the custom
#' key store.
#' @param CustomKeyStoreId Creates the CMK in the specified [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' and the key material in its associated AWS CloudHSM cluster. To create a
#' CMK in a custom key store, you must also specify the `Origin` parameter
#' with a value of `AWS_CLOUDHSM`. The AWS CloudHSM cluster that is
#' associated with the custom key store must have at least two active HSMs,
#' each in a different Availability Zone in the Region.
#' 
#' To find the ID of a custom key store, use the DescribeCustomKeyStores
#' operation.
#' 
#' The response includes the custom key store ID and the ID of the AWS
#' CloudHSM cluster.
#' 
#' This operation is part of the [Custom Key Store
#' feature](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' feature in AWS KMS, which combines the convenience and extensive
#' integration of AWS KMS with the isolation and control of a single-tenant
#' key store.
#' @param BypassPolicyLockoutSafetyCheck A flag to indicate whether to bypass the key policy lockout safety
#' check.
#' 
#' Setting this value to true increases the risk that the CMK becomes
#' unmanageable. Do not set this value to true indiscriminately.
#' 
#' For more information, refer to the scenario in the [Default Key
#' Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
#' section in the **AWS Key Management Service Developer Guide** .
#' 
#' Use this parameter only when you include a policy in the request and you
#' intend to prevent the principal that is making the request from making a
#' subsequent PutKeyPolicy request on the CMK.
#' 
#' The default value is false.
#' @param Tags One or more tags. Each tag consists of a tag key and a tag value. Tag
#' keys and tag values are both required, but tag values can be empty
#' (null) strings.
#' 
#' Use this parameter to tag the CMK when it is created. Alternately, you
#' can omit this parameter and instead tag the CMK after it is created
#' using TagResource.
#'
#' @section Request syntax:
#' ```
#' svc$create_key(
#'   Policy = "string",
#'   Description = "string",
#'   KeyUsage = "ENCRYPT_DECRYPT",
#'   Origin = "AWS_KMS"|"EXTERNAL"|"AWS_CLOUDHSM",
#'   CustomKeyStoreId = "string",
#'   BypassPolicyLockoutSafetyCheck = TRUE|FALSE,
#'   Tags = list(
#'     list(
#'       TagKey = "string",
#'       TagValue = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example creates a CMK.
#' \donttest{svc$create_key(
#'   Tags = list(
#'     list(
#'       TagKey = "CreatedBy",
#'       TagValue = "ExampleUser"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_create_key
kms_create_key <- function(Policy = NULL, Description = NULL, KeyUsage = NULL, Origin = NULL, CustomKeyStoreId = NULL, BypassPolicyLockoutSafetyCheck = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$create_key_input(Policy = Policy, Description = Description, KeyUsage = KeyUsage, Origin = Origin, CustomKeyStoreId = CustomKeyStoreId, BypassPolicyLockoutSafetyCheck = BypassPolicyLockoutSafetyCheck, Tags = Tags)
  output <- .kms$create_key_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$create_key <- kms_create_key

#' Decrypts ciphertext
#'
#' Decrypts ciphertext. Ciphertext is plaintext that has been previously
#' encrypted by using any of the following operations:
#' 
#' -   GenerateDataKey
#' 
#' -   GenerateDataKeyWithoutPlaintext
#' 
#' -   Encrypt
#' 
#' Whenever possible, use key policies to give users permission to call the
#' Decrypt operation on the CMK, instead of IAM policies. Otherwise, you
#' might create an IAM user policy that gives the user Decrypt permission
#' on all CMKs. This user could decrypt ciphertext that was encrypted by
#' CMKs in other accounts if the key policy for the cross-account CMK
#' permits it. If you must use an IAM policy for `Decrypt` permissions,
#' limit the user to particular CMKs or particular trusted accounts.
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_decrypt(CiphertextBlob, EncryptionContext, GrantTokens)
#'
#' @param CiphertextBlob &#91;required&#93; Ciphertext to be decrypted. The blob includes metadata.
#' @param EncryptionContext The encryption context. If this was specified in the Encrypt function,
#' it must be specified here or the decryption operation will fail. For
#' more information, see [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context).
#' @param GrantTokens A list of grant tokens.
#' 
#' For more information, see [Grant
#' Tokens](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$decrypt(
#'   CiphertextBlob = raw,
#'   EncryptionContext = list(
#'     "string"
#'   ),
#'   GrantTokens = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example decrypts data that was encrypted with a customer
#' # master key (CMK) in AWS KMS.
#' \donttest{svc$decrypt(
#'   CiphertextBlob = "<binary data>"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_decrypt
kms_decrypt <- function(CiphertextBlob, EncryptionContext = NULL, GrantTokens = NULL) {
  op <- new_operation(
    name = "Decrypt",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$decrypt_input(CiphertextBlob = CiphertextBlob, EncryptionContext = EncryptionContext, GrantTokens = GrantTokens)
  output <- .kms$decrypt_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$decrypt <- kms_decrypt

#' Deletes the specified alias
#'
#' Deletes the specified alias. You cannot perform this operation on an
#' alias in a different AWS account.
#' 
#' Because an alias is not a property of a CMK, you can delete and change
#' the aliases of a CMK without affecting the CMK. Also, aliases do not
#' appear in the response from the DescribeKey operation. To get the
#' aliases of all CMKs, use the ListAliases operation.
#' 
#' Each CMK can have multiple aliases. To change the alias of a CMK, use
#' DeleteAlias to delete the current alias and CreateAlias to create a new
#' alias. To associate an existing alias with a different customer master
#' key (CMK), call UpdateAlias.
#'
#' @usage
#' kms_delete_alias(AliasName)
#'
#' @param AliasName &#91;required&#93; The alias to be deleted. The alias name must begin with `alias/`
#' followed by the alias name, such as `alias/ExampleAlias`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_alias(
#'   AliasName = "string"
#' )
#' ```
#'
#' @examples
#' # The following example deletes the specified alias.
#' \donttest{svc$delete_alias(
#'   AliasName = "alias/ExampleAlias"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_delete_alias
kms_delete_alias <- function(AliasName) {
  op <- new_operation(
    name = "DeleteAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$delete_alias_input(AliasName = AliasName)
  output <- .kms$delete_alias_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$delete_alias <- kms_delete_alias

#' Deletes a custom key store
#'
#' Deletes a [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
#' This operation does not delete the AWS CloudHSM cluster that is
#' associated with the custom key store, or affect any users or keys in the
#' cluster.
#' 
#' The custom key store that you delete cannot contain any AWS KMS
#' [customer master keys
#' (CMKs)](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys).
#' Before deleting the key store, verify that you will never need to use
#' any of the CMKs in the key store for any cryptographic operations. Then,
#' use ScheduleKeyDeletion to delete the AWS KMS customer master keys
#' (CMKs) from the key store. When the scheduled waiting period expires,
#' the `ScheduleKeyDeletion` operation deletes the CMKs. Then it makes a
#' best effort to delete the key material from the associated cluster.
#' However, you might need to manually [delete the orphaned key
#' material](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-orphaned-key)
#' from the cluster and its backups.
#' 
#' After all CMKs are deleted from AWS KMS, use DisconnectCustomKeyStore to
#' disconnect the key store from AWS KMS. Then, you can delete the custom
#' key store.
#' 
#' Instead of deleting the custom key store, consider using
#' DisconnectCustomKeyStore to disconnect it from AWS KMS. While the key
#' store is disconnected, you cannot create or use the CMKs in the key
#' store. But, you do not need to delete CMKs and you can reconnect a
#' disconnected custom key store at any time.
#' 
#' If the operation succeeds, it returns a JSON object with no properties.
#' 
#' This operation is part of the [Custom Key Store
#' feature](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' feature in AWS KMS, which combines the convenience and extensive
#' integration of AWS KMS with the isolation and control of a single-tenant
#' key store.
#'
#' @usage
#' kms_delete_custom_key_store(CustomKeyStoreId)
#'
#' @param CustomKeyStoreId &#91;required&#93; Enter the ID of the custom key store you want to delete. To find the ID
#' of a custom key store, use the DescribeCustomKeyStores operation.
#'
#' @section Request syntax:
#' ```
#' svc$delete_custom_key_store(
#'   CustomKeyStoreId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kms_delete_custom_key_store
kms_delete_custom_key_store <- function(CustomKeyStoreId) {
  op <- new_operation(
    name = "DeleteCustomKeyStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$delete_custom_key_store_input(CustomKeyStoreId = CustomKeyStoreId)
  output <- .kms$delete_custom_key_store_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$delete_custom_key_store <- kms_delete_custom_key_store

#' Deletes key material that you previously imported
#'
#' Deletes key material that you previously imported. This operation makes
#' the specified customer master key (CMK) unusable. For more information
#' about importing key material into AWS KMS, see [Importing Key
#' Material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
#' in the *AWS Key Management Service Developer Guide*. You cannot perform
#' this operation on a CMK in a different AWS account.
#' 
#' When the specified CMK is in the `PendingDeletion` state, this operation
#' does not change the CMK\'s state. Otherwise, it changes the CMK\'s state
#' to `PendingImport`.
#' 
#' After you delete key material, you can use ImportKeyMaterial to reimport
#' the same key material into the CMK.
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_delete_imported_key_material(KeyId)
#'
#' @param KeyId &#91;required&#93; Identifies the CMK from which you are deleting imported key material.
#' The `Origin` of the CMK must be `EXTERNAL`.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#'
#' @section Request syntax:
#' ```
#' svc$delete_imported_key_material(
#'   KeyId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example deletes the imported key material from the
#' # specified customer master key (CMK).
#' \donttest{svc$delete_imported_key_material(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_delete_imported_key_material
kms_delete_imported_key_material <- function(KeyId) {
  op <- new_operation(
    name = "DeleteImportedKeyMaterial",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$delete_imported_key_material_input(KeyId = KeyId)
  output <- .kms$delete_imported_key_material_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$delete_imported_key_material <- kms_delete_imported_key_material

#' Gets information about custom key stores in the account and region
#'
#' Gets information about [custom key
#' stores](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' in the account and region.
#' 
#' This operation is part of the [Custom Key Store
#' feature](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' feature in AWS KMS, which combines the convenience and extensive
#' integration of AWS KMS with the isolation and control of a single-tenant
#' key store.
#' 
#' By default, this operation returns information about all custom key
#' stores in the account and region. To get only information about a
#' particular custom key store, use either the `CustomKeyStoreName` or
#' `CustomKeyStoreId` parameter (but not both).
#' 
#' To determine whether the custom key store is connected to its AWS
#' CloudHSM cluster, use the `ConnectionState` element in the response. If
#' an attempt to connect the custom key store failed, the `ConnectionState`
#' value is `FAILED` and the `ConnectionErrorCode` element in the response
#' indicates the cause of the failure. For help interpreting the
#' `ConnectionErrorCode`, see CustomKeyStoresListEntry.
#' 
#' Custom key stores have a `DISCONNECTED` connection state if the key
#' store has never been connected or you use the DisconnectCustomKeyStore
#' operation to disconnect it. If your custom key store state is
#' `CONNECTED` but you are having trouble using it, make sure that its
#' associated AWS CloudHSM cluster is active and contains the minimum
#' number of HSMs required for the operation, if any.
#' 
#' For help repairing your custom key store, see the [Troubleshooting
#' Custom Key
#' Stores](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html)
#' topic in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_describe_custom_key_stores(CustomKeyStoreId, CustomKeyStoreName,
#'   Limit, Marker)
#'
#' @param CustomKeyStoreId Gets only information about the specified custom key store. Enter the
#' key store ID.
#' 
#' By default, this operation gets information about all custom key stores
#' in the account and region. To limit the output to a particular custom
#' key store, you can use either the `CustomKeyStoreId` or
#' `CustomKeyStoreName` parameter, but not both.
#' @param CustomKeyStoreName Gets only information about the specified custom key store. Enter the
#' friendly name of the custom key store.
#' 
#' By default, this operation gets information about all custom key stores
#' in the account and region. To limit the output to a particular custom
#' key store, you can use either the `CustomKeyStoreId` or
#' `CustomKeyStoreName` parameter, but not both.
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, AWS KMS does not return more than the
#' specified number of items, but it might return fewer.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#'
#' @section Request syntax:
#' ```
#' svc$describe_custom_key_stores(
#'   CustomKeyStoreId = "string",
#'   CustomKeyStoreName = "string",
#'   Limit = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kms_describe_custom_key_stores
kms_describe_custom_key_stores <- function(CustomKeyStoreId = NULL, CustomKeyStoreName = NULL, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeCustomKeyStores",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$describe_custom_key_stores_input(CustomKeyStoreId = CustomKeyStoreId, CustomKeyStoreName = CustomKeyStoreName, Limit = Limit, Marker = Marker)
  output <- .kms$describe_custom_key_stores_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$describe_custom_key_stores <- kms_describe_custom_key_stores

#' Provides detailed information about the specified customer master key
#' (CMK)
#'
#' Provides detailed information about the specified customer master key
#' (CMK).
#' 
#' You can use `DescribeKey` on a predefined AWS alias, that is, an AWS
#' alias with no key ID. When you do, AWS KMS associates the alias with an
#' [AWS managed
#' CMK](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys)
#' and returns its `KeyId` and `Arn` in the response.
#' 
#' To perform this operation on a CMK in a different AWS account, specify
#' the key ARN or alias ARN in the value of the KeyId parameter.
#'
#' @usage
#' kms_describe_key(KeyId, GrantTokens)
#'
#' @param KeyId &#91;required&#93; Describes the specified customer master key (CMK).
#' 
#' If you specify a predefined AWS alias (an AWS alias with no key ID), KMS
#' associates the alias with an [AWS managed
#' CMK](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#master_keys)
#' and returns its `KeyId` and `Arn` in the response.
#' 
#' To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
#' name, or alias ARN. When using an alias name, prefix it with `"alias/"`.
#' To specify a CMK in a different AWS account, you must use the key ARN or
#' alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
#' get the alias name and alias ARN, use ListAliases.
#' @param GrantTokens A list of grant tokens.
#' 
#' For more information, see [Grant
#' Tokens](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$describe_key(
#'   KeyId = "string",
#'   GrantTokens = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example returns information (metadata) about the specified
#' # CMK.
#' \donttest{svc$describe_key(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_describe_key
kms_describe_key <- function(KeyId, GrantTokens = NULL) {
  op <- new_operation(
    name = "DescribeKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$describe_key_input(KeyId = KeyId, GrantTokens = GrantTokens)
  output <- .kms$describe_key_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$describe_key <- kms_describe_key

#' Sets the state of a customer master key (CMK) to disabled, thereby
#' preventing its use for cryptographic operations
#'
#' Sets the state of a customer master key (CMK) to disabled, thereby
#' preventing its use for cryptographic operations. You cannot perform this
#' operation on a CMK in a different AWS account.
#' 
#' For more information about how key state affects the use of a CMK, see
#' [How Key State Affects the Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the **AWS Key Management Service Developer Guide** .
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_disable_key(KeyId)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#'
#' @section Request syntax:
#' ```
#' svc$disable_key(
#'   KeyId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example disables the specified CMK.
#' \donttest{svc$disable_key(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_disable_key
kms_disable_key <- function(KeyId) {
  op <- new_operation(
    name = "DisableKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$disable_key_input(KeyId = KeyId)
  output <- .kms$disable_key_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$disable_key <- kms_disable_key

#' Disables automatic rotation of the key material for the specified
#' customer master key (CMK)
#'
#' Disables [automatic rotation of the key
#' material](https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html)
#' for the specified customer master key (CMK). You cannot perform this
#' operation on a CMK in a different AWS account.
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_disable_key_rotation(KeyId)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#'
#' @section Request syntax:
#' ```
#' svc$disable_key_rotation(
#'   KeyId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example disables automatic annual rotation of the key
#' # material for the specified CMK.
#' \donttest{svc$disable_key_rotation(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_disable_key_rotation
kms_disable_key_rotation <- function(KeyId) {
  op <- new_operation(
    name = "DisableKeyRotation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$disable_key_rotation_input(KeyId = KeyId)
  output <- .kms$disable_key_rotation_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$disable_key_rotation <- kms_disable_key_rotation

#' Disconnects the custom key store from its associated AWS CloudHSM
#' cluster
#'
#' Disconnects the [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' from its associated AWS CloudHSM cluster. While a custom key store is
#' disconnected, you can manage the custom key store and its customer
#' master keys (CMKs), but you cannot create or use CMKs in the custom key
#' store. You can reconnect the custom key store at any time.
#' 
#' While a custom key store is disconnected, all attempts to create
#' customer master keys (CMKs) in the custom key store or to use existing
#' CMKs in cryptographic operations will fail. This action can prevent
#' users from storing and accessing sensitive data.
#' 
#' To find the connection state of a custom key store, use the
#' DescribeCustomKeyStores operation. To reconnect a custom key store, use
#' the ConnectCustomKeyStore operation.
#' 
#' If the operation succeeds, it returns a JSON object with no properties.
#' 
#' This operation is part of the [Custom Key Store
#' feature](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' feature in AWS KMS, which combines the convenience and extensive
#' integration of AWS KMS with the isolation and control of a single-tenant
#' key store.
#'
#' @usage
#' kms_disconnect_custom_key_store(CustomKeyStoreId)
#'
#' @param CustomKeyStoreId &#91;required&#93; Enter the ID of the custom key store you want to disconnect. To find the
#' ID of a custom key store, use the DescribeCustomKeyStores operation.
#'
#' @section Request syntax:
#' ```
#' svc$disconnect_custom_key_store(
#'   CustomKeyStoreId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kms_disconnect_custom_key_store
kms_disconnect_custom_key_store <- function(CustomKeyStoreId) {
  op <- new_operation(
    name = "DisconnectCustomKeyStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$disconnect_custom_key_store_input(CustomKeyStoreId = CustomKeyStoreId)
  output <- .kms$disconnect_custom_key_store_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$disconnect_custom_key_store <- kms_disconnect_custom_key_store

#' Sets the key state of a customer master key (CMK) to enabled
#'
#' Sets the key state of a customer master key (CMK) to enabled. This
#' allows you to use the CMK for cryptographic operations. You cannot
#' perform this operation on a CMK in a different AWS account.
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_enable_key(KeyId)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#'
#' @section Request syntax:
#' ```
#' svc$enable_key(
#'   KeyId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example enables the specified CMK.
#' \donttest{svc$enable_key(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_enable_key
kms_enable_key <- function(KeyId) {
  op <- new_operation(
    name = "EnableKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$enable_key_input(KeyId = KeyId)
  output <- .kms$enable_key_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$enable_key <- kms_enable_key

#' Enables automatic rotation of the key material for the specified
#' customer master key (CMK)
#'
#' Enables [automatic rotation of the key
#' material](https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html)
#' for the specified customer master key (CMK). You cannot perform this
#' operation on a CMK in a different AWS account.
#' 
#' You cannot enable automatic rotation of CMKs with imported key material
#' or CMKs in a [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_enable_key_rotation(KeyId)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#'
#' @section Request syntax:
#' ```
#' svc$enable_key_rotation(
#'   KeyId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example enables automatic annual rotation of the key
#' # material for the specified CMK.
#' \donttest{svc$enable_key_rotation(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_enable_key_rotation
kms_enable_key_rotation <- function(KeyId) {
  op <- new_operation(
    name = "EnableKeyRotation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$enable_key_rotation_input(KeyId = KeyId)
  output <- .kms$enable_key_rotation_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$enable_key_rotation <- kms_enable_key_rotation

#' Encrypts plaintext into ciphertext by using a customer master key (CMK)
#'
#' Encrypts plaintext into ciphertext by using a customer master key (CMK).
#' The `Encrypt` operation has two primary use cases:
#' 
#' -   You can encrypt up to 4 kilobytes (4096 bytes) of arbitrary data
#'     such as an RSA key, a database password, or other sensitive
#'     information.
#' 
#' -   You can use the `Encrypt` operation to move encrypted data from one
#'     AWS region to another. In the first region, generate a data key and
#'     use the plaintext key to encrypt the data. Then, in the new region,
#'     call the `Encrypt` method on same plaintext data key. Now, you can
#'     safely move the encrypted data and encrypted data key to the new
#'     region, and decrypt in the new region when necessary.
#' 
#' You don\'t need use this operation to encrypt a data key within a
#' region. The GenerateDataKey and GenerateDataKeyWithoutPlaintext
#' operations return an encrypted data key.
#' 
#' Also, you don\'t need to use this operation to encrypt data in your
#' application. You can use the plaintext and encrypted data keys that the
#' `GenerateDataKey` operation returns.
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' To perform this operation on a CMK in a different AWS account, specify
#' the key ARN or alias ARN in the value of the KeyId parameter.
#'
#' @usage
#' kms_encrypt(KeyId, Plaintext, EncryptionContext, GrantTokens)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
#' name, or alias ARN. When using an alias name, prefix it with `"alias/"`.
#' To specify a CMK in a different AWS account, you must use the key ARN or
#' alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
#' get the alias name and alias ARN, use ListAliases.
#' @param Plaintext &#91;required&#93; Data to be encrypted.
#' @param EncryptionContext Name-value pair that specifies the encryption context to be used for
#' authenticated encryption. If used here, the same value must be supplied
#' to the `Decrypt` API or decryption will fail. For more information, see
#' [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context).
#' @param GrantTokens A list of grant tokens.
#' 
#' For more information, see [Grant
#' Tokens](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$encrypt(
#'   KeyId = "string",
#'   Plaintext = raw,
#'   EncryptionContext = list(
#'     "string"
#'   ),
#'   GrantTokens = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example encrypts data with the specified customer master
#' # key (CMK).
#' \donttest{svc$encrypt(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
#'   Plaintext = "<binary data>"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_encrypt
kms_encrypt <- function(KeyId, Plaintext, EncryptionContext = NULL, GrantTokens = NULL) {
  op <- new_operation(
    name = "Encrypt",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$encrypt_input(KeyId = KeyId, Plaintext = Plaintext, EncryptionContext = EncryptionContext, GrantTokens = GrantTokens)
  output <- .kms$encrypt_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$encrypt <- kms_encrypt

#' Generates a unique data key
#'
#' Generates a unique data key. This operation returns a plaintext copy of
#' the data key and a copy that is encrypted under a customer master key
#' (CMK) that you specify. You can use the plaintext key to encrypt your
#' data outside of KMS and store the encrypted data key with the encrypted
#' data.
#' 
#' `GenerateDataKey` returns a unique data key for each request. The bytes
#' in the key are not related to the caller or CMK that is used to encrypt
#' the data key.
#' 
#' To generate a data key, you need to specify the customer master key
#' (CMK) that will be used to encrypt the data key. You must also specify
#' the length of the data key using either the `KeySpec` or `NumberOfBytes`
#' field (but not both). For common key lengths (128-bit and 256-bit
#' symmetric keys), we recommend that you use `KeySpec`. To perform this
#' operation on a CMK in a different AWS account, specify the key ARN or
#' alias ARN in the value of the KeyId parameter.
#' 
#' You will find the plaintext copy of the data key in the `Plaintext`
#' field of the response, and the encrypted copy of the data key in the
#' `CiphertextBlob` field.
#' 
#' We recommend that you use the following pattern to encrypt data locally
#' in your application:
#' 
#' 1.  Use the `GenerateDataKey` operation to get a data encryption key.
#' 
#' 2.  Use the plaintext data key (returned in the `Plaintext` field of the
#'     response) to encrypt data locally, then erase the plaintext data key
#'     from memory.
#' 
#' 3.  Store the encrypted data key (returned in the `CiphertextBlob` field
#'     of the response) alongside the locally encrypted data.
#' 
#' To decrypt data locally:
#' 
#' 1.  Use the Decrypt operation to decrypt the encrypted data key. The
#'     operation returns a plaintext copy of the data key.
#' 
#' 2.  Use the plaintext data key to decrypt data locally, then erase the
#'     plaintext data key from memory.
#' 
#' To get only an encrypted copy of the data key, use
#' GenerateDataKeyWithoutPlaintext. To get a cryptographically secure
#' random byte string, use GenerateRandom.
#' 
#' You can use the optional encryption context to add additional security
#' to your encryption operation. When you specify an `EncryptionContext` in
#' the `GenerateDataKey` operation, you must specify the same encryption
#' context (a case-sensitive exact match) in your request to Decrypt the
#' data key. Otherwise, the request to decrypt fails with an
#' `InvalidCiphertextException`. For more information, see [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the **AWS Key Management Service Developer Guide** .
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_generate_data_key(KeyId, EncryptionContext, NumberOfBytes, KeySpec,
#'   GrantTokens)
#'
#' @param KeyId &#91;required&#93; An identifier for the CMK that encrypts the data key.
#' 
#' To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
#' name, or alias ARN. When using an alias name, prefix it with `"alias/"`.
#' To specify a CMK in a different AWS account, you must use the key ARN or
#' alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
#' get the alias name and alias ARN, use ListAliases.
#' @param EncryptionContext A set of key-value pairs that represents additional authenticated data.
#' 
#' For more information, see [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *AWS Key Management Service Developer Guide*.
#' @param NumberOfBytes The length of the data key in bytes. For example, use the value 64 to
#' generate a 512-bit data key (64 bytes is 512 bits). For common key
#' lengths (128-bit and 256-bit symmetric keys), we recommend that you use
#' the `KeySpec` field instead of this one.
#' @param KeySpec The length of the data key. Use `AES_128` to generate a 128-bit
#' symmetric key, or `AES_256` to generate a 256-bit symmetric key.
#' @param GrantTokens A list of grant tokens.
#' 
#' For more information, see [Grant
#' Tokens](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$generate_data_key(
#'   KeyId = "string",
#'   EncryptionContext = list(
#'     "string"
#'   ),
#'   NumberOfBytes = 123,
#'   KeySpec = "AES_256"|"AES_128",
#'   GrantTokens = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example generates a 256-bit symmetric data encryption key
#' # (data key) in two formats. One is the unencrypted (plainext) data key,
#' # and the other is the data key encrypted with the specified customer
#' # master key (CMK).
#' \donttest{svc$generate_data_key(
#'   KeyId = "alias/ExampleAlias",
#'   KeySpec = "AES_256"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_generate_data_key
kms_generate_data_key <- function(KeyId, EncryptionContext = NULL, NumberOfBytes = NULL, KeySpec = NULL, GrantTokens = NULL) {
  op <- new_operation(
    name = "GenerateDataKey",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$generate_data_key_input(KeyId = KeyId, EncryptionContext = EncryptionContext, NumberOfBytes = NumberOfBytes, KeySpec = KeySpec, GrantTokens = GrantTokens)
  output <- .kms$generate_data_key_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$generate_data_key <- kms_generate_data_key

#' Generates a unique data key
#'
#' Generates a unique data key. This operation returns a data key that is
#' encrypted under a customer master key (CMK) that you specify.
#' `GenerateDataKeyWithoutPlaintext` is identical to GenerateDataKey except
#' that returns only the encrypted copy of the data key.
#' 
#' Like `GenerateDataKey`, `GenerateDataKeyWithoutPlaintext` returns a
#' unique data key for each request. The bytes in the key are not related
#' to the caller or CMK that is used to encrypt the data key.
#' 
#' This operation is useful for systems that need to encrypt data at some
#' point, but not immediately. When you need to encrypt the data, you call
#' the Decrypt operation on the encrypted copy of the key.
#' 
#' It\'s also useful in distributed systems with different levels of trust.
#' For example, you might store encrypted data in containers. One component
#' of your system creates new containers and stores an encrypted data key
#' with each container. Then, a different component puts the data into the
#' containers. That component first decrypts the data key, uses the
#' plaintext data key to encrypt data, puts the encrypted data into the
#' container, and then destroys the plaintext data key. In this system, the
#' component that creates the containers never sees the plaintext data key.
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_generate_data_key_without_plaintext(KeyId, EncryptionContext,
#'   KeySpec, NumberOfBytes, GrantTokens)
#'
#' @param KeyId &#91;required&#93; The identifier of the customer master key (CMK) that encrypts the data
#' key.
#' 
#' To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
#' name, or alias ARN. When using an alias name, prefix it with `"alias/"`.
#' To specify a CMK in a different AWS account, you must use the key ARN or
#' alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
#' get the alias name and alias ARN, use ListAliases.
#' @param EncryptionContext A set of key-value pairs that represents additional authenticated data.
#' 
#' For more information, see [Encryption
#' Context](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context)
#' in the *AWS Key Management Service Developer Guide*.
#' @param KeySpec The length of the data key. Use `AES_128` to generate a 128-bit
#' symmetric key, or `AES_256` to generate a 256-bit symmetric key.
#' @param NumberOfBytes The length of the data key in bytes. For example, use the value 64 to
#' generate a 512-bit data key (64 bytes is 512 bits). For common key
#' lengths (128-bit and 256-bit symmetric keys), we recommend that you use
#' the `KeySpec` field instead of this one.
#' @param GrantTokens A list of grant tokens.
#' 
#' For more information, see [Grant
#' Tokens](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$generate_data_key_without_plaintext(
#'   KeyId = "string",
#'   EncryptionContext = list(
#'     "string"
#'   ),
#'   KeySpec = "AES_256"|"AES_128",
#'   NumberOfBytes = 123,
#'   GrantTokens = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example generates an encrypted copy of a 256-bit symmetric
#' # data encryption key (data key). The data key is encrypted with the
#' # specified customer master key (CMK).
#' \donttest{svc$generate_data_key_without_plaintext(
#'   KeyId = "alias/ExampleAlias",
#'   KeySpec = "AES_256"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_generate_data_key_without_plaintext
kms_generate_data_key_without_plaintext <- function(KeyId, EncryptionContext = NULL, KeySpec = NULL, NumberOfBytes = NULL, GrantTokens = NULL) {
  op <- new_operation(
    name = "GenerateDataKeyWithoutPlaintext",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$generate_data_key_without_plaintext_input(KeyId = KeyId, EncryptionContext = EncryptionContext, KeySpec = KeySpec, NumberOfBytes = NumberOfBytes, GrantTokens = GrantTokens)
  output <- .kms$generate_data_key_without_plaintext_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$generate_data_key_without_plaintext <- kms_generate_data_key_without_plaintext

#' Returns a random byte string that is cryptographically secure
#'
#' Returns a random byte string that is cryptographically secure.
#' 
#' By default, the random byte string is generated in AWS KMS. To generate
#' the byte string in the AWS CloudHSM cluster that is associated with a
#' [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html),
#' specify the custom key store ID.
#' 
#' For more information about entropy and random number generation, see the
#' [AWS Key Management Service Cryptographic
#' Details](https://d0.awsstatic.com/whitepapers/KMS-Cryptographic-Details.pdf)
#' whitepaper.
#'
#' @usage
#' kms_generate_random(NumberOfBytes, CustomKeyStoreId)
#'
#' @param NumberOfBytes The length of the byte string.
#' @param CustomKeyStoreId Generates the random byte string in the AWS CloudHSM cluster that is
#' associated with the specified [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html).
#' To find the ID of a custom key store, use the DescribeCustomKeyStores
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$generate_random(
#'   NumberOfBytes = 123,
#'   CustomKeyStoreId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example uses AWS KMS to generate 32 bytes of random data.
#' \donttest{svc$generate_random(
#'   NumberOfBytes = 32L
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_generate_random
kms_generate_random <- function(NumberOfBytes = NULL, CustomKeyStoreId = NULL) {
  op <- new_operation(
    name = "GenerateRandom",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$generate_random_input(NumberOfBytes = NumberOfBytes, CustomKeyStoreId = CustomKeyStoreId)
  output <- .kms$generate_random_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$generate_random <- kms_generate_random

#' Gets a key policy attached to the specified customer master key (CMK)
#'
#' Gets a key policy attached to the specified customer master key (CMK).
#' You cannot perform this operation on a CMK in a different AWS account.
#'
#' @usage
#' kms_get_key_policy(KeyId, PolicyName)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param PolicyName &#91;required&#93; Specifies the name of the key policy. The only valid name is `default`.
#' To get the names of key policies, use ListKeyPolicies.
#'
#' @section Request syntax:
#' ```
#' svc$get_key_policy(
#'   KeyId = "string",
#'   PolicyName = "string"
#' )
#' ```
#'
#' @examples
#' # The following example retrieves the key policy for the specified
#' # customer master key (CMK).
#' \donttest{svc$get_key_policy(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
#'   PolicyName = "default"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_get_key_policy
kms_get_key_policy <- function(KeyId, PolicyName) {
  op <- new_operation(
    name = "GetKeyPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$get_key_policy_input(KeyId = KeyId, PolicyName = PolicyName)
  output <- .kms$get_key_policy_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$get_key_policy <- kms_get_key_policy

#' Gets a Boolean value that indicates whether automatic rotation of the
#' key material is enabled for the specified customer master key (CMK)
#'
#' Gets a Boolean value that indicates whether [automatic rotation of the
#' key
#' material](https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html)
#' is enabled for the specified customer master key (CMK).
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' -   Disabled: The key rotation status does not change when you disable a
#'     CMK. However, while the CMK is disabled, AWS KMS does not rotate the
#'     backing key.
#' 
#' -   Pending deletion: While a CMK is pending deletion, its key rotation
#'     status is `false` and AWS KMS does not rotate the backing key. If
#'     you cancel the deletion, the original key rotation status is
#'     restored.
#' 
#' To perform this operation on a CMK in a different AWS account, specify
#' the key ARN in the value of the `KeyId` parameter.
#'
#' @usage
#' kms_get_key_rotation_status(KeyId)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To
#' specify a CMK in a different AWS account, you must use the key ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#'
#' @section Request syntax:
#' ```
#' svc$get_key_rotation_status(
#'   KeyId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example retrieves the status of automatic annual rotation
#' # of the key material for the specified CMK.
#' \donttest{svc$get_key_rotation_status(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_get_key_rotation_status
kms_get_key_rotation_status <- function(KeyId) {
  op <- new_operation(
    name = "GetKeyRotationStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$get_key_rotation_status_input(KeyId = KeyId)
  output <- .kms$get_key_rotation_status_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$get_key_rotation_status <- kms_get_key_rotation_status

#' Returns the items you need in order to import key material into AWS KMS
#' from your existing key management infrastructure
#'
#' Returns the items you need in order to import key material into AWS KMS
#' from your existing key management infrastructure. For more information
#' about importing key material into AWS KMS, see [Importing Key
#' Material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' You must specify the key ID of the customer master key (CMK) into which
#' you will import key material. This CMK\'s `Origin` must be `EXTERNAL`.
#' You must also specify the wrapping algorithm and type of wrapping key
#' (public key) that you will use to encrypt the key material. You cannot
#' perform this operation on a CMK in a different AWS account.
#' 
#' This operation returns a public key and an import token. Use the public
#' key to encrypt the key material. Store the import token to send with a
#' subsequent ImportKeyMaterial request. The public key and import token
#' from the same response must be used together. These items are valid for
#' 24 hours. When they expire, they cannot be used for a subsequent
#' ImportKeyMaterial request. To get new ones, send another
#' `GetParametersForImport` request.
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_get_parameters_for_import(KeyId, WrappingAlgorithm, WrappingKeySpec)
#'
#' @param KeyId &#91;required&#93; The identifier of the CMK into which you will import key material. The
#' CMK\'s `Origin` must be `EXTERNAL`.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param WrappingAlgorithm &#91;required&#93; The algorithm you will use to encrypt the key material before importing
#' it with ImportKeyMaterial. For more information, see [Encrypt the Key
#' Material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys-encrypt-key-material.html)
#' in the *AWS Key Management Service Developer Guide*.
#' @param WrappingKeySpec &#91;required&#93; The type of wrapping key (public key) to return in the response. Only
#' 2048-bit RSA public keys are supported.
#'
#' @section Request syntax:
#' ```
#' svc$get_parameters_for_import(
#'   KeyId = "string",
#'   WrappingAlgorithm = "RSAES_PKCS1_V1_5"|"RSAES_OAEP_SHA_1"|"RSAES_OAEP_SHA_256",
#'   WrappingKeySpec = "RSA_2048"
#' )
#' ```
#'
#' @examples
#' # The following example retrieves the public key and import token for the
#' # specified CMK.
#' \donttest{svc$get_parameters_for_import(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
#'   WrappingAlgorithm = "RSAES_OAEP_SHA_1",
#'   WrappingKeySpec = "RSA_2048"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_get_parameters_for_import
kms_get_parameters_for_import <- function(KeyId, WrappingAlgorithm, WrappingKeySpec) {
  op <- new_operation(
    name = "GetParametersForImport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$get_parameters_for_import_input(KeyId = KeyId, WrappingAlgorithm = WrappingAlgorithm, WrappingKeySpec = WrappingKeySpec)
  output <- .kms$get_parameters_for_import_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$get_parameters_for_import <- kms_get_parameters_for_import

#' Imports key material into an existing AWS KMS customer master key (CMK)
#' that was created without key material
#'
#' Imports key material into an existing AWS KMS customer master key (CMK)
#' that was created without key material. You cannot perform this operation
#' on a CMK in a different AWS account. For more information about creating
#' CMKs with no key material and then importing key material, see
#' [Importing Key
#' Material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' Before using this operation, call GetParametersForImport. Its response
#' includes a public key and an import token. Use the public key to encrypt
#' the key material. Then, submit the import token from the same
#' `GetParametersForImport` response.
#' 
#' When calling this operation, you must specify the following values:
#' 
#' -   The key ID or key ARN of a CMK with no key material. Its `Origin`
#'     must be `EXTERNAL`.
#' 
#'     To create a CMK with no key material, call CreateKey and set the
#'     value of its `Origin` parameter to `EXTERNAL`. To get the `Origin`
#'     of a CMK, call DescribeKey.)
#' 
#' -   The encrypted key material. To get the public key to encrypt the key
#'     material, call GetParametersForImport.
#' 
#' -   The import token that GetParametersForImport returned. This token
#'     and the public key used to encrypt the key material must have come
#'     from the same response.
#' 
#' -   Whether the key material expires and if so, when. If you set an
#'     expiration date, you can change it only by reimporting the same key
#'     material and specifying a new expiration date. If the key material
#'     expires, AWS KMS deletes the key material and the CMK becomes
#'     unusable. To use the CMK again, you must reimport the same key
#'     material.
#' 
#' When this operation is successful, the key state of the CMK changes from
#' `PendingImport` to `Enabled`, and you can use the CMK. After you
#' successfully import key material into a CMK, you can reimport the same
#' key material into that CMK, but you cannot import different key
#' material.
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_import_key_material(KeyId, ImportToken, EncryptedKeyMaterial,
#'   ValidTo, ExpirationModel)
#'
#' @param KeyId &#91;required&#93; The identifier of the CMK to import the key material into. The CMK\'s
#' `Origin` must be `EXTERNAL`.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param ImportToken &#91;required&#93; The import token that you received in the response to a previous
#' GetParametersForImport request. It must be from the same response that
#' contained the public key that you used to encrypt the key material.
#' @param EncryptedKeyMaterial &#91;required&#93; The encrypted key material to import. It must be encrypted with the
#' public key that you received in the response to a previous
#' GetParametersForImport request, using the wrapping algorithm that you
#' specified in that request.
#' @param ValidTo The time at which the imported key material expires. When the key
#' material expires, AWS KMS deletes the key material and the CMK becomes
#' unusable. You must omit this parameter when the `ExpirationModel`
#' parameter is set to `KEY_MATERIAL_DOES_NOT_EXPIRE`. Otherwise it is
#' required.
#' @param ExpirationModel Specifies whether the key material expires. The default is
#' `KEY_MATERIAL_EXPIRES`, in which case you must include the `ValidTo`
#' parameter. When this parameter is set to `KEY_MATERIAL_DOES_NOT_EXPIRE`,
#' you must omit the `ValidTo` parameter.
#'
#' @section Request syntax:
#' ```
#' svc$import_key_material(
#'   KeyId = "string",
#'   ImportToken = raw,
#'   EncryptedKeyMaterial = raw,
#'   ValidTo = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ExpirationModel = "KEY_MATERIAL_EXPIRES"|"KEY_MATERIAL_DOES_NOT_EXPIRE"
#' )
#' ```
#'
#' @examples
#' # The following example imports key material into the specified CMK.
#' \donttest{svc$import_key_material(
#'   EncryptedKeyMaterial = "<binary data>",
#'   ExpirationModel = "KEY_MATERIAL_DOES_NOT_EXPIRE",
#'   ImportToken = "<binary data>",
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_import_key_material
kms_import_key_material <- function(KeyId, ImportToken, EncryptedKeyMaterial, ValidTo = NULL, ExpirationModel = NULL) {
  op <- new_operation(
    name = "ImportKeyMaterial",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$import_key_material_input(KeyId = KeyId, ImportToken = ImportToken, EncryptedKeyMaterial = EncryptedKeyMaterial, ValidTo = ValidTo, ExpirationModel = ExpirationModel)
  output <- .kms$import_key_material_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$import_key_material <- kms_import_key_material

#' Gets a list of aliases in the caller's AWS account and region
#'
#' Gets a list of aliases in the caller\'s AWS account and region. You
#' cannot list aliases in other accounts. For more information about
#' aliases, see CreateAlias.
#' 
#' By default, the ListAliases command returns all aliases in the account
#' and region. To get only the aliases that point to a particular customer
#' master key (CMK), use the `KeyId` parameter.
#' 
#' The `ListAliases` response can include aliases that you created and
#' associated with your customer managed CMKs, and aliases that AWS created
#' and associated with AWS managed CMKs in your account. You can recognize
#' AWS aliases because their names have the format
#' `aws/&lt;service-name&gt;`, such as `aws/dynamodb`.
#' 
#' The response might also include aliases that have no `TargetKeyId`
#' field. These are predefined aliases that AWS has created but has not yet
#' associated with a CMK. Aliases that AWS creates in your account,
#' including predefined aliases, do not count against your [AWS KMS aliases
#' limit](https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#aliases-limit).
#'
#' @usage
#' kms_list_aliases(KeyId, Limit, Marker)
#'
#' @param KeyId Lists only aliases that refer to the specified CMK. The value of this
#' parameter can be the ID or Amazon Resource Name (ARN) of a CMK in the
#' caller\'s account and region. You cannot use an alias name or alias ARN
#' in this value.
#' 
#' This parameter is optional. If you omit it, `ListAliases` returns all
#' aliases in the account and region.
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, AWS KMS does not return more than the
#' specified number of items, but it might return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 100, inclusive. If you do not include a value, it defaults to 50.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#'
#' @section Request syntax:
#' ```
#' svc$list_aliases(
#'   KeyId = "string",
#'   Limit = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @examples
#' # The following example lists aliases.
#' \donttest{svc$list_aliases()}
#'
#' @keywords internal
#'
#' @rdname kms_list_aliases
kms_list_aliases <- function(KeyId = NULL, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListAliases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$list_aliases_input(KeyId = KeyId, Limit = Limit, Marker = Marker)
  output <- .kms$list_aliases_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$list_aliases <- kms_list_aliases

#' Gets a list of all grants for the specified customer master key (CMK)
#'
#' Gets a list of all grants for the specified customer master key (CMK).
#' 
#' To perform this operation on a CMK in a different AWS account, specify
#' the key ARN in the value of the `KeyId` parameter.
#'
#' @usage
#' kms_list_grants(Limit, Marker, KeyId)
#'
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, AWS KMS does not return more than the
#' specified number of items, but it might return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 100, inclusive. If you do not include a value, it defaults to 50.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To
#' specify a CMK in a different AWS account, you must use the key ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#'
#' @section Request syntax:
#' ```
#' svc$list_grants(
#'   Limit = 123,
#'   Marker = "string",
#'   KeyId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example lists grants for the specified CMK.
#' \donttest{svc$list_grants(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_list_grants
kms_list_grants <- function(Limit = NULL, Marker = NULL, KeyId) {
  op <- new_operation(
    name = "ListGrants",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$list_grants_input(Limit = Limit, Marker = Marker, KeyId = KeyId)
  output <- .kms$list_grants_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$list_grants <- kms_list_grants

#' Gets the names of the key policies that are attached to a customer
#' master key (CMK)
#'
#' Gets the names of the key policies that are attached to a customer
#' master key (CMK). This operation is designed to get policy names that
#' you can use in a GetKeyPolicy operation. However, the only valid policy
#' name is `default`. You cannot perform this operation on a CMK in a
#' different AWS account.
#'
#' @usage
#' kms_list_key_policies(KeyId, Limit, Marker)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, AWS KMS does not return more than the
#' specified number of items, but it might return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 1000, inclusive. If you do not include a value, it defaults to 100.
#' 
#' Only one policy can be attached to a key.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#'
#' @section Request syntax:
#' ```
#' svc$list_key_policies(
#'   KeyId = "string",
#'   Limit = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @examples
#' # The following example lists key policies for the specified CMK.
#' \donttest{svc$list_key_policies(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_list_key_policies
kms_list_key_policies <- function(KeyId, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListKeyPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$list_key_policies_input(KeyId = KeyId, Limit = Limit, Marker = Marker)
  output <- .kms$list_key_policies_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$list_key_policies <- kms_list_key_policies

#' Gets a list of all customer master keys (CMKs) in the caller's AWS
#' account and region
#'
#' Gets a list of all customer master keys (CMKs) in the caller\'s AWS
#' account and region.
#'
#' @usage
#' kms_list_keys(Limit, Marker)
#'
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, AWS KMS does not return more than the
#' specified number of items, but it might return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 1000, inclusive. If you do not include a value, it defaults to 100.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#'
#' @section Request syntax:
#' ```
#' svc$list_keys(
#'   Limit = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @examples
#' # The following example lists CMKs.
#' \donttest{svc$list_keys()}
#'
#' @keywords internal
#'
#' @rdname kms_list_keys
kms_list_keys <- function(Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListKeys",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$list_keys_input(Limit = Limit, Marker = Marker)
  output <- .kms$list_keys_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$list_keys <- kms_list_keys

#' Returns a list of all tags for the specified customer master key (CMK)
#'
#' Returns a list of all tags for the specified customer master key (CMK).
#' 
#' You cannot perform this operation on a CMK in a different AWS account.
#'
#' @usage
#' kms_list_resource_tags(KeyId, Limit, Marker)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, AWS KMS does not return more than the
#' specified number of items, but it might return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 50, inclusive. If you do not include a value, it defaults to 50.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#' 
#' Do not attempt to construct this value. Use only the value of
#' `NextMarker` from the truncated response you just received.
#'
#' @section Request syntax:
#' ```
#' svc$list_resource_tags(
#'   KeyId = "string",
#'   Limit = 123,
#'   Marker = "string"
#' )
#' ```
#'
#' @examples
#' # The following example lists tags for a CMK.
#' \donttest{svc$list_resource_tags(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_list_resource_tags
kms_list_resource_tags <- function(KeyId, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "ListResourceTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$list_resource_tags_input(KeyId = KeyId, Limit = Limit, Marker = Marker)
  output <- .kms$list_resource_tags_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$list_resource_tags <- kms_list_resource_tags

#' Returns a list of all grants for which the grant's RetiringPrincipal
#' matches the one specified
#'
#' Returns a list of all grants for which the grant\'s `RetiringPrincipal`
#' matches the one specified.
#' 
#' A typical use is to list all grants that you are able to retire. To
#' retire a grant, use RetireGrant.
#'
#' @usage
#' kms_list_retirable_grants(Limit, Marker, RetiringPrincipal)
#'
#' @param Limit Use this parameter to specify the maximum number of items to return.
#' When this value is present, AWS KMS does not return more than the
#' specified number of items, but it might return fewer.
#' 
#' This value is optional. If you include a value, it must be between 1 and
#' 100, inclusive. If you do not include a value, it defaults to 50.
#' @param Marker Use this parameter in a subsequent request after you receive a response
#' with truncated results. Set it to the value of `NextMarker` from the
#' truncated response you just received.
#' @param RetiringPrincipal &#91;required&#93; The retiring principal for which to list grants.
#' 
#' To specify the retiring principal, use the [Amazon Resource Name
#' (ARN)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
#' of an AWS principal. Valid AWS principals include AWS accounts (root),
#' IAM users, federated users, and assumed role users. For examples of the
#' ARN syntax for specifying a principal, see [AWS Identity and Access
#' Management
#' (IAM)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html#arn-syntax-iam)
#' in the Example ARNs section of the *Amazon Web Services General
#' Reference*.
#'
#' @section Request syntax:
#' ```
#' svc$list_retirable_grants(
#'   Limit = 123,
#'   Marker = "string",
#'   RetiringPrincipal = "string"
#' )
#' ```
#'
#' @examples
#' # The following example lists the grants that the specified principal
#' # (identity) can retire.
#' \donttest{svc$list_retirable_grants(
#'   RetiringPrincipal = "arn:aws:iam::111122223333:role/ExampleRole"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_list_retirable_grants
kms_list_retirable_grants <- function(Limit = NULL, Marker = NULL, RetiringPrincipal) {
  op <- new_operation(
    name = "ListRetirableGrants",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$list_retirable_grants_input(Limit = Limit, Marker = Marker, RetiringPrincipal = RetiringPrincipal)
  output <- .kms$list_retirable_grants_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$list_retirable_grants <- kms_list_retirable_grants

#' Attaches a key policy to the specified customer master key (CMK)
#'
#' Attaches a key policy to the specified customer master key (CMK). You
#' cannot perform this operation on a CMK in a different AWS account.
#' 
#' For more information about key policies, see [Key
#' Policies](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_put_key_policy(KeyId, PolicyName, Policy,
#'   BypassPolicyLockoutSafetyCheck)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param PolicyName &#91;required&#93; The name of the key policy. The only valid value is `default`.
#' @param Policy &#91;required&#93; The key policy to attach to the CMK.
#' 
#' The key policy must meet the following criteria:
#' 
#' -   If you don\'t set `BypassPolicyLockoutSafetyCheck` to true, the key
#'     policy must allow the principal that is making the `PutKeyPolicy`
#'     request to make a subsequent `PutKeyPolicy` request on the CMK. This
#'     reduces the risk that the CMK becomes unmanageable. For more
#'     information, refer to the scenario in the [Default Key
#'     Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
#'     section of the *AWS Key Management Service Developer Guide*.
#' 
#' -   Each statement in the key policy must contain one or more
#'     principals. The principals in the key policy must exist and be
#'     visible to AWS KMS. When you create a new AWS principal (for
#'     example, an IAM user or role), you might need to enforce a delay
#'     before including the new principal in a key policy because the new
#'     principal might not be immediately visible to AWS KMS. For more
#'     information, see [Changes that I make are not always immediately
#'     visible](https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency)
#'     in the *AWS Identity and Access Management User Guide*.
#' 
#' The key policy size limit is 32 kilobytes (32768 bytes).
#' @param BypassPolicyLockoutSafetyCheck A flag to indicate whether to bypass the key policy lockout safety
#' check.
#' 
#' Setting this value to true increases the risk that the CMK becomes
#' unmanageable. Do not set this value to true indiscriminately.
#' 
#' For more information, refer to the scenario in the [Default Key
#' Policy](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam)
#' section in the *AWS Key Management Service Developer Guide*.
#' 
#' Use this parameter only when you intend to prevent the principal that is
#' making the request from making a subsequent `PutKeyPolicy` request on
#' the CMK.
#' 
#' The default value is false.
#'
#' @section Request syntax:
#' ```
#' svc$put_key_policy(
#'   KeyId = "string",
#'   PolicyName = "string",
#'   Policy = "string",
#'   BypassPolicyLockoutSafetyCheck = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # The following example attaches a key policy to the specified CMK.
#' \donttest{svc$put_key_policy(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
#'   Policy = "{\n    \"Version\": \"2012-10-17\",\n    \"Id\": \"custom-policy-2016-12-07\",\n...",
#'   PolicyName = "default"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_put_key_policy
kms_put_key_policy <- function(KeyId, PolicyName, Policy, BypassPolicyLockoutSafetyCheck = NULL) {
  op <- new_operation(
    name = "PutKeyPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$put_key_policy_input(KeyId = KeyId, PolicyName = PolicyName, Policy = Policy, BypassPolicyLockoutSafetyCheck = BypassPolicyLockoutSafetyCheck)
  output <- .kms$put_key_policy_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$put_key_policy <- kms_put_key_policy

#' Encrypts data on the server side with a new customer master key (CMK)
#' without exposing the plaintext of the data on the client side
#'
#' Encrypts data on the server side with a new customer master key (CMK)
#' without exposing the plaintext of the data on the client side. The data
#' is first decrypted and then reencrypted. You can also use this operation
#' to change the encryption context of a ciphertext.
#' 
#' You can reencrypt data using CMKs in different AWS accounts.
#' 
#' Unlike other operations, `ReEncrypt` is authorized twice, once as
#' `ReEncryptFrom` on the source CMK and once as `ReEncryptTo` on the
#' destination CMK. We recommend that you include the `"kms:ReEncrypt*"`
#' permission in your [key
#' policies](https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html)
#' to permit reencryption from or to the CMK. This permission is
#' automatically included in the key policy when you create a CMK through
#' the console. But you must include it manually when you create a CMK
#' programmatically or when you set a key policy with the PutKeyPolicy
#' operation.
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_re_encrypt(CiphertextBlob, SourceEncryptionContext,
#'   DestinationKeyId, DestinationEncryptionContext, GrantTokens)
#'
#' @param CiphertextBlob &#91;required&#93; Ciphertext of the data to reencrypt.
#' @param SourceEncryptionContext Encryption context used to encrypt and decrypt the data specified in the
#' `CiphertextBlob` parameter.
#' @param DestinationKeyId &#91;required&#93; A unique identifier for the CMK that is used to reencrypt the data.
#' 
#' To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
#' name, or alias ARN. When using an alias name, prefix it with `"alias/"`.
#' To specify a CMK in a different AWS account, you must use the key ARN or
#' alias ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey. To
#' get the alias name and alias ARN, use ListAliases.
#' @param DestinationEncryptionContext Encryption context to use when the data is reencrypted.
#' @param GrantTokens A list of grant tokens.
#' 
#' For more information, see [Grant
#' Tokens](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#grant_token)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$re_encrypt(
#'   CiphertextBlob = raw,
#'   SourceEncryptionContext = list(
#'     "string"
#'   ),
#'   DestinationKeyId = "string",
#'   DestinationEncryptionContext = list(
#'     "string"
#'   ),
#'   GrantTokens = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example reencrypts data with the specified CMK.
#' \donttest{svc$re_encrypt(
#'   CiphertextBlob = "<binary data>",
#'   DestinationKeyId = "0987dcba-09fe-87dc-65ba-ab0987654321"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_re_encrypt
kms_re_encrypt <- function(CiphertextBlob, SourceEncryptionContext = NULL, DestinationKeyId, DestinationEncryptionContext = NULL, GrantTokens = NULL) {
  op <- new_operation(
    name = "ReEncrypt",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$re_encrypt_input(CiphertextBlob = CiphertextBlob, SourceEncryptionContext = SourceEncryptionContext, DestinationKeyId = DestinationKeyId, DestinationEncryptionContext = DestinationEncryptionContext, GrantTokens = GrantTokens)
  output <- .kms$re_encrypt_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$re_encrypt <- kms_re_encrypt

#' Retires a grant
#'
#' Retires a grant. To clean up, you can retire a grant when you\'re done
#' using it. You should revoke a grant when you intend to actively deny
#' operations that depend on it. The following are permitted to call this
#' API:
#' 
#' -   The AWS account (root user) under which the grant was created
#' 
#' -   The `RetiringPrincipal`, if present in the grant
#' 
#' -   The `GranteePrincipal`, if `RetireGrant` is an operation specified
#'     in the grant
#' 
#' You must identify the grant to retire by its grant token or by a
#' combination of the grant ID and the Amazon Resource Name (ARN) of the
#' customer master key (CMK). A grant token is a unique variable-length
#' base64-encoded string. A grant ID is a 64 character unique identifier of
#' a grant. The CreateGrant operation returns both.
#'
#' @usage
#' kms_retire_grant(GrantToken, KeyId, GrantId)
#'
#' @param GrantToken Token that identifies the grant to be retired.
#' @param KeyId The Amazon Resource Name (ARN) of the CMK associated with the grant.
#' 
#' For example:
#' `arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' @param GrantId Unique identifier of the grant to retire. The grant ID is returned in
#' the response to a `CreateGrant` operation.
#' 
#' -   Grant ID Example -
#'     0123456789012345678901234567890123456789012345678901234567890123
#'
#' @section Request syntax:
#' ```
#' svc$retire_grant(
#'   GrantToken = "string",
#'   KeyId = "string",
#'   GrantId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example retires a grant.
#' \donttest{svc$retire_grant(
#'   GrantId = "0c237476b39f8bc44e45212e08498fbe3151305030726c0590dd8d3e9f3d6a60",
#'   KeyId = "arn:aws:kms:us-east-2:444455556666:key/1234abcd-12ab-34cd-56ef-1234567890ab"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_retire_grant
kms_retire_grant <- function(GrantToken = NULL, KeyId = NULL, GrantId = NULL) {
  op <- new_operation(
    name = "RetireGrant",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$retire_grant_input(GrantToken = GrantToken, KeyId = KeyId, GrantId = GrantId)
  output <- .kms$retire_grant_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$retire_grant <- kms_retire_grant

#' Revokes the specified grant for the specified customer master key (CMK)
#'
#' Revokes the specified grant for the specified customer master key (CMK).
#' You can revoke a grant to actively deny operations that depend on it.
#' 
#' To perform this operation on a CMK in a different AWS account, specify
#' the key ARN in the value of the `KeyId` parameter.
#'
#' @usage
#' kms_revoke_grant(KeyId, GrantId)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key associated with the
#' grant.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To
#' specify a CMK in a different AWS account, you must use the key ARN.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param GrantId &#91;required&#93; Identifier of the grant to be revoked.
#'
#' @section Request syntax:
#' ```
#' svc$revoke_grant(
#'   KeyId = "string",
#'   GrantId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example revokes a grant.
#' \donttest{svc$revoke_grant(
#'   GrantId = "0c237476b39f8bc44e45212e08498fbe3151305030726c0590dd8d3e9f3d6a60",
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_revoke_grant
kms_revoke_grant <- function(KeyId, GrantId) {
  op <- new_operation(
    name = "RevokeGrant",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$revoke_grant_input(KeyId = KeyId, GrantId = GrantId)
  output <- .kms$revoke_grant_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$revoke_grant <- kms_revoke_grant

#' Schedules the deletion of a customer master key (CMK)
#'
#' Schedules the deletion of a customer master key (CMK). You may provide a
#' waiting period, specified in days, before deletion occurs. If you do not
#' provide a waiting period, the default period of 30 days is used. When
#' this operation is successful, the key state of the CMK changes to
#' `PendingDeletion`. Before the waiting period ends, you can use
#' CancelKeyDeletion to cancel the deletion of the CMK. After the waiting
#' period ends, AWS KMS deletes the CMK and all AWS KMS data associated
#' with it, including all aliases that refer to it.
#' 
#' Deleting a CMK is a destructive and potentially dangerous operation.
#' When a CMK is deleted, all data that was encrypted under the CMK is
#' unrecoverable. To prevent the use of a CMK without deleting it, use
#' DisableKey.
#' 
#' If you schedule deletion of a CMK from a [custom key
#' store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html),
#' when the waiting period expires, `ScheduleKeyDeletion` deletes the CMK
#' from AWS KMS. Then AWS KMS makes a best effort to delete the key
#' material from the associated AWS CloudHSM cluster. However, you might
#' need to manually [delete the orphaned key
#' material](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-orphaned-key)
#' from the cluster and its backups.
#' 
#' You cannot perform this operation on a CMK in a different AWS account.
#' 
#' For more information about scheduling a CMK for deletion, see [Deleting
#' Customer Master
#' Keys](https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html)
#' in the *AWS Key Management Service Developer Guide*.
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_schedule_key_deletion(KeyId, PendingWindowInDays)
#'
#' @param KeyId &#91;required&#93; The unique identifier of the customer master key (CMK) to delete.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param PendingWindowInDays The waiting period, specified in number of days. After the waiting
#' period ends, AWS KMS deletes the customer master key (CMK).
#' 
#' This value is optional. If you include a value, it must be between 7 and
#' 30, inclusive. If you do not include a value, it defaults to 30.
#'
#' @section Request syntax:
#' ```
#' svc$schedule_key_deletion(
#'   KeyId = "string",
#'   PendingWindowInDays = 123
#' )
#' ```
#'
#' @examples
#' # The following example schedules the specified CMK for deletion.
#' \donttest{svc$schedule_key_deletion(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
#'   PendingWindowInDays = 7L
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_schedule_key_deletion
kms_schedule_key_deletion <- function(KeyId, PendingWindowInDays = NULL) {
  op <- new_operation(
    name = "ScheduleKeyDeletion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$schedule_key_deletion_input(KeyId = KeyId, PendingWindowInDays = PendingWindowInDays)
  output <- .kms$schedule_key_deletion_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$schedule_key_deletion <- kms_schedule_key_deletion

#' Adds or edits tags for a customer master key (CMK)
#'
#' Adds or edits tags for a customer master key (CMK). You cannot perform
#' this operation on a CMK in a different AWS account.
#' 
#' Each tag consists of a tag key and a tag value. Tag keys and tag values
#' are both required, but tag values can be empty (null) strings.
#' 
#' You can only use a tag key once for each CMK. If you use the tag key
#' again, AWS KMS replaces the current tag value with the specified value.
#' 
#' For information about the rules that apply to tag keys and tag values,
#' see [User-Defined Tag
#' Restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html)
#' in the *AWS Billing and Cost Management User Guide*.
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_tag_resource(KeyId, Tags)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the CMK you are tagging.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param Tags &#91;required&#93; One or more tags. Each tag consists of a tag key and a tag value.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   KeyId = "string",
#'   Tags = list(
#'     list(
#'       TagKey = "string",
#'       TagValue = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example tags a CMK.
#' \donttest{svc$tag_resource(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
#'   Tags = list(
#'     list(
#'       TagKey = "Purpose",
#'       TagValue = "Test"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_tag_resource
kms_tag_resource <- function(KeyId, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$tag_resource_input(KeyId = KeyId, Tags = Tags)
  output <- .kms$tag_resource_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$tag_resource <- kms_tag_resource

#' Removes the specified tags from the specified customer master key (CMK)
#'
#' Removes the specified tags from the specified customer master key (CMK).
#' You cannot perform this operation on a CMK in a different AWS account.
#' 
#' To remove a tag, specify the tag key. To change the tag value of an
#' existing tag key, use TagResource.
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_untag_resource(KeyId, TagKeys)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the CMK from which you are removing tags.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param TagKeys &#91;required&#93; One or more tag keys. Specify only the tag keys, not the tag values.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   KeyId = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The following example removes tags from a CMK.
#' \donttest{svc$untag_resource(
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
#'   TagKeys = list(
#'     "Purpose",
#'     "CostCenter"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_untag_resource
kms_untag_resource <- function(KeyId, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$untag_resource_input(KeyId = KeyId, TagKeys = TagKeys)
  output <- .kms$untag_resource_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$untag_resource <- kms_untag_resource

#' Associates an existing alias with a different customer master key (CMK)
#'
#' Associates an existing alias with a different customer master key (CMK).
#' Each CMK can have multiple aliases, but the aliases must be unique
#' within the account and region. You cannot perform this operation on an
#' alias in a different AWS account.
#' 
#' This operation works only on existing aliases. To change the alias of a
#' CMK to a new value, use CreateAlias to create a new alias and
#' DeleteAlias to delete the old alias.
#' 
#' Because an alias is not a property of a CMK, you can create, update, and
#' delete the aliases of a CMK without affecting the CMK. Also, aliases do
#' not appear in the response from the DescribeKey operation. To get the
#' aliases of all CMKs in the account, use the ListAliases operation.
#' 
#' The alias name must begin with `alias/` followed by a name, such as
#' `alias/ExampleAlias`. It can contain only alphanumeric characters,
#' forward slashes (/), underscores (\\_), and dashes (-). The alias name
#' cannot begin with `alias/aws/`. The `alias/aws/` prefix is reserved for
#' [AWS managed
#' CMKs](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk).
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_update_alias(AliasName, TargetKeyId)
#'
#' @param AliasName &#91;required&#93; Specifies the name of the alias to change. This value must begin with
#' `alias/` followed by the alias name, such as `alias/ExampleAlias`.
#' @param TargetKeyId &#91;required&#93; Unique identifier of the customer master key (CMK) to be mapped to the
#' alias. When the update operation completes, the alias will point to this
#' CMK.
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' 
#' To verify that the alias is mapped to the correct CMK, use ListAliases.
#'
#' @section Request syntax:
#' ```
#' svc$update_alias(
#'   AliasName = "string",
#'   TargetKeyId = "string"
#' )
#' ```
#'
#' @examples
#' # The following example updates the specified alias to refer to the
#' # specified customer master key (CMK).
#' \donttest{svc$update_alias(
#'   AliasName = "alias/ExampleAlias",
#'   TargetKeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_update_alias
kms_update_alias <- function(AliasName, TargetKeyId) {
  op <- new_operation(
    name = "UpdateAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$update_alias_input(AliasName = AliasName, TargetKeyId = TargetKeyId)
  output <- .kms$update_alias_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$update_alias <- kms_update_alias

#' Changes the properties of a custom key store
#'
#' Changes the properties of a custom key store. Use the `CustomKeyStoreId`
#' parameter to identify the custom key store you want to edit. Use the
#' remaining parameters to change the properties of the custom key store.
#' 
#' You can only update a custom key store that is disconnected. To
#' disconnect the custom key store, use DisconnectCustomKeyStore. To
#' reconnect the custom key store after the update completes, use
#' ConnectCustomKeyStore. To find the connection state of a custom key
#' store, use the DescribeCustomKeyStores operation.
#' 
#' Use the parameters of `UpdateCustomKeyStore` to edit your keystore
#' settings.
#' 
#' -   Use the **NewCustomKeyStoreName** parameter to change the friendly
#'     name of the custom key store to the value that you specify.
#' 
#' -   Use the **KeyStorePassword** parameter tell AWS KMS the current
#'     password of the [`kmsuser` crypto user
#'     (CU)](https://docs.aws.amazon.com/kms/latest/developerguide/key-store-concepts.html#concept-kmsuser)
#'     in the associated AWS CloudHSM cluster. You can use this parameter
#'     to [fix connection
#'     failures](https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-password)
#'     that occur when AWS KMS cannot log into the associated cluster
#'     because the `kmsuser` password has changed. This value does not
#'     change the password in the AWS CloudHSM cluster.
#' 
#' -   Use the **CloudHsmClusterId** parameter to associate the custom key
#'     store with a different, but related, AWS CloudHSM cluster. You can
#'     use this parameter to repair a custom key store if its AWS CloudHSM
#'     cluster becomes corrupted or is deleted, or when you need to create
#'     or restore a cluster from a backup.
#' 
#' If the operation succeeds, it returns a JSON object with no properties.
#' 
#' This operation is part of the [Custom Key Store
#' feature](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html)
#' feature in AWS KMS, which combines the convenience and extensive
#' integration of AWS KMS with the isolation and control of a single-tenant
#' key store.
#'
#' @usage
#' kms_update_custom_key_store(CustomKeyStoreId, NewCustomKeyStoreName,
#'   KeyStorePassword, CloudHsmClusterId)
#'
#' @param CustomKeyStoreId &#91;required&#93; Identifies the custom key store that you want to update. Enter the ID of
#' the custom key store. To find the ID of a custom key store, use the
#' DescribeCustomKeyStores operation.
#' @param NewCustomKeyStoreName Changes the friendly name of the custom key store to the value that you
#' specify. The custom key store name must be unique in the AWS account.
#' @param KeyStorePassword Enter the current password of the `kmsuser` crypto user (CU) in the AWS
#' CloudHSM cluster that is associated with the custom key store.
#' 
#' This parameter tells AWS KMS the current password of the `kmsuser`
#' crypto user (CU). It does not set or change the password of any users in
#' the AWS CloudHSM cluster.
#' @param CloudHsmClusterId Associates the custom key store with a related AWS CloudHSM cluster.
#' 
#' Enter the cluster ID of the cluster that you used to create the custom
#' key store or a cluster that shares a backup history and has the same
#' cluster certificate as the original cluster. You cannot use this
#' parameter to associate a custom key store with an unrelated cluster. In
#' addition, the replacement cluster must [fulfill the
#' requirements](https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore)
#' for a cluster associated with a custom key store. To view the cluster
#' certificate of a cluster, use the
#' [DescribeClusters](https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html)
#' operation.
#'
#' @section Request syntax:
#' ```
#' svc$update_custom_key_store(
#'   CustomKeyStoreId = "string",
#'   NewCustomKeyStoreName = "string",
#'   KeyStorePassword = "string",
#'   CloudHsmClusterId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname kms_update_custom_key_store
kms_update_custom_key_store <- function(CustomKeyStoreId, NewCustomKeyStoreName = NULL, KeyStorePassword = NULL, CloudHsmClusterId = NULL) {
  op <- new_operation(
    name = "UpdateCustomKeyStore",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$update_custom_key_store_input(CustomKeyStoreId = CustomKeyStoreId, NewCustomKeyStoreName = NewCustomKeyStoreName, KeyStorePassword = KeyStorePassword, CloudHsmClusterId = CloudHsmClusterId)
  output <- .kms$update_custom_key_store_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$update_custom_key_store <- kms_update_custom_key_store

#' Updates the description of a customer master key (CMK)
#'
#' Updates the description of a customer master key (CMK). To see the
#' description of a CMK, use DescribeKey.
#' 
#' You cannot perform this operation on a CMK in a different AWS account.
#' 
#' The result of this operation varies with the key state of the CMK. For
#' details, see [How Key State Affects Use of a Customer Master
#' Key](https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
#' in the *AWS Key Management Service Developer Guide*.
#'
#' @usage
#' kms_update_key_description(KeyId, Description)
#'
#' @param KeyId &#91;required&#93; A unique identifier for the customer master key (CMK).
#' 
#' Specify the key ID or the Amazon Resource Name (ARN) of the CMK.
#' 
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
#' @param Description &#91;required&#93; New description for the CMK.
#'
#' @section Request syntax:
#' ```
#' svc$update_key_description(
#'   KeyId = "string",
#'   Description = "string"
#' )
#' ```
#'
#' @examples
#' # The following example updates the description of the specified CMK.
#' \donttest{svc$update_key_description(
#'   Description = "Example description that indicates the intended use of this CMK.",
#'   KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
#' )}
#'
#' @keywords internal
#'
#' @rdname kms_update_key_description
kms_update_key_description <- function(KeyId, Description) {
  op <- new_operation(
    name = "UpdateKeyDescription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .kms$update_key_description_input(KeyId = KeyId, Description = Description)
  output <- .kms$update_key_description_output()
  svc <- .kms$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.kms$operations$update_key_description <- kms_update_key_description
