% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_account_alias}
\alias{iam_create_account_alias}
\title{Creates an alias for your AWS account}
\usage{
iam_create_account_alias(AccountAlias)
}
\arguments{
\item{AccountAlias}{[required] The account alias to create.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of lowercase letters, digits, and dashes. You cannot start or
finish with a dash, nor can you have two dashes in a row.}
}
\description{
Creates an alias for your AWS account. For information about using an
AWS account alias, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/console_account-alias.html}{Using an Alias for Your AWS Account ID}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_account_alias(
  AccountAlias = "string"
)
}
}

\examples{
\dontrun{
# The following command associates the alias examplecorp to your AWS
# account.
svc$create_account_alias(
  AccountAlias = "examplecorp"
)
}

}
\keyword{internal}
