% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_set_risk_configuration}
\alias{cognitoidentityprovider_set_risk_configuration}
\title{Configures actions on detected risks}
\usage{
cognitoidentityprovider_set_risk_configuration(UserPoolId, ClientId,
  CompromisedCredentialsRiskConfiguration,
  AccountTakeoverRiskConfiguration, RiskExceptionConfiguration)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID.}

\item{ClientId}{The app client ID. If \code{ClientId} is null, then the risk configuration is
mapped to \code{userPoolId}. When the client ID is null, the same risk
configuration is applied to all the clients in the userPool.

Otherwise, \code{ClientId} is mapped to the client. When the client ID is not
null, the user pool configuration is overridden and the risk
configuration for the client is used instead.}

\item{CompromisedCredentialsRiskConfiguration}{The compromised credentials risk configuration.}

\item{AccountTakeoverRiskConfiguration}{The account takeover risk configuration.}

\item{RiskExceptionConfiguration}{The configuration to override the risk decision.}
}
\description{
Configures actions on detected risks. To delete the risk configuration
for \code{UserPoolId} or \code{ClientId}, pass null values for all four
configuration types.

To enable Amazon Cognito advanced security features, update the user
pool to include the \code{UserPoolAddOns} key\code{AdvancedSecurityMode}.
}
\section{Request syntax}{
\preformatted{svc$set_risk_configuration(
  UserPoolId = "string",
  ClientId = "string",
  CompromisedCredentialsRiskConfiguration = list(
    EventFilter = list(
      "SIGN_IN"|"PASSWORD_CHANGE"|"SIGN_UP"
    ),
    Actions = list(
      EventAction = "BLOCK"|"NO_ACTION"
    )
  ),
  AccountTakeoverRiskConfiguration = list(
    NotifyConfiguration = list(
      From = "string",
      ReplyTo = "string",
      SourceArn = "string",
      BlockEmail = list(
        Subject = "string",
        HtmlBody = "string",
        TextBody = "string"
      ),
      NoActionEmail = list(
        Subject = "string",
        HtmlBody = "string",
        TextBody = "string"
      ),
      MfaEmail = list(
        Subject = "string",
        HtmlBody = "string",
        TextBody = "string"
      )
    ),
    Actions = list(
      LowAction = list(
        Notify = TRUE|FALSE,
        EventAction = "BLOCK"|"MFA_IF_CONFIGURED"|"MFA_REQUIRED"|"NO_ACTION"
      ),
      MediumAction = list(
        Notify = TRUE|FALSE,
        EventAction = "BLOCK"|"MFA_IF_CONFIGURED"|"MFA_REQUIRED"|"NO_ACTION"
      ),
      HighAction = list(
        Notify = TRUE|FALSE,
        EventAction = "BLOCK"|"MFA_IF_CONFIGURED"|"MFA_REQUIRED"|"NO_ACTION"
      )
    )
  ),
  RiskExceptionConfiguration = list(
    BlockedIPRangeList = list(
      "string"
    ),
    SkippedIPRangeList = list(
      "string"
    )
  )
)
}
}

\keyword{internal}
