% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_list_members}
\alias{securityhub_list_members}
\title{Lists details about all member accounts for the current Security Hub
master account}
\usage{
securityhub_list_members(OnlyAssociated, MaxResults, NextToken)
}
\arguments{
\item{OnlyAssociated}{Specifies which member accounts to include in the response based on
their relationship status with the master account. The default value is
\code{TRUE}.

If \code{OnlyAssociated} is set to \code{TRUE}, the response includes member
accounts whose relationship status with the master is set to \code{ENABLED}.

If \code{OnlyAssociated} is set to \code{FALSE}, the response includes all
existing member accounts.}

\item{MaxResults}{The maximum number of items to return in the response.}

\item{NextToken}{The token that is required for pagination. On your first call to the
\code{ListMembers} operation, set the value of this parameter to \code{NULL}.

For subsequent calls to the operation, to continue listing data, set the
value of this parameter to the value returned from the previous
response.}
}
\description{
Lists details about all member accounts for the current Security Hub
master account.

The results include both member accounts that belong to an organization
and member accounts that were invited manually.
}
\section{Request syntax}{
\preformatted{svc$list_members(
  OnlyAssociated = TRUE|FALSE,
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
