% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_update_alias}
\alias{kms_update_alias}
\title{Associates an existing AWS KMS alias with a different customer master
key (CMK)}
\usage{
kms_update_alias(AliasName, TargetKeyId)
}
\arguments{
\item{AliasName}{[required] Identifies the alias that is changing its CMK. This value must begin
with \verb{alias/} followed by the alias name, such as \code{alias/ExampleAlias}.
You cannot use UpdateAlias to change the alias name.}

\item{TargetKeyId}{[required] Identifies the \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#customer-cmk}{customer managed CMK}
to associate with the alias. You don't have permission to associate an
alias with an \href{https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk}{AWS managed CMK}.

The CMK must be in the same AWS account and Region as the alias. Also,
the new target CMK must be the same type as the current target CMK (both
symmetric or both asymmetric) and they must have the same key usage.

Specify the key ID or the Amazon Resource Name (ARN) of the CMK.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.

To verify that the alias is mapped to the correct CMK, use ListAliases.}
}
\description{
Associates an existing AWS KMS alias with a different customer master
key (CMK). Each alias is associated with only one CMK at a time,
although a CMK can have multiple aliases. The alias and the CMK must be
in the same AWS account and region.

The current and new CMK must be the same type (both symmetric or both
asymmetric), and they must have the same key usage (\code{ENCRYPT_DECRYPT} or
\code{SIGN_VERIFY}). This restriction prevents errors in code that uses
aliases. If you must assign an alias to a different type of CMK, use
DeleteAlias to delete the old alias and CreateAlias to create a new
alias.

You cannot use \code{UpdateAlias} to change an alias name. To change an alias
name, use DeleteAlias to delete the old alias and CreateAlias to create
a new alias.

Because an alias is not a property of a CMK, you can create, update, and
delete the aliases of a CMK without affecting the CMK. Also, aliases do
not appear in the response from the DescribeKey operation. To get the
aliases of all CMKs in the account, use the ListAliases operation.

The CMK that you use for this operation must be in a compatible key
state. For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.

\strong{Cross-account use}: No. You cannot perform this operation on a CMK in
a different AWS account.

\strong{Required permissions}
\itemize{
\item \href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:UpdateAlias}
on the alias (IAM policy).
\item \href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:UpdateAlias}
on the current CMK (key policy).
\item \href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:UpdateAlias}
on the new CMK (key policy).
}

For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html#alias-access}{Controlling access to aliases}
in the \emph{AWS Key Management Service Developer Guide}.

\strong{Related operations:}
\itemize{
\item CreateAlias
\item DeleteAlias
\item ListAliases
}
}
\section{Request syntax}{
\preformatted{svc$update_alias(
  AliasName = "string",
  TargetKeyId = "string"
)
}
}

\examples{
\dontrun{
# The following example updates the specified alias to refer to the
# specified customer master key (CMK).
svc$update_alias(
  AliasName = "alias/ExampleAlias",
  TargetKeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)
}

}
\keyword{internal}
