% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_enable_key_rotation}
\alias{kms_enable_key_rotation}
\title{Enables automatic rotation of the key material for the specified
customer master key (CMK)}
\usage{
kms_enable_key_rotation(KeyId)
}
\arguments{
\item{KeyId}{[required] A unique identifier for the customer master key (CMK).

Specify the key ID or the Amazon Resource Name (ARN) of the CMK.

For example:
\itemize{
\item Key ID: \code{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\code{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}
}
\description{
Enables \href{http://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html}{automatic rotation of the key material}
for the specified customer master key (CMK). You cannot perform this
operation on a CMK in a different AWS account.
}
\details{
You cannot enable automatic rotation of CMKs with imported key material
or CMKs in a \href{http://docs.aws.amazon.com/kms/latest/developerguide/key-store-overview.html}{custom key store}.

The result of this operation varies with the key state of the CMK. For
details, see \href{http://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$enable_key_rotation(
  KeyId = "string"
)
}
}

\examples{
# The following example enables automatic annual rotation of the key
# material for the specified CMK.
\donttest{svc$enable_key_rotation(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)}

}
\keyword{internal}
