% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_get_certificate_authority_csr}
\alias{acmpca_get_certificate_authority_csr}
\title{Retrieves the certificate signing request (CSR) for your private
certificate authority (CA)}
\usage{
acmpca_get_certificate_authority_csr(CertificateAuthorityArn)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) that was returned when you called the
CreateCertificateAuthority operation. This must be of the form:

\code{arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> }}
}
\description{
Retrieves the certificate signing request (CSR) for your private
certificate authority (CA). The CSR is created when you call the
CreateCertificateAuthority operation. Take the CSR to your on-premises
X.509 infrastructure and sign it by using your root or a subordinate CA.
Then import the signed certificate back into ACM PCA by calling the
ImportCertificateAuthorityCertificate operation. The CSR is returned as
a base64 PEM-encoded string.
}
\section{Request syntax}{
\preformatted{svc$get_certificate_authority_csr(
  CertificateAuthorityArn = "string"
)
}
}

\keyword{internal}
