% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_create_user_pool_client}
\alias{cognitoidentityprovider_create_user_pool_client}
\title{Creates the user pool client}
\usage{
cognitoidentityprovider_create_user_pool_client(UserPoolId, ClientName,
  GenerateSecret, RefreshTokenValidity, ReadAttributes, WriteAttributes,
  ExplicitAuthFlows, SupportedIdentityProviders, CallbackURLs, LogoutURLs,
  DefaultRedirectURI, AllowedOAuthFlows, AllowedOAuthScopes,
  AllowedOAuthFlowsUserPoolClient, AnalyticsConfiguration)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool where you want to create a user pool
client.}

\item{ClientName}{[required] The client name for the user pool client you would like to create.}

\item{GenerateSecret}{Boolean to specify whether you want to generate a secret for the user
pool client being created.}

\item{RefreshTokenValidity}{The time limit, in days, after which the refresh token is no longer
valid and cannot be used.}

\item{ReadAttributes}{The read attributes.}

\item{WriteAttributes}{The user pool attributes that the app client can write to.

If your app client allows users to sign in through an identity provider,
this array must include all attributes that are mapped to identity
provider attributes. Amazon Cognito updates mapped attributes when users
sign in to your application through an identity provider. If your app
client lacks write access to a mapped attribute, Amazon Cognito throws
an error when it attempts to update the attribute. For more information,
see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html}{Specifying Identity Provider Attribute Mappings for Your User Pool}.}

\item{ExplicitAuthFlows}{The explicit authentication flows.}

\item{SupportedIdentityProviders}{A list of provider names for the identity providers that are supported
on this client.}

\item{CallbackURLs}{A list of allowed redirect (callback) URLs for the identity providers.

A redirect URI must:
\itemize{
\item Be an absolute URI.
\item Be registered with the authorization server.
\item Not include a fragment component.
}

See \href{https://tools.ietf.org/html/rfc6749#section-3.1.2}{OAuth 2.0 - Redirection Endpoint}.

Amazon Cognito requires HTTPS over HTTP except for http://localhost for
testing purposes only.

App callback URLs such as myapp://example are also supported.}

\item{LogoutURLs}{A list of allowed logout URLs for the identity providers.}

\item{DefaultRedirectURI}{The default redirect URI. Must be in the \code{CallbackURLs} list.

A redirect URI must:
\itemize{
\item Be an absolute URI.
\item Be registered with the authorization server.
\item Not include a fragment component.
}

See \href{https://tools.ietf.org/html/rfc6749#section-3.1.2}{OAuth 2.0 - Redirection Endpoint}.

Amazon Cognito requires HTTPS over HTTP except for http://localhost for
testing purposes only.

App callback URLs such as myapp://example are also supported.}

\item{AllowedOAuthFlows}{Set to \code{code} to initiate a code grant flow, which provides an
authorization code as the response. This code can be exchanged for
access tokens with the token endpoint.

Set to \code{token} to specify that the client should get the access token
(and, optionally, ID token, based on scopes) directly.}

\item{AllowedOAuthScopes}{A list of allowed \code{OAuth} scopes. Currently supported values are
\code{"phone"}, \code{"email"}, \code{"openid"}, and \code{"Cognito"}.}

\item{AllowedOAuthFlowsUserPoolClient}{Set to \code{True} if the client is allowed to follow the OAuth protocol when
interacting with Cognito user pools.}

\item{AnalyticsConfiguration}{The Amazon Pinpoint analytics configuration for collecting metrics for
this user pool.}
}
\description{
Creates the user pool client.
}
\section{Request syntax}{
\preformatted{svc$create_user_pool_client(
  UserPoolId = "string",
  ClientName = "string",
  GenerateSecret = TRUE|FALSE,
  RefreshTokenValidity = 123,
  ReadAttributes = list(
    "string"
  ),
  WriteAttributes = list(
    "string"
  ),
  ExplicitAuthFlows = list(
    "ADMIN_NO_SRP_AUTH"|"CUSTOM_AUTH_FLOW_ONLY"|"USER_PASSWORD_AUTH"
  ),
  SupportedIdentityProviders = list(
    "string"
  ),
  CallbackURLs = list(
    "string"
  ),
  LogoutURLs = list(
    "string"
  ),
  DefaultRedirectURI = "string",
  AllowedOAuthFlows = list(
    "code"|"implicit"|"client_credentials"
  ),
  AllowedOAuthScopes = list(
    "string"
  ),
  AllowedOAuthFlowsUserPoolClient = TRUE|FALSE,
  AnalyticsConfiguration = list(
    ApplicationId = "string",
    RoleArn = "string",
    ExternalId = "string",
    UserDataShared = TRUE|FALSE
  )
)
}
}

\keyword{internal}
