% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_confirm_forgot_password}
\alias{cognitoidentityprovider_confirm_forgot_password}
\title{Allows a user to enter a confirmation code to reset a forgotten password}
\usage{
cognitoidentityprovider_confirm_forgot_password(ClientId, SecretHash,
  Username, ConfirmationCode, Password, AnalyticsMetadata,
  UserContextData)
}
\arguments{
\item{ClientId}{[required] The app client ID of the app associated with the user pool.}

\item{SecretHash}{A keyed-hash message authentication code (HMAC) calculated using the
secret key of a user pool client and username plus the client ID in the
message.}

\item{Username}{[required] The user name of the user for whom you want to enter a code to retrieve
a forgotten password.}

\item{ConfirmationCode}{[required] The confirmation code sent by a user's request to retrieve a forgotten
password. For more information, see}

\item{Password}{[required] The password sent by a user's request to retrieve a forgotten password.}

\item{AnalyticsMetadata}{The Amazon Pinpoint analytics metadata for collecting metrics for
\code{ConfirmForgotPassword} calls.}

\item{UserContextData}{Contextual data such as the user's device fingerprint, IP address, or
location used for evaluating the risk of an unexpected event by Amazon
Cognito advanced security.}
}
\description{
Allows a user to enter a confirmation code to reset a forgotten
password.
}
\section{Request syntax}{
\preformatted{svc$confirm_forgot_password(
  ClientId = "string",
  SecretHash = "string",
  Username = "string",
  ConfirmationCode = "string",
  Password = "string",
  AnalyticsMetadata = list(
    AnalyticsEndpointId = "string"
  ),
  UserContextData = list(
    EncodedData = "string"
  )
)
}
}

\keyword{internal}
