% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_list_field_level_encryption_profiles}
\alias{cloudfront_list_field_level_encryption_profiles}
\title{Request a list of field-level encryption profiles that have been created
in CloudFront for this account}
\usage{
cloudfront_list_field_level_encryption_profiles(Marker, MaxItems)
}
\arguments{
\item{Marker}{Use this when paginating results to indicate where to begin in your list
of profiles. The results include profiles in the list that occur after
the marker. To get the next page of results, set the \code{Marker} to the
value of the \code{NextMarker} from the current page's response (which is
also the ID of the last profile on that page).}

\item{MaxItems}{The maximum number of field-level encryption profiles you want in the
response body.}
}
\value{
A list with the following syntax:\preformatted{list(
  FieldLevelEncryptionProfileList = list(
    NextMarker = "string",
    MaxItems = 123,
    Quantity = 123,
    Items = list(
      list(
        Id = "string",
        LastModifiedTime = as.POSIXct(
          "2015-01-01"
        ),
        Name = "string",
        EncryptionEntities = list(
          Quantity = 123,
          Items = list(
            list(
              PublicKeyId = "string",
              ProviderId = "string",
              FieldPatterns = list(
                Quantity = 123,
                Items = list(
                  "string"
                )
              )
            )
          )
        ),
        Comment = "string"
      )
    )
  )
)
}
}
\description{
Request a list of field-level encryption profiles that have been created
in CloudFront for this account.
}
\section{Request syntax}{
\preformatted{svc$list_field_level_encryption_profiles(
  Marker = "string",
  MaxItems = "string"
)
}
}

\keyword{internal}
