% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudfront_operations.R
\name{cloudfront_update_key_group}
\alias{cloudfront_update_key_group}
\title{Updates a key group}
\usage{
cloudfront_update_key_group(KeyGroupConfig, Id, IfMatch)
}
\arguments{
\item{KeyGroupConfig}{[required] The key group configuration.}

\item{Id}{[required] The identifier of the key group that you are updating.}

\item{IfMatch}{The version of the key group that you are updating. The version is the
key group’s \code{ETag} value.}
}
\description{
Updates a key group.

When you update a key group, all the fields are updated with the values
provided in the request. You cannot update some fields independent of
others. To update a key group:
\enumerate{
\item Get the current key group with \code{GetKeyGroup} or \code{GetKeyGroupConfig}.
\item Locally modify the fields in the key group that you want to update.
For example, add or remove public key IDs.
\item Call \code{UpdateKeyGroup} with the entire key group object, including
the fields that you modified and those that you didn’t.
}
}
\section{Request syntax}{
\preformatted{svc$update_key_group(
  KeyGroupConfig = list(
    Name = "string",
    Items = list(
      "string"
    ),
    Comment = "string"
  ),
  Id = "string",
  IfMatch = "string"
)
}
}

\keyword{internal}
