% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigatewayv2_operations.R
\name{apigatewayv2_create_authorizer}
\alias{apigatewayv2_create_authorizer}
\title{Creates an Authorizer for an API}
\usage{
apigatewayv2_create_authorizer(ApiId, AuthorizerCredentialsArn,
  AuthorizerPayloadFormatVersion, AuthorizerResultTtlInSeconds,
  AuthorizerType, AuthorizerUri, EnableSimpleResponses, IdentitySource,
  IdentityValidationExpression, JwtConfiguration, Name)
}
\arguments{
\item{ApiId}{[required] The API identifier.}

\item{AuthorizerCredentialsArn}{Specifies the required credentials as an IAM role for API Gateway to
invoke the authorizer. To specify an IAM role for API Gateway to assume,
use the role's Amazon Resource Name (ARN). To use resource-based
permissions on the Lambda function, don't specify this parameter.
Supported only for REQUEST authorizers.}

\item{AuthorizerPayloadFormatVersion}{Specifies the format of the payload sent to an HTTP API Lambda
authorizer. Required for HTTP API Lambda authorizers. Supported values
are 1.0 and 2.0. To learn more, see \href{https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html}{Working with AWS Lambda authorizers for HTTP APIs}.}

\item{AuthorizerResultTtlInSeconds}{The time to live (TTL) for cached authorizer results, in seconds. If it
equals 0, authorization caching is disabled. If it is greater than 0,
API Gateway caches authorizer responses. The maximum value is 3600, or 1
hour. Supported only for HTTP API Lambda authorizers.}

\item{AuthorizerType}{[required] The authorizer type. Specify REQUEST for a Lambda function using
incoming request parameters. Specify JWT to use JSON Web Tokens
(supported only for HTTP APIs).}

\item{AuthorizerUri}{The authorizer's Uniform Resource Identifier (URI). For REQUEST
authorizers, this must be a well-formed Lambda function URI, for
example,
arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:\{account\\_id\}:function:\{lambda\\_function\\_name\}/invocations.
In general, the URI has this form:
arn:aws:apigateway:\{region\}:lambda:path/\{service\\_api\} , where \{region\}
is the same as the region hosting the Lambda function, path indicates
that the remaining substring in the URI should be treated as the path to
the resource, including the initial /. For Lambda functions, this is
usually of the form /2015-03-31/functions/[FunctionARN]/invocations.
Supported only for REQUEST authorizers.}

\item{EnableSimpleResponses}{Specifies whether a Lambda authorizer returns a response in a simple
format. By default, a Lambda authorizer must return an IAM policy. If
enabled, the Lambda authorizer can return a boolean value instead of an
IAM policy. Supported only for HTTP APIs. To learn more, see \href{https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html}{Working with AWS Lambda authorizers for HTTP APIs}}

\item{IdentitySource}{[required] The identity source for which authorization is requested.

For a REQUEST authorizer, this is optional. The value is a set of one or
more mapping expressions of the specified request parameters. The
identity source can be headers, query string parameters, stage
variables, and context parameters. For example, if an Auth header and a
Name query string parameter are defined as identity sources, this value
is route.request.header.Auth, route.request.querystring.Name for
WebSocket APIs. For HTTP APIs, use selection expressions prefixed with
$, for example, $request.header.Auth, $request.querystring.Name. These
parameters are used to perform runtime validation for Lambda-based
authorizers by verifying all of the identity-related request parameters
are present in the request, not null, and non-empty. Only when this is
true does the authorizer invoke the authorizer Lambda function.
Otherwise, it returns a 401 Unauthorized response without calling the
Lambda function. For HTTP APIs, identity sources are also used as the
cache key when caching is enabled. To learn more, see \href{https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-lambda-authorizer.html}{Working with AWS Lambda authorizers for HTTP APIs}.

For JWT, a single entry that specifies where to extract the JSON Web
Token (JWT) from inbound requests. Currently only header-based and query
parameter-based selections are supported, for example
$request.header.Authorization.}

\item{IdentityValidationExpression}{This parameter is not used.}

\item{JwtConfiguration}{Represents the configuration of a JWT authorizer. Required for the JWT
authorizer type. Supported only for HTTP APIs.}

\item{Name}{[required] The name of the authorizer.}
}
\description{
Creates an Authorizer for an API.
}
\section{Request syntax}{
\preformatted{svc$create_authorizer(
  ApiId = "string",
  AuthorizerCredentialsArn = "string",
  AuthorizerPayloadFormatVersion = "string",
  AuthorizerResultTtlInSeconds = 123,
  AuthorizerType = "REQUEST"|"JWT",
  AuthorizerUri = "string",
  EnableSimpleResponses = TRUE|FALSE,
  IdentitySource = list(
    "string"
  ),
  IdentityValidationExpression = "string",
  JwtConfiguration = list(
    Audience = list(
      "string"
    ),
    Issuer = "string"
  ),
  Name = "string"
)
}
}

\keyword{internal}
