% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_start_pipeline_execution}
\alias{sagemaker_start_pipeline_execution}
\title{Starts a pipeline execution}
\usage{
sagemaker_start_pipeline_execution(PipelineName,
  PipelineExecutionDisplayName, PipelineParameters,
  PipelineExecutionDescription, ClientRequestToken)
}
\arguments{
\item{PipelineName}{[required] The name of the pipeline.}

\item{PipelineExecutionDisplayName}{The display name of the pipeline execution.}

\item{PipelineParameters}{Contains a list of pipeline parameters. This list can be empty.}

\item{PipelineExecutionDescription}{The description of the pipeline execution.}

\item{ClientRequestToken}{[required] A unique, case-sensitive identifier that you provide to ensure the
idempotency of the operation. An idempotent operation completes no more
than one time.}
}
\value{
A list with the following syntax:\preformatted{list(
  PipelineExecutionArn = "string"
)
}
}
\description{
Starts a pipeline execution.
}
\section{Request syntax}{
\preformatted{svc$start_pipeline_execution(
  PipelineName = "string",
  PipelineExecutionDisplayName = "string",
  PipelineParameters = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  PipelineExecutionDescription = "string",
  ClientRequestToken = "string"
)
}
}

\keyword{internal}
