% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_get_intent}
\alias{lexmodelbuildingservice_get_intent}
\title{Returns information about an intent}
\usage{
lexmodelbuildingservice_get_intent(name, version)
}
\arguments{
\item{name}{[required] The name of the intent. The name is case sensitive.}

\item{version}{[required] The version of the intent.}
}
\value{
A list with the following syntax:\preformatted{list(
  name = "string",
  description = "string",
  slots = list(
    list(
      name = "string",
      description = "string",
      slotConstraint = "Required"|"Optional",
      slotType = "string",
      slotTypeVersion = "string",
      valueElicitationPrompt = list(
        messages = list(
          list(
            contentType = "PlainText"|"SSML"|"CustomPayload",
            content = "string",
            groupNumber = 123
          )
        ),
        maxAttempts = 123,
        responseCard = "string"
      ),
      priority = 123,
      sampleUtterances = list(
        "string"
      ),
      responseCard = "string",
      obfuscationSetting = "NONE"|"DEFAULT_OBFUSCATION",
      defaultValueSpec = list(
        defaultValueList = list(
          list(
            defaultValue = "string"
          )
        )
      )
    )
  ),
  sampleUtterances = list(
    "string"
  ),
  confirmationPrompt = list(
    messages = list(
      list(
        contentType = "PlainText"|"SSML"|"CustomPayload",
        content = "string",
        groupNumber = 123
      )
    ),
    maxAttempts = 123,
    responseCard = "string"
  ),
  rejectionStatement = list(
    messages = list(
      list(
        contentType = "PlainText"|"SSML"|"CustomPayload",
        content = "string",
        groupNumber = 123
      )
    ),
    responseCard = "string"
  ),
  followUpPrompt = list(
    prompt = list(
      messages = list(
        list(
          contentType = "PlainText"|"SSML"|"CustomPayload",
          content = "string",
          groupNumber = 123
        )
      ),
      maxAttempts = 123,
      responseCard = "string"
    ),
    rejectionStatement = list(
      messages = list(
        list(
          contentType = "PlainText"|"SSML"|"CustomPayload",
          content = "string",
          groupNumber = 123
        )
      ),
      responseCard = "string"
    )
  ),
  conclusionStatement = list(
    messages = list(
      list(
        contentType = "PlainText"|"SSML"|"CustomPayload",
        content = "string",
        groupNumber = 123
      )
    ),
    responseCard = "string"
  ),
  dialogCodeHook = list(
    uri = "string",
    messageVersion = "string"
  ),
  fulfillmentActivity = list(
    type = "ReturnIntent"|"CodeHook",
    codeHook = list(
      uri = "string",
      messageVersion = "string"
    )
  ),
  parentIntentSignature = "string",
  lastUpdatedDate = as.POSIXct(
    "2015-01-01"
  ),
  createdDate = as.POSIXct(
    "2015-01-01"
  ),
  version = "string",
  checksum = "string",
  kendraConfiguration = list(
    kendraIndex = "string",
    queryFilterString = "string",
    role = "string"
  ),
  inputContexts = list(
    list(
      name = "string"
    )
  ),
  outputContexts = list(
    list(
      name = "string",
      timeToLiveInSeconds = 123,
      turnsToLive = 123
    )
  )
)
}
}
\description{
Returns information about an intent. In addition to the intent name, you
must specify the intent version.

This operation requires permissions to perform the \code{lex:GetIntent}
action.
}
\section{Request syntax}{
\preformatted{svc$get_intent(
  name = "string",
  version = "string"
)
}
}

\examples{
\dontrun{
# This example shows how to get information about an intent.
svc$get_intent(
  version = "$LATEST",
  name = "DocOrderPizza"
)
}

}
\keyword{internal}
