# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon SageMaker Runtime
#'
#' @description
#' The Amazon SageMaker runtime API.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- sagemakerruntime(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- sagemakerruntime()
#' svc$invoke_endpoint(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=sagemakerruntime_invoke_endpoint]{invoke_endpoint} \tab After you deploy a model into production using Amazon SageMaker hosting services, your client applications use this API to get inferences from the model hosted at the specified endpoint
#' }
#'
#' @rdname sagemakerruntime
#' @export
sagemakerruntime <- function(config = list()) {
  svc <- .sagemakerruntime$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.sagemakerruntime <- list()

.sagemakerruntime$operations <- list()

.sagemakerruntime$metadata <- list(
  service_name = "runtime.sagemaker",
  endpoints = list("*" = list(endpoint = "runtime.sagemaker.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "runtime.sagemaker.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "runtime.sagemaker.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "runtime.sagemaker.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "SageMaker Runtime",
  api_version = "2017-05-13",
  signing_name = "sagemaker",
  json_version = "1.1",
  target_prefix = ""
)

.sagemakerruntime$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.sagemakerruntime$metadata, handlers, config)
}
