% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeartifact_operations.R
\name{codeartifact_list_package_version_dependencies}
\alias{codeartifact_list_package_version_dependencies}
\title{Returns the direct dependencies for a package version}
\usage{
codeartifact_list_package_version_dependencies(
  domain,
  domainOwner = NULL,
  repository,
  format,
  namespace = NULL,
  package,
  packageVersion,
  nextToken = NULL
)
}
\arguments{
\item{domain}{[required] The name of the domain that contains the repository that contains the
requested package version dependencies.}

\item{domainOwner}{The 12-digit account number of the Amazon Web Services account that owns
the domain. It does not include dashes or spaces.}

\item{repository}{[required] The name of the repository that contains the requested package version.}

\item{format}{[required] The format of the package with the requested dependencies.}

\item{namespace}{The namespace of the package version with the requested dependencies.
The package version component that specifies its namespace depends on
its type. For example:
\itemize{
\item The namespace of a Maven package version is its \code{groupId}.
\item The namespace of an npm package version is its \code{scope}.
\item Python and NuGet package versions do not contain a corresponding
component, package versions of those formats do not have a
namespace.
\item The namespace of a generic package is its \code{namespace}.
}}

\item{package}{[required] The name of the package versions' package.}

\item{packageVersion}{[required] A string that contains the package version (for example, \verb{3.5.2}).}

\item{nextToken}{The token for the next set of results. Use the value returned in the
previous response in the next request to retrieve the next set of
results.}
}
\description{
Returns the direct dependencies for a package version. The dependencies are returned as \href{https://docs.aws.amazon.com/codeartifact/latest/APIReference/API_PackageDependency.html}{PackageDependency} objects. CodeArtifact extracts the dependencies for a package version from the metadata file for the package format (for example, the \code{package.json} file for npm packages and the \code{pom.xml} file for Maven). Any package version dependencies that are not listed in the configuration file are not returned.

See \url{https://www.paws-r-sdk.com/docs/codeartifact_list_package_version_dependencies/} for full documentation.
}
\keyword{internal}
