# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include drs_service.R
NULL

#' Associate a Source Network to an existing CloudFormation Stack and
#' modify launch templates to use this network
#'
#' @description
#' Associate a Source Network to an existing CloudFormation Stack and modify launch templates to use this network. Can be used for reverting to previously deployed CloudFormation stacks.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_associate_source_network_stack/](https://www.paws-r-sdk.com/docs/drs_associate_source_network_stack/) for full documentation.
#'
#' @param cfnStackName &#91;required&#93; CloudFormation template to associate with a Source Network.
#' @param sourceNetworkID &#91;required&#93; The Source Network ID to associate with CloudFormation template.
#'
#' @keywords internal
#'
#' @rdname drs_associate_source_network_stack
drs_associate_source_network_stack <- function(cfnStackName, sourceNetworkID) {
  op <- new_operation(
    name = "AssociateSourceNetworkStack",
    http_method = "POST",
    http_path = "/AssociateSourceNetworkStack",
    paginator = list()
  )
  input <- .drs$associate_source_network_stack_input(cfnStackName = cfnStackName, sourceNetworkID = sourceNetworkID)
  output <- .drs$associate_source_network_stack_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$associate_source_network_stack <- drs_associate_source_network_stack

#' Create an extended source server in the target Account based on the
#' source server in staging account
#'
#' @description
#' Create an extended source server in the target Account based on the source server in staging account.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_create_extended_source_server/](https://www.paws-r-sdk.com/docs/drs_create_extended_source_server/) for full documentation.
#'
#' @param sourceServerArn &#91;required&#93; This defines the ARN of the source server in staging Account based on
#' which you want to create an extended source server.
#' @param tags A list of tags associated with the extended source server.
#'
#' @keywords internal
#'
#' @rdname drs_create_extended_source_server
drs_create_extended_source_server <- function(sourceServerArn, tags = NULL) {
  op <- new_operation(
    name = "CreateExtendedSourceServer",
    http_method = "POST",
    http_path = "/CreateExtendedSourceServer",
    paginator = list()
  )
  input <- .drs$create_extended_source_server_input(sourceServerArn = sourceServerArn, tags = tags)
  output <- .drs$create_extended_source_server_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$create_extended_source_server <- drs_create_extended_source_server

#' Creates a new Launch Configuration Template
#'
#' @description
#' Creates a new Launch Configuration Template.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_create_launch_configuration_template/](https://www.paws-r-sdk.com/docs/drs_create_launch_configuration_template/) for full documentation.
#'
#' @param copyPrivateIp Copy private IP.
#' @param copyTags Copy tags.
#' @param exportBucketArn S3 bucket ARN to export Source Network templates.
#' @param launchDisposition Launch disposition.
#' @param launchIntoSourceInstance DRS will set the 'launch into instance ID' of any source server when
#' performing a drill, recovery or failback to the previous region or
#' availability zone, using the instance ID of the source instance.
#' @param licensing Licensing.
#' @param postLaunchEnabled Whether we want to activate post-launch actions.
#' @param tags Request to associate tags during creation of a Launch Configuration
#' Template.
#' @param targetInstanceTypeRightSizingMethod Target instance type right-sizing method.
#'
#' @keywords internal
#'
#' @rdname drs_create_launch_configuration_template
drs_create_launch_configuration_template <- function(copyPrivateIp = NULL, copyTags = NULL, exportBucketArn = NULL, launchDisposition = NULL, launchIntoSourceInstance = NULL, licensing = NULL, postLaunchEnabled = NULL, tags = NULL, targetInstanceTypeRightSizingMethod = NULL) {
  op <- new_operation(
    name = "CreateLaunchConfigurationTemplate",
    http_method = "POST",
    http_path = "/CreateLaunchConfigurationTemplate",
    paginator = list()
  )
  input <- .drs$create_launch_configuration_template_input(copyPrivateIp = copyPrivateIp, copyTags = copyTags, exportBucketArn = exportBucketArn, launchDisposition = launchDisposition, launchIntoSourceInstance = launchIntoSourceInstance, licensing = licensing, postLaunchEnabled = postLaunchEnabled, tags = tags, targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod)
  output <- .drs$create_launch_configuration_template_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$create_launch_configuration_template <- drs_create_launch_configuration_template

#' Creates a new ReplicationConfigurationTemplate
#'
#' @description
#' Creates a new ReplicationConfigurationTemplate.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_create_replication_configuration_template/](https://www.paws-r-sdk.com/docs/drs_create_replication_configuration_template/) for full documentation.
#'
#' @param associateDefaultSecurityGroup &#91;required&#93; Whether to associate the default Elastic Disaster Recovery Security
#' group with the Replication Configuration Template.
#' @param autoReplicateNewDisks Whether to allow the AWS replication agent to automatically replicate
#' newly added disks.
#' @param bandwidthThrottling &#91;required&#93; Configure bandwidth throttling for the outbound data transfer rate of
#' the Source Server in Mbps.
#' @param createPublicIP &#91;required&#93; Whether to create a Public IP for the Recovery Instance by default.
#' @param dataPlaneRouting &#91;required&#93; The data plane routing mechanism that will be used for replication.
#' @param defaultLargeStagingDiskType &#91;required&#93; The Staging Disk EBS volume type to be used during replication.
#' @param ebsEncryption &#91;required&#93; The type of EBS encryption to be used during replication.
#' @param ebsEncryptionKeyArn The ARN of the EBS encryption key to be used during replication.
#' @param pitPolicy &#91;required&#93; The Point in time (PIT) policy to manage snapshots taken during
#' replication.
#' @param replicationServerInstanceType &#91;required&#93; The instance type to be used for the replication server.
#' @param replicationServersSecurityGroupsIDs &#91;required&#93; The security group IDs that will be used by the replication server.
#' @param stagingAreaSubnetId &#91;required&#93; The subnet to be used by the replication staging area.
#' @param stagingAreaTags &#91;required&#93; A set of tags to be associated with all resources created in the
#' replication staging area: EC2 replication server, EBS volumes, EBS
#' snapshots, etc.
#' @param tags A set of tags to be associated with the Replication Configuration
#' Template resource.
#' @param useDedicatedReplicationServer &#91;required&#93; Whether to use a dedicated Replication Server in the replication staging
#' area.
#'
#' @keywords internal
#'
#' @rdname drs_create_replication_configuration_template
drs_create_replication_configuration_template <- function(associateDefaultSecurityGroup, autoReplicateNewDisks = NULL, bandwidthThrottling, createPublicIP, dataPlaneRouting, defaultLargeStagingDiskType, ebsEncryption, ebsEncryptionKeyArn = NULL, pitPolicy, replicationServerInstanceType, replicationServersSecurityGroupsIDs, stagingAreaSubnetId, stagingAreaTags, tags = NULL, useDedicatedReplicationServer) {
  op <- new_operation(
    name = "CreateReplicationConfigurationTemplate",
    http_method = "POST",
    http_path = "/CreateReplicationConfigurationTemplate",
    paginator = list()
  )
  input <- .drs$create_replication_configuration_template_input(associateDefaultSecurityGroup = associateDefaultSecurityGroup, autoReplicateNewDisks = autoReplicateNewDisks, bandwidthThrottling = bandwidthThrottling, createPublicIP = createPublicIP, dataPlaneRouting = dataPlaneRouting, defaultLargeStagingDiskType = defaultLargeStagingDiskType, ebsEncryption = ebsEncryption, ebsEncryptionKeyArn = ebsEncryptionKeyArn, pitPolicy = pitPolicy, replicationServerInstanceType = replicationServerInstanceType, replicationServersSecurityGroupsIDs = replicationServersSecurityGroupsIDs, stagingAreaSubnetId = stagingAreaSubnetId, stagingAreaTags = stagingAreaTags, tags = tags, useDedicatedReplicationServer = useDedicatedReplicationServer)
  output <- .drs$create_replication_configuration_template_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$create_replication_configuration_template <- drs_create_replication_configuration_template

#' Create a new Source Network resource for a provided VPC ID
#'
#' @description
#' Create a new Source Network resource for a provided VPC ID.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_create_source_network/](https://www.paws-r-sdk.com/docs/drs_create_source_network/) for full documentation.
#'
#' @param originAccountID &#91;required&#93; Account containing the VPC to protect.
#' @param originRegion &#91;required&#93; Region containing the VPC to protect.
#' @param tags A set of tags to be associated with the Source Network resource.
#' @param vpcID &#91;required&#93; Which VPC ID to protect.
#'
#' @keywords internal
#'
#' @rdname drs_create_source_network
drs_create_source_network <- function(originAccountID, originRegion, tags = NULL, vpcID) {
  op <- new_operation(
    name = "CreateSourceNetwork",
    http_method = "POST",
    http_path = "/CreateSourceNetwork",
    paginator = list()
  )
  input <- .drs$create_source_network_input(originAccountID = originAccountID, originRegion = originRegion, tags = tags, vpcID = vpcID)
  output <- .drs$create_source_network_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$create_source_network <- drs_create_source_network

#' Deletes a single Job by ID
#'
#' @description
#' Deletes a single Job by ID.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_delete_job/](https://www.paws-r-sdk.com/docs/drs_delete_job/) for full documentation.
#'
#' @param jobID &#91;required&#93; The ID of the Job to be deleted.
#'
#' @keywords internal
#'
#' @rdname drs_delete_job
drs_delete_job <- function(jobID) {
  op <- new_operation(
    name = "DeleteJob",
    http_method = "POST",
    http_path = "/DeleteJob",
    paginator = list()
  )
  input <- .drs$delete_job_input(jobID = jobID)
  output <- .drs$delete_job_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$delete_job <- drs_delete_job

#' Deletes a resource launch action
#'
#' @description
#' Deletes a resource launch action.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_delete_launch_action/](https://www.paws-r-sdk.com/docs/drs_delete_launch_action/) for full documentation.
#'
#' @param actionId &#91;required&#93; 
#' @param resourceId &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname drs_delete_launch_action
drs_delete_launch_action <- function(actionId, resourceId) {
  op <- new_operation(
    name = "DeleteLaunchAction",
    http_method = "POST",
    http_path = "/DeleteLaunchAction",
    paginator = list()
  )
  input <- .drs$delete_launch_action_input(actionId = actionId, resourceId = resourceId)
  output <- .drs$delete_launch_action_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$delete_launch_action <- drs_delete_launch_action

#' Deletes a single Launch Configuration Template by ID
#'
#' @description
#' Deletes a single Launch Configuration Template by ID.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_delete_launch_configuration_template/](https://www.paws-r-sdk.com/docs/drs_delete_launch_configuration_template/) for full documentation.
#'
#' @param launchConfigurationTemplateID &#91;required&#93; The ID of the Launch Configuration Template to be deleted.
#'
#' @keywords internal
#'
#' @rdname drs_delete_launch_configuration_template
drs_delete_launch_configuration_template <- function(launchConfigurationTemplateID) {
  op <- new_operation(
    name = "DeleteLaunchConfigurationTemplate",
    http_method = "POST",
    http_path = "/DeleteLaunchConfigurationTemplate",
    paginator = list()
  )
  input <- .drs$delete_launch_configuration_template_input(launchConfigurationTemplateID = launchConfigurationTemplateID)
  output <- .drs$delete_launch_configuration_template_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$delete_launch_configuration_template <- drs_delete_launch_configuration_template

#' Deletes a single Recovery Instance by ID
#'
#' @description
#' Deletes a single Recovery Instance by ID. This deletes the Recovery Instance resource from Elastic Disaster Recovery. The Recovery Instance must be disconnected first in order to delete it.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_delete_recovery_instance/](https://www.paws-r-sdk.com/docs/drs_delete_recovery_instance/) for full documentation.
#'
#' @param recoveryInstanceID &#91;required&#93; The ID of the Recovery Instance to be deleted.
#'
#' @keywords internal
#'
#' @rdname drs_delete_recovery_instance
drs_delete_recovery_instance <- function(recoveryInstanceID) {
  op <- new_operation(
    name = "DeleteRecoveryInstance",
    http_method = "POST",
    http_path = "/DeleteRecoveryInstance",
    paginator = list()
  )
  input <- .drs$delete_recovery_instance_input(recoveryInstanceID = recoveryInstanceID)
  output <- .drs$delete_recovery_instance_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$delete_recovery_instance <- drs_delete_recovery_instance

#' Deletes a single Replication Configuration Template by ID
#'
#' @description
#' Deletes a single Replication Configuration Template by ID
#'
#' See [https://www.paws-r-sdk.com/docs/drs_delete_replication_configuration_template/](https://www.paws-r-sdk.com/docs/drs_delete_replication_configuration_template/) for full documentation.
#'
#' @param replicationConfigurationTemplateID &#91;required&#93; The ID of the Replication Configuration Template to be deleted.
#'
#' @keywords internal
#'
#' @rdname drs_delete_replication_configuration_template
drs_delete_replication_configuration_template <- function(replicationConfigurationTemplateID) {
  op <- new_operation(
    name = "DeleteReplicationConfigurationTemplate",
    http_method = "POST",
    http_path = "/DeleteReplicationConfigurationTemplate",
    paginator = list()
  )
  input <- .drs$delete_replication_configuration_template_input(replicationConfigurationTemplateID = replicationConfigurationTemplateID)
  output <- .drs$delete_replication_configuration_template_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$delete_replication_configuration_template <- drs_delete_replication_configuration_template

#' Delete Source Network resource
#'
#' @description
#' Delete Source Network resource.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_delete_source_network/](https://www.paws-r-sdk.com/docs/drs_delete_source_network/) for full documentation.
#'
#' @param sourceNetworkID &#91;required&#93; ID of the Source Network to delete.
#'
#' @keywords internal
#'
#' @rdname drs_delete_source_network
drs_delete_source_network <- function(sourceNetworkID) {
  op <- new_operation(
    name = "DeleteSourceNetwork",
    http_method = "POST",
    http_path = "/DeleteSourceNetwork",
    paginator = list()
  )
  input <- .drs$delete_source_network_input(sourceNetworkID = sourceNetworkID)
  output <- .drs$delete_source_network_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$delete_source_network <- drs_delete_source_network

#' Deletes a single Source Server by ID
#'
#' @description
#' Deletes a single Source Server by ID. The Source Server must be disconnected first.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_delete_source_server/](https://www.paws-r-sdk.com/docs/drs_delete_source_server/) for full documentation.
#'
#' @param sourceServerID &#91;required&#93; The ID of the Source Server to be deleted.
#'
#' @keywords internal
#'
#' @rdname drs_delete_source_server
drs_delete_source_server <- function(sourceServerID) {
  op <- new_operation(
    name = "DeleteSourceServer",
    http_method = "POST",
    http_path = "/DeleteSourceServer",
    paginator = list()
  )
  input <- .drs$delete_source_server_input(sourceServerID = sourceServerID)
  output <- .drs$delete_source_server_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$delete_source_server <- drs_delete_source_server

#' Retrieves a detailed Job log with pagination
#'
#' @description
#' Retrieves a detailed Job log with pagination.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_describe_job_log_items/](https://www.paws-r-sdk.com/docs/drs_describe_job_log_items/) for full documentation.
#'
#' @param jobID &#91;required&#93; The ID of the Job for which Job log items will be retrieved.
#' @param maxResults Maximum number of Job log items to retrieve.
#' @param nextToken The token of the next Job log items to retrieve.
#'
#' @keywords internal
#'
#' @rdname drs_describe_job_log_items
drs_describe_job_log_items <- function(jobID, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeJobLogItems",
    http_method = "POST",
    http_path = "/DescribeJobLogItems",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .drs$describe_job_log_items_input(jobID = jobID, maxResults = maxResults, nextToken = nextToken)
  output <- .drs$describe_job_log_items_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$describe_job_log_items <- drs_describe_job_log_items

#' Returns a list of Jobs
#'
#' @description
#' Returns a list of Jobs. Use the JobsID and fromDate and toDate filters to limit which jobs are returned. The response is sorted by creationDataTime - latest date first. Jobs are created by the StartRecovery, TerminateRecoveryInstances and StartFailbackLaunch APIs. Jobs are also created by DiagnosticLaunch and TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant support tickets.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_describe_jobs/](https://www.paws-r-sdk.com/docs/drs_describe_jobs/) for full documentation.
#'
#' @param filters A set of filters by which to return Jobs.
#' @param maxResults Maximum number of Jobs to retrieve.
#' @param nextToken The token of the next Job to retrieve.
#'
#' @keywords internal
#'
#' @rdname drs_describe_jobs
drs_describe_jobs <- function(filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeJobs",
    http_method = "POST",
    http_path = "/DescribeJobs",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .drs$describe_jobs_input(filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .drs$describe_jobs_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$describe_jobs <- drs_describe_jobs

#' Lists all Launch Configuration Templates, filtered by Launch
#' Configuration Template IDs
#'
#' @description
#' Lists all Launch Configuration Templates, filtered by Launch Configuration Template IDs
#'
#' See [https://www.paws-r-sdk.com/docs/drs_describe_launch_configuration_templates/](https://www.paws-r-sdk.com/docs/drs_describe_launch_configuration_templates/) for full documentation.
#'
#' @param launchConfigurationTemplateIDs Request to filter Launch Configuration Templates list by Launch
#' Configuration Template ID.
#' @param maxResults Maximum results to be returned in DescribeLaunchConfigurationTemplates.
#' @param nextToken The token of the next Launch Configuration Template to retrieve.
#'
#' @keywords internal
#'
#' @rdname drs_describe_launch_configuration_templates
drs_describe_launch_configuration_templates <- function(launchConfigurationTemplateIDs = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeLaunchConfigurationTemplates",
    http_method = "POST",
    http_path = "/DescribeLaunchConfigurationTemplates",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .drs$describe_launch_configuration_templates_input(launchConfigurationTemplateIDs = launchConfigurationTemplateIDs, maxResults = maxResults, nextToken = nextToken)
  output <- .drs$describe_launch_configuration_templates_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$describe_launch_configuration_templates <- drs_describe_launch_configuration_templates

#' Lists all Recovery Instances or multiple Recovery Instances by ID
#'
#' @description
#' Lists all Recovery Instances or multiple Recovery Instances by ID.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_describe_recovery_instances/](https://www.paws-r-sdk.com/docs/drs_describe_recovery_instances/) for full documentation.
#'
#' @param filters A set of filters by which to return Recovery Instances.
#' @param maxResults Maximum number of Recovery Instances to retrieve.
#' @param nextToken The token of the next Recovery Instance to retrieve.
#'
#' @keywords internal
#'
#' @rdname drs_describe_recovery_instances
drs_describe_recovery_instances <- function(filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeRecoveryInstances",
    http_method = "POST",
    http_path = "/DescribeRecoveryInstances",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .drs$describe_recovery_instances_input(filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .drs$describe_recovery_instances_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$describe_recovery_instances <- drs_describe_recovery_instances

#' Lists all Recovery Snapshots for a single Source Server
#'
#' @description
#' Lists all Recovery Snapshots for a single Source Server.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_describe_recovery_snapshots/](https://www.paws-r-sdk.com/docs/drs_describe_recovery_snapshots/) for full documentation.
#'
#' @param filters A set of filters by which to return Recovery Snapshots.
#' @param maxResults Maximum number of Recovery Snapshots to retrieve.
#' @param nextToken The token of the next Recovery Snapshot to retrieve.
#' @param order The sorted ordering by which to return Recovery Snapshots.
#' @param sourceServerID &#91;required&#93; Filter Recovery Snapshots by Source Server ID.
#'
#' @keywords internal
#'
#' @rdname drs_describe_recovery_snapshots
drs_describe_recovery_snapshots <- function(filters = NULL, maxResults = NULL, nextToken = NULL, order = NULL, sourceServerID) {
  op <- new_operation(
    name = "DescribeRecoverySnapshots",
    http_method = "POST",
    http_path = "/DescribeRecoverySnapshots",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .drs$describe_recovery_snapshots_input(filters = filters, maxResults = maxResults, nextToken = nextToken, order = order, sourceServerID = sourceServerID)
  output <- .drs$describe_recovery_snapshots_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$describe_recovery_snapshots <- drs_describe_recovery_snapshots

#' Lists all ReplicationConfigurationTemplates, filtered by Source Server
#' IDs
#'
#' @description
#' Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_describe_replication_configuration_templates/](https://www.paws-r-sdk.com/docs/drs_describe_replication_configuration_templates/) for full documentation.
#'
#' @param maxResults Maximum number of Replication Configuration Templates to retrieve.
#' @param nextToken The token of the next Replication Configuration Template to retrieve.
#' @param replicationConfigurationTemplateIDs The IDs of the Replication Configuration Templates to retrieve. An empty
#' list means all Replication Configuration Templates.
#'
#' @keywords internal
#'
#' @rdname drs_describe_replication_configuration_templates
drs_describe_replication_configuration_templates <- function(maxResults = NULL, nextToken = NULL, replicationConfigurationTemplateIDs = NULL) {
  op <- new_operation(
    name = "DescribeReplicationConfigurationTemplates",
    http_method = "POST",
    http_path = "/DescribeReplicationConfigurationTemplates",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .drs$describe_replication_configuration_templates_input(maxResults = maxResults, nextToken = nextToken, replicationConfigurationTemplateIDs = replicationConfigurationTemplateIDs)
  output <- .drs$describe_replication_configuration_templates_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$describe_replication_configuration_templates <- drs_describe_replication_configuration_templates

#' Lists all Source Networks or multiple Source Networks filtered by ID
#'
#' @description
#' Lists all Source Networks or multiple Source Networks filtered by ID.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_describe_source_networks/](https://www.paws-r-sdk.com/docs/drs_describe_source_networks/) for full documentation.
#'
#' @param filters A set of filters by which to return Source Networks.
#' @param maxResults Maximum number of Source Networks to retrieve.
#' @param nextToken The token of the next Source Networks to retrieve.
#'
#' @keywords internal
#'
#' @rdname drs_describe_source_networks
drs_describe_source_networks <- function(filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeSourceNetworks",
    http_method = "POST",
    http_path = "/DescribeSourceNetworks",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .drs$describe_source_networks_input(filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .drs$describe_source_networks_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$describe_source_networks <- drs_describe_source_networks

#' Lists all Source Servers or multiple Source Servers filtered by ID
#'
#' @description
#' Lists all Source Servers or multiple Source Servers filtered by ID.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_describe_source_servers/](https://www.paws-r-sdk.com/docs/drs_describe_source_servers/) for full documentation.
#'
#' @param filters A set of filters by which to return Source Servers.
#' @param maxResults Maximum number of Source Servers to retrieve.
#' @param nextToken The token of the next Source Server to retrieve.
#'
#' @keywords internal
#'
#' @rdname drs_describe_source_servers
drs_describe_source_servers <- function(filters = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "DescribeSourceServers",
    http_method = "POST",
    http_path = "/DescribeSourceServers",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .drs$describe_source_servers_input(filters = filters, maxResults = maxResults, nextToken = nextToken)
  output <- .drs$describe_source_servers_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$describe_source_servers <- drs_describe_source_servers

#' Disconnect a Recovery Instance from Elastic Disaster Recovery
#'
#' @description
#' Disconnect a Recovery Instance from Elastic Disaster Recovery. Data replication is stopped immediately. All AWS resources created by Elastic Disaster Recovery for enabling the replication of the Recovery Instance will be terminated / deleted within 90 minutes. If the agent on the Recovery Instance has not been prevented from communicating with the Elastic Disaster Recovery service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following properties of the Recovery Instance will be changed immediately: dataReplicationInfo.dataReplicationState will be set to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_disconnect_recovery_instance/](https://www.paws-r-sdk.com/docs/drs_disconnect_recovery_instance/) for full documentation.
#'
#' @param recoveryInstanceID &#91;required&#93; The ID of the Recovery Instance to disconnect.
#'
#' @keywords internal
#'
#' @rdname drs_disconnect_recovery_instance
drs_disconnect_recovery_instance <- function(recoveryInstanceID) {
  op <- new_operation(
    name = "DisconnectRecoveryInstance",
    http_method = "POST",
    http_path = "/DisconnectRecoveryInstance",
    paginator = list()
  )
  input <- .drs$disconnect_recovery_instance_input(recoveryInstanceID = recoveryInstanceID)
  output <- .drs$disconnect_recovery_instance_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$disconnect_recovery_instance <- drs_disconnect_recovery_instance

#' Disconnects a specific Source Server from Elastic Disaster Recovery
#'
#' @description
#' Disconnects a specific Source Server from Elastic Disaster Recovery. Data replication is stopped immediately. All AWS resources created by Elastic Disaster Recovery for enabling the replication of the Source Server will be terminated / deleted within 90 minutes. You cannot disconnect a Source Server if it has a Recovery Instance. If the agent on the Source Server has not been prevented from communicating with the Elastic Disaster Recovery service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be set to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_disconnect_source_server/](https://www.paws-r-sdk.com/docs/drs_disconnect_source_server/) for full documentation.
#'
#' @param sourceServerID &#91;required&#93; The ID of the Source Server to disconnect.
#'
#' @keywords internal
#'
#' @rdname drs_disconnect_source_server
drs_disconnect_source_server <- function(sourceServerID) {
  op <- new_operation(
    name = "DisconnectSourceServer",
    http_method = "POST",
    http_path = "/DisconnectSourceServer",
    paginator = list()
  )
  input <- .drs$disconnect_source_server_input(sourceServerID = sourceServerID)
  output <- .drs$disconnect_source_server_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$disconnect_source_server <- drs_disconnect_source_server

#' Export the Source Network CloudFormation template to an S3 bucket
#'
#' @description
#' Export the Source Network CloudFormation template to an S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_export_source_network_cfn_template/](https://www.paws-r-sdk.com/docs/drs_export_source_network_cfn_template/) for full documentation.
#'
#' @param sourceNetworkID &#91;required&#93; The Source Network ID to export its CloudFormation template to an S3
#' bucket.
#'
#' @keywords internal
#'
#' @rdname drs_export_source_network_cfn_template
drs_export_source_network_cfn_template <- function(sourceNetworkID) {
  op <- new_operation(
    name = "ExportSourceNetworkCfnTemplate",
    http_method = "POST",
    http_path = "/ExportSourceNetworkCfnTemplate",
    paginator = list()
  )
  input <- .drs$export_source_network_cfn_template_input(sourceNetworkID = sourceNetworkID)
  output <- .drs$export_source_network_cfn_template_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$export_source_network_cfn_template <- drs_export_source_network_cfn_template

#' Lists all Failback ReplicationConfigurations, filtered by Recovery
#' Instance ID
#'
#' @description
#' Lists all Failback ReplicationConfigurations, filtered by Recovery Instance ID.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_get_failback_replication_configuration/](https://www.paws-r-sdk.com/docs/drs_get_failback_replication_configuration/) for full documentation.
#'
#' @param recoveryInstanceID &#91;required&#93; The ID of the Recovery Instance whose failback replication configuration
#' should be returned.
#'
#' @keywords internal
#'
#' @rdname drs_get_failback_replication_configuration
drs_get_failback_replication_configuration <- function(recoveryInstanceID) {
  op <- new_operation(
    name = "GetFailbackReplicationConfiguration",
    http_method = "POST",
    http_path = "/GetFailbackReplicationConfiguration",
    paginator = list()
  )
  input <- .drs$get_failback_replication_configuration_input(recoveryInstanceID = recoveryInstanceID)
  output <- .drs$get_failback_replication_configuration_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$get_failback_replication_configuration <- drs_get_failback_replication_configuration

#' Gets a LaunchConfiguration, filtered by Source Server IDs
#'
#' @description
#' Gets a LaunchConfiguration, filtered by Source Server IDs.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_get_launch_configuration/](https://www.paws-r-sdk.com/docs/drs_get_launch_configuration/) for full documentation.
#'
#' @param sourceServerID &#91;required&#93; The ID of the Source Server that we want to retrieve a Launch
#' Configuration for.
#'
#' @keywords internal
#'
#' @rdname drs_get_launch_configuration
drs_get_launch_configuration <- function(sourceServerID) {
  op <- new_operation(
    name = "GetLaunchConfiguration",
    http_method = "POST",
    http_path = "/GetLaunchConfiguration",
    paginator = list()
  )
  input <- .drs$get_launch_configuration_input(sourceServerID = sourceServerID)
  output <- .drs$get_launch_configuration_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$get_launch_configuration <- drs_get_launch_configuration

#' Gets a ReplicationConfiguration, filtered by Source Server ID
#'
#' @description
#' Gets a ReplicationConfiguration, filtered by Source Server ID.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_get_replication_configuration/](https://www.paws-r-sdk.com/docs/drs_get_replication_configuration/) for full documentation.
#'
#' @param sourceServerID &#91;required&#93; The ID of the Source Serve for this Replication Configuration.r
#'
#' @keywords internal
#'
#' @rdname drs_get_replication_configuration
drs_get_replication_configuration <- function(sourceServerID) {
  op <- new_operation(
    name = "GetReplicationConfiguration",
    http_method = "POST",
    http_path = "/GetReplicationConfiguration",
    paginator = list()
  )
  input <- .drs$get_replication_configuration_input(sourceServerID = sourceServerID)
  output <- .drs$get_replication_configuration_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$get_replication_configuration <- drs_get_replication_configuration

#' Initialize Elastic Disaster Recovery
#'
#' @description
#' Initialize Elastic Disaster Recovery.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_initialize_service/](https://www.paws-r-sdk.com/docs/drs_initialize_service/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname drs_initialize_service
drs_initialize_service <- function() {
  op <- new_operation(
    name = "InitializeService",
    http_method = "POST",
    http_path = "/InitializeService",
    paginator = list()
  )
  input <- .drs$initialize_service_input()
  output <- .drs$initialize_service_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$initialize_service <- drs_initialize_service

#' Returns a list of source servers on a staging account that are
#' extensible, which means that: a
#'
#' @description
#' Returns a list of source servers on a staging account that are extensible, which means that: a. The source server is not already extended into this Account. b. The source server on the Account we’re reading from is not an extension of another source server.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_list_extensible_source_servers/](https://www.paws-r-sdk.com/docs/drs_list_extensible_source_servers/) for full documentation.
#'
#' @param maxResults The maximum number of extensible source servers to retrieve.
#' @param nextToken The token of the next extensible source server to retrieve.
#' @param stagingAccountID &#91;required&#93; The Id of the staging Account to retrieve extensible source servers
#' from.
#'
#' @keywords internal
#'
#' @rdname drs_list_extensible_source_servers
drs_list_extensible_source_servers <- function(maxResults = NULL, nextToken = NULL, stagingAccountID) {
  op <- new_operation(
    name = "ListExtensibleSourceServers",
    http_method = "POST",
    http_path = "/ListExtensibleSourceServers",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .drs$list_extensible_source_servers_input(maxResults = maxResults, nextToken = nextToken, stagingAccountID = stagingAccountID)
  output <- .drs$list_extensible_source_servers_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$list_extensible_source_servers <- drs_list_extensible_source_servers

#' Lists resource launch actions
#'
#' @description
#' Lists resource launch actions.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_list_launch_actions/](https://www.paws-r-sdk.com/docs/drs_list_launch_actions/) for full documentation.
#'
#' @param filters Filters to apply when listing resource launch actions.
#' @param maxResults Maximum amount of items to return when listing resource launch actions.
#' @param nextToken Next token to use when listing resource launch actions.
#' @param resourceId &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname drs_list_launch_actions
drs_list_launch_actions <- function(filters = NULL, maxResults = NULL, nextToken = NULL, resourceId) {
  op <- new_operation(
    name = "ListLaunchActions",
    http_method = "POST",
    http_path = "/ListLaunchActions",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "items")
  )
  input <- .drs$list_launch_actions_input(filters = filters, maxResults = maxResults, nextToken = nextToken, resourceId = resourceId)
  output <- .drs$list_launch_actions_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$list_launch_actions <- drs_list_launch_actions

#' Returns an array of staging accounts for existing extended source
#' servers
#'
#' @description
#' Returns an array of staging accounts for existing extended source servers.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_list_staging_accounts/](https://www.paws-r-sdk.com/docs/drs_list_staging_accounts/) for full documentation.
#'
#' @param maxResults The maximum number of staging Accounts to retrieve.
#' @param nextToken The token of the next staging Account to retrieve.
#'
#' @keywords internal
#'
#' @rdname drs_list_staging_accounts
drs_list_staging_accounts <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListStagingAccounts",
    http_method = "GET",
    http_path = "/ListStagingAccounts",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "accounts")
  )
  input <- .drs$list_staging_accounts_input(maxResults = maxResults, nextToken = nextToken)
  output <- .drs$list_staging_accounts_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$list_staging_accounts <- drs_list_staging_accounts

#' List all tags for your Elastic Disaster Recovery resources
#'
#' @description
#' List all tags for your Elastic Disaster Recovery resources.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/drs_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource whose tags should be returned.
#'
#' @keywords internal
#'
#' @rdname drs_list_tags_for_resource
drs_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .drs$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .drs$list_tags_for_resource_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$list_tags_for_resource <- drs_list_tags_for_resource

#' Puts a resource launch action
#'
#' @description
#' Puts a resource launch action.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_put_launch_action/](https://www.paws-r-sdk.com/docs/drs_put_launch_action/) for full documentation.
#'
#' @param actionCode &#91;required&#93; Launch action code.
#' @param actionId &#91;required&#93; 
#' @param actionVersion &#91;required&#93; 
#' @param active &#91;required&#93; Whether the launch action is active.
#' @param category &#91;required&#93; 
#' @param description &#91;required&#93; 
#' @param name &#91;required&#93; 
#' @param optional &#91;required&#93; Whether the launch will not be marked as failed if this action fails.
#' @param order &#91;required&#93; 
#' @param parameters 
#' @param resourceId &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname drs_put_launch_action
drs_put_launch_action <- function(actionCode, actionId, actionVersion, active, category, description, name, optional, order, parameters = NULL, resourceId) {
  op <- new_operation(
    name = "PutLaunchAction",
    http_method = "POST",
    http_path = "/PutLaunchAction",
    paginator = list()
  )
  input <- .drs$put_launch_action_input(actionCode = actionCode, actionId = actionId, actionVersion = actionVersion, active = active, category = category, description = description, name = name, optional = optional, order = order, parameters = parameters, resourceId = resourceId)
  output <- .drs$put_launch_action_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$put_launch_action <- drs_put_launch_action

#' WARNING: RetryDataReplication is deprecated
#'
#' @description
#' WARNING: RetryDataReplication is deprecated. Causes the data replication initiation sequence to begin immediately upon next Handshake for the specified Source Server ID, regardless of when the previous initiation started. This command will work only if the Source Server is stalled or is in a DISCONNECTED or STOPPED state.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_retry_data_replication/](https://www.paws-r-sdk.com/docs/drs_retry_data_replication/) for full documentation.
#'
#' @param sourceServerID &#91;required&#93; The ID of the Source Server whose data replication should be retried.
#'
#' @keywords internal
#'
#' @rdname drs_retry_data_replication
drs_retry_data_replication <- function(sourceServerID) {
  op <- new_operation(
    name = "RetryDataReplication",
    http_method = "POST",
    http_path = "/RetryDataReplication",
    paginator = list()
  )
  input <- .drs$retry_data_replication_input(sourceServerID = sourceServerID)
  output <- .drs$retry_data_replication_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$retry_data_replication <- drs_retry_data_replication

#' Start replication to origin / target region - applies only to protected
#' instances that originated in EC2
#'
#' @description
#' Start replication to origin / target region - applies only to protected instances that originated in EC2. For recovery instances on target region - starts replication back to origin region. For failback instances on origin region - starts replication to target region to re-protect them.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_reverse_replication/](https://www.paws-r-sdk.com/docs/drs_reverse_replication/) for full documentation.
#'
#' @param recoveryInstanceID &#91;required&#93; The ID of the Recovery Instance that we want to reverse the replication
#' for.
#'
#' @keywords internal
#'
#' @rdname drs_reverse_replication
drs_reverse_replication <- function(recoveryInstanceID) {
  op <- new_operation(
    name = "ReverseReplication",
    http_method = "POST",
    http_path = "/ReverseReplication",
    paginator = list()
  )
  input <- .drs$reverse_replication_input(recoveryInstanceID = recoveryInstanceID)
  output <- .drs$reverse_replication_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$reverse_replication <- drs_reverse_replication

#' Initiates a Job for launching the machine that is being failed back to
#' from the specified Recovery Instance
#'
#' @description
#' Initiates a Job for launching the machine that is being failed back to from the specified Recovery Instance. This will run conversion on the failback client and will reboot your machine, thus completing the failback process.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_start_failback_launch/](https://www.paws-r-sdk.com/docs/drs_start_failback_launch/) for full documentation.
#'
#' @param recoveryInstanceIDs &#91;required&#93; The IDs of the Recovery Instance whose failback launch we want to
#' request.
#' @param tags The tags to be associated with the failback launch Job.
#'
#' @keywords internal
#'
#' @rdname drs_start_failback_launch
drs_start_failback_launch <- function(recoveryInstanceIDs, tags = NULL) {
  op <- new_operation(
    name = "StartFailbackLaunch",
    http_method = "POST",
    http_path = "/StartFailbackLaunch",
    paginator = list()
  )
  input <- .drs$start_failback_launch_input(recoveryInstanceIDs = recoveryInstanceIDs, tags = tags)
  output <- .drs$start_failback_launch_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$start_failback_launch <- drs_start_failback_launch

#' Launches Recovery Instances for the specified Source Servers
#'
#' @description
#' Launches Recovery Instances for the specified Source Servers. For each Source Server you may choose a point in time snapshot to launch from, or use an on demand snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_start_recovery/](https://www.paws-r-sdk.com/docs/drs_start_recovery/) for full documentation.
#'
#' @param isDrill Whether this Source Server Recovery operation is a drill or not.
#' @param sourceServers &#91;required&#93; The Source Servers that we want to start a Recovery Job for.
#' @param tags The tags to be associated with the Recovery Job.
#'
#' @keywords internal
#'
#' @rdname drs_start_recovery
drs_start_recovery <- function(isDrill = NULL, sourceServers, tags = NULL) {
  op <- new_operation(
    name = "StartRecovery",
    http_method = "POST",
    http_path = "/StartRecovery",
    paginator = list()
  )
  input <- .drs$start_recovery_input(isDrill = isDrill, sourceServers = sourceServers, tags = tags)
  output <- .drs$start_recovery_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$start_recovery <- drs_start_recovery

#' Starts replication for a stopped Source Server
#'
#' @description
#' Starts replication for a stopped Source Server. This action would make the Source Server protected again and restart billing for it.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_start_replication/](https://www.paws-r-sdk.com/docs/drs_start_replication/) for full documentation.
#'
#' @param sourceServerID &#91;required&#93; The ID of the Source Server to start replication for.
#'
#' @keywords internal
#'
#' @rdname drs_start_replication
drs_start_replication <- function(sourceServerID) {
  op <- new_operation(
    name = "StartReplication",
    http_method = "POST",
    http_path = "/StartReplication",
    paginator = list()
  )
  input <- .drs$start_replication_input(sourceServerID = sourceServerID)
  output <- .drs$start_replication_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$start_replication <- drs_start_replication

#' Deploy VPC for the specified Source Network and modify launch templates
#' to use this network
#'
#' @description
#' Deploy VPC for the specified Source Network and modify launch templates to use this network. The VPC will be deployed using a dedicated CloudFormation stack.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_start_source_network_recovery/](https://www.paws-r-sdk.com/docs/drs_start_source_network_recovery/) for full documentation.
#'
#' @param deployAsNew Don't update existing CloudFormation Stack, recover the network using a
#' new stack.
#' @param sourceNetworks &#91;required&#93; The Source Networks that we want to start a Recovery Job for.
#' @param tags The tags to be associated with the Source Network recovery Job.
#'
#' @keywords internal
#'
#' @rdname drs_start_source_network_recovery
drs_start_source_network_recovery <- function(deployAsNew = NULL, sourceNetworks, tags = NULL) {
  op <- new_operation(
    name = "StartSourceNetworkRecovery",
    http_method = "POST",
    http_path = "/StartSourceNetworkRecovery",
    paginator = list()
  )
  input <- .drs$start_source_network_recovery_input(deployAsNew = deployAsNew, sourceNetworks = sourceNetworks, tags = tags)
  output <- .drs$start_source_network_recovery_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$start_source_network_recovery <- drs_start_source_network_recovery

#' Starts replication for a Source Network
#'
#' @description
#' Starts replication for a Source Network. This action would make the Source Network protected.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_start_source_network_replication/](https://www.paws-r-sdk.com/docs/drs_start_source_network_replication/) for full documentation.
#'
#' @param sourceNetworkID &#91;required&#93; ID of the Source Network to replicate.
#'
#' @keywords internal
#'
#' @rdname drs_start_source_network_replication
drs_start_source_network_replication <- function(sourceNetworkID) {
  op <- new_operation(
    name = "StartSourceNetworkReplication",
    http_method = "POST",
    http_path = "/StartSourceNetworkReplication",
    paginator = list()
  )
  input <- .drs$start_source_network_replication_input(sourceNetworkID = sourceNetworkID)
  output <- .drs$start_source_network_replication_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$start_source_network_replication <- drs_start_source_network_replication

#' Stops the failback process for a specified Recovery Instance
#'
#' @description
#' Stops the failback process for a specified Recovery Instance. This changes the Failback State of the Recovery Instance back to FAILBACK_NOT_STARTED.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_stop_failback/](https://www.paws-r-sdk.com/docs/drs_stop_failback/) for full documentation.
#'
#' @param recoveryInstanceID &#91;required&#93; The ID of the Recovery Instance we want to stop failback for.
#'
#' @keywords internal
#'
#' @rdname drs_stop_failback
drs_stop_failback <- function(recoveryInstanceID) {
  op <- new_operation(
    name = "StopFailback",
    http_method = "POST",
    http_path = "/StopFailback",
    paginator = list()
  )
  input <- .drs$stop_failback_input(recoveryInstanceID = recoveryInstanceID)
  output <- .drs$stop_failback_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$stop_failback <- drs_stop_failback

#' Stops replication for a Source Server
#'
#' @description
#' Stops replication for a Source Server. This action would make the Source Server unprotected, delete its existing snapshots and stop billing for it.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_stop_replication/](https://www.paws-r-sdk.com/docs/drs_stop_replication/) for full documentation.
#'
#' @param sourceServerID &#91;required&#93; The ID of the Source Server to stop replication for.
#'
#' @keywords internal
#'
#' @rdname drs_stop_replication
drs_stop_replication <- function(sourceServerID) {
  op <- new_operation(
    name = "StopReplication",
    http_method = "POST",
    http_path = "/StopReplication",
    paginator = list()
  )
  input <- .drs$stop_replication_input(sourceServerID = sourceServerID)
  output <- .drs$stop_replication_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$stop_replication <- drs_stop_replication

#' Stops replication for a Source Network
#'
#' @description
#' Stops replication for a Source Network. This action would make the Source Network unprotected.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_stop_source_network_replication/](https://www.paws-r-sdk.com/docs/drs_stop_source_network_replication/) for full documentation.
#'
#' @param sourceNetworkID &#91;required&#93; ID of the Source Network to stop replication.
#'
#' @keywords internal
#'
#' @rdname drs_stop_source_network_replication
drs_stop_source_network_replication <- function(sourceNetworkID) {
  op <- new_operation(
    name = "StopSourceNetworkReplication",
    http_method = "POST",
    http_path = "/StopSourceNetworkReplication",
    paginator = list()
  )
  input <- .drs$stop_source_network_replication_input(sourceNetworkID = sourceNetworkID)
  output <- .drs$stop_source_network_replication_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$stop_source_network_replication <- drs_stop_source_network_replication

#' Adds or overwrites only the specified tags for the specified Elastic
#' Disaster Recovery resource or resources
#'
#' @description
#' Adds or overwrites only the specified tags for the specified Elastic Disaster Recovery resource or resources. When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a maximum of 50 tags. Each tag consists of a key and optional value.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_tag_resource/](https://www.paws-r-sdk.com/docs/drs_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; ARN of the resource for which tags are to be added or updated.
#' @param tags &#91;required&#93; Array of tags to be added or updated.
#'
#' @keywords internal
#'
#' @rdname drs_tag_resource
drs_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .drs$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .drs$tag_resource_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$tag_resource <- drs_tag_resource

#' Initiates a Job for terminating the EC2 resources associated with the
#' specified Recovery Instances, and then will delete the Recovery
#' Instances from the Elastic Disaster Recovery service
#'
#' @description
#' Initiates a Job for terminating the EC2 resources associated with the specified Recovery Instances, and then will delete the Recovery Instances from the Elastic Disaster Recovery service.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_terminate_recovery_instances/](https://www.paws-r-sdk.com/docs/drs_terminate_recovery_instances/) for full documentation.
#'
#' @param recoveryInstanceIDs &#91;required&#93; The IDs of the Recovery Instances that should be terminated.
#'
#' @keywords internal
#'
#' @rdname drs_terminate_recovery_instances
drs_terminate_recovery_instances <- function(recoveryInstanceIDs) {
  op <- new_operation(
    name = "TerminateRecoveryInstances",
    http_method = "POST",
    http_path = "/TerminateRecoveryInstances",
    paginator = list()
  )
  input <- .drs$terminate_recovery_instances_input(recoveryInstanceIDs = recoveryInstanceIDs)
  output <- .drs$terminate_recovery_instances_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$terminate_recovery_instances <- drs_terminate_recovery_instances

#' Deletes the specified set of tags from the specified set of Elastic
#' Disaster Recovery resources
#'
#' @description
#' Deletes the specified set of tags from the specified set of Elastic Disaster Recovery resources.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_untag_resource/](https://www.paws-r-sdk.com/docs/drs_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; ARN of the resource for which tags are to be removed.
#' @param tagKeys &#91;required&#93; Array of tags to be removed.
#'
#' @keywords internal
#'
#' @rdname drs_untag_resource
drs_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .drs$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .drs$untag_resource_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$untag_resource <- drs_untag_resource

#' Allows you to update the failback replication configuration of a
#' Recovery Instance by ID
#'
#' @description
#' Allows you to update the failback replication configuration of a Recovery Instance by ID.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_update_failback_replication_configuration/](https://www.paws-r-sdk.com/docs/drs_update_failback_replication_configuration/) for full documentation.
#'
#' @param bandwidthThrottling Configure bandwidth throttling for the outbound data transfer rate of
#' the Recovery Instance in Mbps.
#' @param name The name of the Failback Replication Configuration.
#' @param recoveryInstanceID &#91;required&#93; The ID of the Recovery Instance.
#' @param usePrivateIP Whether to use Private IP for the failback replication of the Recovery
#' Instance.
#'
#' @keywords internal
#'
#' @rdname drs_update_failback_replication_configuration
drs_update_failback_replication_configuration <- function(bandwidthThrottling = NULL, name = NULL, recoveryInstanceID, usePrivateIP = NULL) {
  op <- new_operation(
    name = "UpdateFailbackReplicationConfiguration",
    http_method = "POST",
    http_path = "/UpdateFailbackReplicationConfiguration",
    paginator = list()
  )
  input <- .drs$update_failback_replication_configuration_input(bandwidthThrottling = bandwidthThrottling, name = name, recoveryInstanceID = recoveryInstanceID, usePrivateIP = usePrivateIP)
  output <- .drs$update_failback_replication_configuration_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$update_failback_replication_configuration <- drs_update_failback_replication_configuration

#' Updates a LaunchConfiguration by Source Server ID
#'
#' @description
#' Updates a LaunchConfiguration by Source Server ID.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_update_launch_configuration/](https://www.paws-r-sdk.com/docs/drs_update_launch_configuration/) for full documentation.
#'
#' @param copyPrivateIp Whether we should copy the Private IP of the Source Server to the
#' Recovery Instance.
#' @param copyTags Whether we want to copy the tags of the Source Server to the EC2 machine
#' of the Recovery Instance.
#' @param launchDisposition The state of the Recovery Instance in EC2 after the recovery operation.
#' @param launchIntoInstanceProperties Launch into existing instance properties.
#' @param licensing The licensing configuration to be used for this launch configuration.
#' @param name The name of the launch configuration.
#' @param postLaunchEnabled Whether we want to enable post-launch actions for the Source Server.
#' @param sourceServerID &#91;required&#93; The ID of the Source Server that we want to retrieve a Launch
#' Configuration for.
#' @param targetInstanceTypeRightSizingMethod Whether Elastic Disaster Recovery should try to automatically choose the
#' instance type that best matches the OS, CPU, and RAM of your Source
#' Server.
#'
#' @keywords internal
#'
#' @rdname drs_update_launch_configuration
drs_update_launch_configuration <- function(copyPrivateIp = NULL, copyTags = NULL, launchDisposition = NULL, launchIntoInstanceProperties = NULL, licensing = NULL, name = NULL, postLaunchEnabled = NULL, sourceServerID, targetInstanceTypeRightSizingMethod = NULL) {
  op <- new_operation(
    name = "UpdateLaunchConfiguration",
    http_method = "POST",
    http_path = "/UpdateLaunchConfiguration",
    paginator = list()
  )
  input <- .drs$update_launch_configuration_input(copyPrivateIp = copyPrivateIp, copyTags = copyTags, launchDisposition = launchDisposition, launchIntoInstanceProperties = launchIntoInstanceProperties, licensing = licensing, name = name, postLaunchEnabled = postLaunchEnabled, sourceServerID = sourceServerID, targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod)
  output <- .drs$update_launch_configuration_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$update_launch_configuration <- drs_update_launch_configuration

#' Updates an existing Launch Configuration Template by ID
#'
#' @description
#' Updates an existing Launch Configuration Template by ID.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_update_launch_configuration_template/](https://www.paws-r-sdk.com/docs/drs_update_launch_configuration_template/) for full documentation.
#'
#' @param copyPrivateIp Copy private IP.
#' @param copyTags Copy tags.
#' @param exportBucketArn S3 bucket ARN to export Source Network templates.
#' @param launchConfigurationTemplateID &#91;required&#93; Launch Configuration Template ID.
#' @param launchDisposition Launch disposition.
#' @param launchIntoSourceInstance DRS will set the 'launch into instance ID' of any source server when
#' performing a drill, recovery or failback to the previous region or
#' availability zone, using the instance ID of the source instance.
#' @param licensing Licensing.
#' @param postLaunchEnabled Whether we want to activate post-launch actions.
#' @param targetInstanceTypeRightSizingMethod Target instance type right-sizing method.
#'
#' @keywords internal
#'
#' @rdname drs_update_launch_configuration_template
drs_update_launch_configuration_template <- function(copyPrivateIp = NULL, copyTags = NULL, exportBucketArn = NULL, launchConfigurationTemplateID, launchDisposition = NULL, launchIntoSourceInstance = NULL, licensing = NULL, postLaunchEnabled = NULL, targetInstanceTypeRightSizingMethod = NULL) {
  op <- new_operation(
    name = "UpdateLaunchConfigurationTemplate",
    http_method = "POST",
    http_path = "/UpdateLaunchConfigurationTemplate",
    paginator = list()
  )
  input <- .drs$update_launch_configuration_template_input(copyPrivateIp = copyPrivateIp, copyTags = copyTags, exportBucketArn = exportBucketArn, launchConfigurationTemplateID = launchConfigurationTemplateID, launchDisposition = launchDisposition, launchIntoSourceInstance = launchIntoSourceInstance, licensing = licensing, postLaunchEnabled = postLaunchEnabled, targetInstanceTypeRightSizingMethod = targetInstanceTypeRightSizingMethod)
  output <- .drs$update_launch_configuration_template_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$update_launch_configuration_template <- drs_update_launch_configuration_template

#' Allows you to update a ReplicationConfiguration by Source Server ID
#'
#' @description
#' Allows you to update a ReplicationConfiguration by Source Server ID.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_update_replication_configuration/](https://www.paws-r-sdk.com/docs/drs_update_replication_configuration/) for full documentation.
#'
#' @param associateDefaultSecurityGroup Whether to associate the default Elastic Disaster Recovery Security
#' group with the Replication Configuration.
#' @param autoReplicateNewDisks Whether to allow the AWS replication agent to automatically replicate
#' newly added disks.
#' @param bandwidthThrottling Configure bandwidth throttling for the outbound data transfer rate of
#' the Source Server in Mbps.
#' @param createPublicIP Whether to create a Public IP for the Recovery Instance by default.
#' @param dataPlaneRouting The data plane routing mechanism that will be used for replication.
#' @param defaultLargeStagingDiskType The Staging Disk EBS volume type to be used during replication.
#' @param ebsEncryption The type of EBS encryption to be used during replication.
#' @param ebsEncryptionKeyArn The ARN of the EBS encryption key to be used during replication.
#' @param name The name of the Replication Configuration.
#' @param pitPolicy The Point in time (PIT) policy to manage snapshots taken during
#' replication.
#' @param replicatedDisks The configuration of the disks of the Source Server to be replicated.
#' @param replicationServerInstanceType The instance type to be used for the replication server.
#' @param replicationServersSecurityGroupsIDs The security group IDs that will be used by the replication server.
#' @param sourceServerID &#91;required&#93; The ID of the Source Server for this Replication Configuration.
#' @param stagingAreaSubnetId The subnet to be used by the replication staging area.
#' @param stagingAreaTags A set of tags to be associated with all resources created in the
#' replication staging area: EC2 replication server, EBS volumes, EBS
#' snapshots, etc.
#' @param useDedicatedReplicationServer Whether to use a dedicated Replication Server in the replication staging
#' area.
#'
#' @keywords internal
#'
#' @rdname drs_update_replication_configuration
drs_update_replication_configuration <- function(associateDefaultSecurityGroup = NULL, autoReplicateNewDisks = NULL, bandwidthThrottling = NULL, createPublicIP = NULL, dataPlaneRouting = NULL, defaultLargeStagingDiskType = NULL, ebsEncryption = NULL, ebsEncryptionKeyArn = NULL, name = NULL, pitPolicy = NULL, replicatedDisks = NULL, replicationServerInstanceType = NULL, replicationServersSecurityGroupsIDs = NULL, sourceServerID, stagingAreaSubnetId = NULL, stagingAreaTags = NULL, useDedicatedReplicationServer = NULL) {
  op <- new_operation(
    name = "UpdateReplicationConfiguration",
    http_method = "POST",
    http_path = "/UpdateReplicationConfiguration",
    paginator = list()
  )
  input <- .drs$update_replication_configuration_input(associateDefaultSecurityGroup = associateDefaultSecurityGroup, autoReplicateNewDisks = autoReplicateNewDisks, bandwidthThrottling = bandwidthThrottling, createPublicIP = createPublicIP, dataPlaneRouting = dataPlaneRouting, defaultLargeStagingDiskType = defaultLargeStagingDiskType, ebsEncryption = ebsEncryption, ebsEncryptionKeyArn = ebsEncryptionKeyArn, name = name, pitPolicy = pitPolicy, replicatedDisks = replicatedDisks, replicationServerInstanceType = replicationServerInstanceType, replicationServersSecurityGroupsIDs = replicationServersSecurityGroupsIDs, sourceServerID = sourceServerID, stagingAreaSubnetId = stagingAreaSubnetId, stagingAreaTags = stagingAreaTags, useDedicatedReplicationServer = useDedicatedReplicationServer)
  output <- .drs$update_replication_configuration_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$update_replication_configuration <- drs_update_replication_configuration

#' Updates a ReplicationConfigurationTemplate by ID
#'
#' @description
#' Updates a ReplicationConfigurationTemplate by ID.
#'
#' See [https://www.paws-r-sdk.com/docs/drs_update_replication_configuration_template/](https://www.paws-r-sdk.com/docs/drs_update_replication_configuration_template/) for full documentation.
#'
#' @param arn The Replication Configuration Template ARN.
#' @param associateDefaultSecurityGroup Whether to associate the default Elastic Disaster Recovery Security
#' group with the Replication Configuration Template.
#' @param autoReplicateNewDisks Whether to allow the AWS replication agent to automatically replicate
#' newly added disks.
#' @param bandwidthThrottling Configure bandwidth throttling for the outbound data transfer rate of
#' the Source Server in Mbps.
#' @param createPublicIP Whether to create a Public IP for the Recovery Instance by default.
#' @param dataPlaneRouting The data plane routing mechanism that will be used for replication.
#' @param defaultLargeStagingDiskType The Staging Disk EBS volume type to be used during replication.
#' @param ebsEncryption The type of EBS encryption to be used during replication.
#' @param ebsEncryptionKeyArn The ARN of the EBS encryption key to be used during replication.
#' @param pitPolicy The Point in time (PIT) policy to manage snapshots taken during
#' replication.
#' @param replicationConfigurationTemplateID &#91;required&#93; The Replication Configuration Template ID.
#' @param replicationServerInstanceType The instance type to be used for the replication server.
#' @param replicationServersSecurityGroupsIDs The security group IDs that will be used by the replication server.
#' @param stagingAreaSubnetId The subnet to be used by the replication staging area.
#' @param stagingAreaTags A set of tags to be associated with all resources created in the
#' replication staging area: EC2 replication server, EBS volumes, EBS
#' snapshots, etc.
#' @param useDedicatedReplicationServer Whether to use a dedicated Replication Server in the replication staging
#' area.
#'
#' @keywords internal
#'
#' @rdname drs_update_replication_configuration_template
drs_update_replication_configuration_template <- function(arn = NULL, associateDefaultSecurityGroup = NULL, autoReplicateNewDisks = NULL, bandwidthThrottling = NULL, createPublicIP = NULL, dataPlaneRouting = NULL, defaultLargeStagingDiskType = NULL, ebsEncryption = NULL, ebsEncryptionKeyArn = NULL, pitPolicy = NULL, replicationConfigurationTemplateID, replicationServerInstanceType = NULL, replicationServersSecurityGroupsIDs = NULL, stagingAreaSubnetId = NULL, stagingAreaTags = NULL, useDedicatedReplicationServer = NULL) {
  op <- new_operation(
    name = "UpdateReplicationConfigurationTemplate",
    http_method = "POST",
    http_path = "/UpdateReplicationConfigurationTemplate",
    paginator = list()
  )
  input <- .drs$update_replication_configuration_template_input(arn = arn, associateDefaultSecurityGroup = associateDefaultSecurityGroup, autoReplicateNewDisks = autoReplicateNewDisks, bandwidthThrottling = bandwidthThrottling, createPublicIP = createPublicIP, dataPlaneRouting = dataPlaneRouting, defaultLargeStagingDiskType = defaultLargeStagingDiskType, ebsEncryption = ebsEncryption, ebsEncryptionKeyArn = ebsEncryptionKeyArn, pitPolicy = pitPolicy, replicationConfigurationTemplateID = replicationConfigurationTemplateID, replicationServerInstanceType = replicationServerInstanceType, replicationServersSecurityGroupsIDs = replicationServersSecurityGroupsIDs, stagingAreaSubnetId = stagingAreaSubnetId, stagingAreaTags = stagingAreaTags, useDedicatedReplicationServer = useDedicatedReplicationServer)
  output <- .drs$update_replication_configuration_template_output()
  config <- get_config()
  svc <- .drs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.drs$operations$update_replication_configuration_template <- drs_update_replication_configuration_template
