# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include emrserverless_service.R
NULL

#' Cancels a job run
#'
#' @description
#' Cancels a job run.
#'
#' See [https://www.paws-r-sdk.com/docs/emrserverless_cancel_job_run/](https://www.paws-r-sdk.com/docs/emrserverless_cancel_job_run/) for full documentation.
#'
#' @param applicationId &#91;required&#93; The ID of the application on which the job run will be canceled.
#' @param jobRunId &#91;required&#93; The ID of the job run to cancel.
#'
#' @keywords internal
#'
#' @rdname emrserverless_cancel_job_run
emrserverless_cancel_job_run <- function(applicationId, jobRunId) {
  op <- new_operation(
    name = "CancelJobRun",
    http_method = "DELETE",
    http_path = "/applications/{applicationId}/jobruns/{jobRunId}",
    paginator = list()
  )
  input <- .emrserverless$cancel_job_run_input(applicationId = applicationId, jobRunId = jobRunId)
  output <- .emrserverless$cancel_job_run_output()
  config <- get_config()
  svc <- .emrserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrserverless$operations$cancel_job_run <- emrserverless_cancel_job_run

#' Creates an application
#'
#' @description
#' Creates an application.
#'
#' See [https://www.paws-r-sdk.com/docs/emrserverless_create_application/](https://www.paws-r-sdk.com/docs/emrserverless_create_application/) for full documentation.
#'
#' @param name The name of the application.
#' @param releaseLabel &#91;required&#93; The Amazon EMR release associated with the application.
#' @param type &#91;required&#93; The type of application you want to start, such as Spark or Hive.
#' @param clientToken &#91;required&#93; The client idempotency token of the application to create. Its value
#' must be unique for each request.
#' @param initialCapacity The capacity to initialize when the application is created.
#' @param maximumCapacity The maximum capacity to allocate when the application is created. This
#' is cumulative across all workers at any given point in time, not just
#' when an application is created. No new resources will be created once
#' any one of the defined limits is hit.
#' @param tags The tags assigned to the application.
#' @param autoStartConfiguration The configuration for an application to automatically start on job
#' submission.
#' @param autoStopConfiguration The configuration for an application to automatically stop after a
#' certain amount of time being idle.
#' @param networkConfiguration The network configuration for customer VPC connectivity.
#' @param architecture The CPU architecture of an application.
#' @param imageConfiguration The image configuration for all worker types. You can either set this
#' parameter or `imageConfiguration` for each worker type in
#' `workerTypeSpecifications`.
#' @param workerTypeSpecifications The key-value pairs that specify worker type to
#' `WorkerTypeSpecificationInput`. This parameter must contain all valid
#' worker types for a Spark or Hive application. Valid worker types include
#' `Driver` and `Executor` for Spark applications and `HiveDriver` and
#' `TezTask` for Hive applications. You can either set image details in
#' this parameter for each worker type, or in `imageConfiguration` for all
#' worker types.
#' @param runtimeConfiguration The
#' [Configuration](https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html)
#' specifications to use when creating an application. Each configuration
#' consists of a classification and properties. This configuration is
#' applied to all the job runs submitted under the application.
#' @param monitoringConfiguration The configuration setting for monitoring.
#'
#' @keywords internal
#'
#' @rdname emrserverless_create_application
emrserverless_create_application <- function(name = NULL, releaseLabel, type, clientToken, initialCapacity = NULL, maximumCapacity = NULL, tags = NULL, autoStartConfiguration = NULL, autoStopConfiguration = NULL, networkConfiguration = NULL, architecture = NULL, imageConfiguration = NULL, workerTypeSpecifications = NULL, runtimeConfiguration = NULL, monitoringConfiguration = NULL) {
  op <- new_operation(
    name = "CreateApplication",
    http_method = "POST",
    http_path = "/applications",
    paginator = list()
  )
  input <- .emrserverless$create_application_input(name = name, releaseLabel = releaseLabel, type = type, clientToken = clientToken, initialCapacity = initialCapacity, maximumCapacity = maximumCapacity, tags = tags, autoStartConfiguration = autoStartConfiguration, autoStopConfiguration = autoStopConfiguration, networkConfiguration = networkConfiguration, architecture = architecture, imageConfiguration = imageConfiguration, workerTypeSpecifications = workerTypeSpecifications, runtimeConfiguration = runtimeConfiguration, monitoringConfiguration = monitoringConfiguration)
  output <- .emrserverless$create_application_output()
  config <- get_config()
  svc <- .emrserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrserverless$operations$create_application <- emrserverless_create_application

#' Deletes an application
#'
#' @description
#' Deletes an application. An application has to be in a stopped or created state in order to be deleted.
#'
#' See [https://www.paws-r-sdk.com/docs/emrserverless_delete_application/](https://www.paws-r-sdk.com/docs/emrserverless_delete_application/) for full documentation.
#'
#' @param applicationId &#91;required&#93; The ID of the application that will be deleted.
#'
#' @keywords internal
#'
#' @rdname emrserverless_delete_application
emrserverless_delete_application <- function(applicationId) {
  op <- new_operation(
    name = "DeleteApplication",
    http_method = "DELETE",
    http_path = "/applications/{applicationId}",
    paginator = list()
  )
  input <- .emrserverless$delete_application_input(applicationId = applicationId)
  output <- .emrserverless$delete_application_output()
  config <- get_config()
  svc <- .emrserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrserverless$operations$delete_application <- emrserverless_delete_application

#' Displays detailed information about a specified application
#'
#' @description
#' Displays detailed information about a specified application.
#'
#' See [https://www.paws-r-sdk.com/docs/emrserverless_get_application/](https://www.paws-r-sdk.com/docs/emrserverless_get_application/) for full documentation.
#'
#' @param applicationId &#91;required&#93; The ID of the application that will be described.
#'
#' @keywords internal
#'
#' @rdname emrserverless_get_application
emrserverless_get_application <- function(applicationId) {
  op <- new_operation(
    name = "GetApplication",
    http_method = "GET",
    http_path = "/applications/{applicationId}",
    paginator = list()
  )
  input <- .emrserverless$get_application_input(applicationId = applicationId)
  output <- .emrserverless$get_application_output()
  config <- get_config()
  svc <- .emrserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrserverless$operations$get_application <- emrserverless_get_application

#' Creates and returns a URL that you can use to access the application UIs
#' for a job run
#'
#' @description
#' Creates and returns a URL that you can use to access the application UIs for a job run.
#'
#' See [https://www.paws-r-sdk.com/docs/emrserverless_get_dashboard_for_job_run/](https://www.paws-r-sdk.com/docs/emrserverless_get_dashboard_for_job_run/) for full documentation.
#'
#' @param applicationId &#91;required&#93; The ID of the application.
#' @param jobRunId &#91;required&#93; The ID of the job run.
#'
#' @keywords internal
#'
#' @rdname emrserverless_get_dashboard_for_job_run
emrserverless_get_dashboard_for_job_run <- function(applicationId, jobRunId) {
  op <- new_operation(
    name = "GetDashboardForJobRun",
    http_method = "GET",
    http_path = "/applications/{applicationId}/jobruns/{jobRunId}/dashboard",
    paginator = list()
  )
  input <- .emrserverless$get_dashboard_for_job_run_input(applicationId = applicationId, jobRunId = jobRunId)
  output <- .emrserverless$get_dashboard_for_job_run_output()
  config <- get_config()
  svc <- .emrserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrserverless$operations$get_dashboard_for_job_run <- emrserverless_get_dashboard_for_job_run

#' Displays detailed information about a job run
#'
#' @description
#' Displays detailed information about a job run.
#'
#' See [https://www.paws-r-sdk.com/docs/emrserverless_get_job_run/](https://www.paws-r-sdk.com/docs/emrserverless_get_job_run/) for full documentation.
#'
#' @param applicationId &#91;required&#93; The ID of the application on which the job run is submitted.
#' @param jobRunId &#91;required&#93; The ID of the job run.
#'
#' @keywords internal
#'
#' @rdname emrserverless_get_job_run
emrserverless_get_job_run <- function(applicationId, jobRunId) {
  op <- new_operation(
    name = "GetJobRun",
    http_method = "GET",
    http_path = "/applications/{applicationId}/jobruns/{jobRunId}",
    paginator = list()
  )
  input <- .emrserverless$get_job_run_input(applicationId = applicationId, jobRunId = jobRunId)
  output <- .emrserverless$get_job_run_output()
  config <- get_config()
  svc <- .emrserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrserverless$operations$get_job_run <- emrserverless_get_job_run

#' Lists applications based on a set of parameters
#'
#' @description
#' Lists applications based on a set of parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/emrserverless_list_applications/](https://www.paws-r-sdk.com/docs/emrserverless_list_applications/) for full documentation.
#'
#' @param nextToken The token for the next set of application results.
#' @param maxResults The maximum number of applications that can be listed.
#' @param states An optional filter for application states. Note that if this filter
#' contains multiple states, the resulting list will be grouped by the
#' state.
#'
#' @keywords internal
#'
#' @rdname emrserverless_list_applications
emrserverless_list_applications <- function(nextToken = NULL, maxResults = NULL, states = NULL) {
  op <- new_operation(
    name = "ListApplications",
    http_method = "GET",
    http_path = "/applications",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "applications")
  )
  input <- .emrserverless$list_applications_input(nextToken = nextToken, maxResults = maxResults, states = states)
  output <- .emrserverless$list_applications_output()
  config <- get_config()
  svc <- .emrserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrserverless$operations$list_applications <- emrserverless_list_applications

#' Lists job runs based on a set of parameters
#'
#' @description
#' Lists job runs based on a set of parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/emrserverless_list_job_runs/](https://www.paws-r-sdk.com/docs/emrserverless_list_job_runs/) for full documentation.
#'
#' @param applicationId &#91;required&#93; The ID of the application for which to list the job run.
#' @param nextToken The token for the next set of job run results.
#' @param maxResults The maximum number of job runs that can be listed.
#' @param createdAtAfter The lower bound of the option to filter by creation date and time.
#' @param createdAtBefore The upper bound of the option to filter by creation date and time.
#' @param states An optional filter for job run states. Note that if this filter contains
#' multiple states, the resulting list will be grouped by the state.
#'
#' @keywords internal
#'
#' @rdname emrserverless_list_job_runs
emrserverless_list_job_runs <- function(applicationId, nextToken = NULL, maxResults = NULL, createdAtAfter = NULL, createdAtBefore = NULL, states = NULL) {
  op <- new_operation(
    name = "ListJobRuns",
    http_method = "GET",
    http_path = "/applications/{applicationId}/jobruns",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "jobRuns")
  )
  input <- .emrserverless$list_job_runs_input(applicationId = applicationId, nextToken = nextToken, maxResults = maxResults, createdAtAfter = createdAtAfter, createdAtBefore = createdAtBefore, states = states)
  output <- .emrserverless$list_job_runs_output()
  config <- get_config()
  svc <- .emrserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrserverless$operations$list_job_runs <- emrserverless_list_job_runs

#' Lists the tags assigned to the resources
#'
#' @description
#' Lists the tags assigned to the resources.
#'
#' See [https://www.paws-r-sdk.com/docs/emrserverless_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/emrserverless_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource to list the
#' tags for. Currently, the supported resources are Amazon EMR Serverless
#' applications and job runs.
#'
#' @keywords internal
#'
#' @rdname emrserverless_list_tags_for_resource
emrserverless_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .emrserverless$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .emrserverless$list_tags_for_resource_output()
  config <- get_config()
  svc <- .emrserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrserverless$operations$list_tags_for_resource <- emrserverless_list_tags_for_resource

#' Starts a specified application and initializes initial capacity if
#' configured
#'
#' @description
#' Starts a specified application and initializes initial capacity if configured.
#'
#' See [https://www.paws-r-sdk.com/docs/emrserverless_start_application/](https://www.paws-r-sdk.com/docs/emrserverless_start_application/) for full documentation.
#'
#' @param applicationId &#91;required&#93; The ID of the application to start.
#'
#' @keywords internal
#'
#' @rdname emrserverless_start_application
emrserverless_start_application <- function(applicationId) {
  op <- new_operation(
    name = "StartApplication",
    http_method = "POST",
    http_path = "/applications/{applicationId}/start",
    paginator = list()
  )
  input <- .emrserverless$start_application_input(applicationId = applicationId)
  output <- .emrserverless$start_application_output()
  config <- get_config()
  svc <- .emrserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrserverless$operations$start_application <- emrserverless_start_application

#' Starts a job run
#'
#' @description
#' Starts a job run.
#'
#' See [https://www.paws-r-sdk.com/docs/emrserverless_start_job_run/](https://www.paws-r-sdk.com/docs/emrserverless_start_job_run/) for full documentation.
#'
#' @param applicationId &#91;required&#93; The ID of the application on which to run the job.
#' @param clientToken &#91;required&#93; The client idempotency token of the job run to start. Its value must be
#' unique for each request.
#' @param executionRoleArn &#91;required&#93; The execution role ARN for the job run.
#' @param jobDriver The job driver for the job run.
#' @param configurationOverrides The configuration overrides for the job run.
#' @param tags The tags assigned to the job run.
#' @param executionTimeoutMinutes The maximum duration for the job run to run. If the job run runs beyond
#' this duration, it will be automatically cancelled.
#' @param name The optional job run name. This doesn't have to be unique.
#'
#' @keywords internal
#'
#' @rdname emrserverless_start_job_run
emrserverless_start_job_run <- function(applicationId, clientToken, executionRoleArn, jobDriver = NULL, configurationOverrides = NULL, tags = NULL, executionTimeoutMinutes = NULL, name = NULL) {
  op <- new_operation(
    name = "StartJobRun",
    http_method = "POST",
    http_path = "/applications/{applicationId}/jobruns",
    paginator = list()
  )
  input <- .emrserverless$start_job_run_input(applicationId = applicationId, clientToken = clientToken, executionRoleArn = executionRoleArn, jobDriver = jobDriver, configurationOverrides = configurationOverrides, tags = tags, executionTimeoutMinutes = executionTimeoutMinutes, name = name)
  output <- .emrserverless$start_job_run_output()
  config <- get_config()
  svc <- .emrserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrserverless$operations$start_job_run <- emrserverless_start_job_run

#' Stops a specified application and releases initial capacity if
#' configured
#'
#' @description
#' Stops a specified application and releases initial capacity if configured. All scheduled and running jobs must be completed or cancelled before stopping an application.
#'
#' See [https://www.paws-r-sdk.com/docs/emrserverless_stop_application/](https://www.paws-r-sdk.com/docs/emrserverless_stop_application/) for full documentation.
#'
#' @param applicationId &#91;required&#93; The ID of the application to stop.
#'
#' @keywords internal
#'
#' @rdname emrserverless_stop_application
emrserverless_stop_application <- function(applicationId) {
  op <- new_operation(
    name = "StopApplication",
    http_method = "POST",
    http_path = "/applications/{applicationId}/stop",
    paginator = list()
  )
  input <- .emrserverless$stop_application_input(applicationId = applicationId)
  output <- .emrserverless$stop_application_output()
  config <- get_config()
  svc <- .emrserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrserverless$operations$stop_application <- emrserverless_stop_application

#' Assigns tags to resources
#'
#' @description
#' Assigns tags to resources. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key and an optional value, both of which you define. Tags enable you to categorize your Amazon Web Services resources by attributes such as purpose, owner, or environment. When you have many resources of the same type, you can quickly identify a specific resource based on the tags you've assigned to it.
#'
#' See [https://www.paws-r-sdk.com/docs/emrserverless_tag_resource/](https://www.paws-r-sdk.com/docs/emrserverless_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource to list the
#' tags for. Currently, the supported resources are Amazon EMR Serverless
#' applications and job runs.
#' @param tags &#91;required&#93; The tags to add to the resource. A tag is an array of key-value pairs.
#'
#' @keywords internal
#'
#' @rdname emrserverless_tag_resource
emrserverless_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .emrserverless$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .emrserverless$tag_resource_output()
  config <- get_config()
  svc <- .emrserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrserverless$operations$tag_resource <- emrserverless_tag_resource

#' Removes tags from resources
#'
#' @description
#' Removes tags from resources.
#'
#' See [https://www.paws-r-sdk.com/docs/emrserverless_untag_resource/](https://www.paws-r-sdk.com/docs/emrserverless_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource to list the
#' tags for. Currently, the supported resources are Amazon EMR Serverless
#' applications and job runs.
#' @param tagKeys &#91;required&#93; The keys of the tags to be removed.
#'
#' @keywords internal
#'
#' @rdname emrserverless_untag_resource
emrserverless_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .emrserverless$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .emrserverless$untag_resource_output()
  config <- get_config()
  svc <- .emrserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrserverless$operations$untag_resource <- emrserverless_untag_resource

#' Updates a specified application
#'
#' @description
#' Updates a specified application. An application has to be in a stopped or created state in order to be updated.
#'
#' See [https://www.paws-r-sdk.com/docs/emrserverless_update_application/](https://www.paws-r-sdk.com/docs/emrserverless_update_application/) for full documentation.
#'
#' @param applicationId &#91;required&#93; The ID of the application to update.
#' @param clientToken &#91;required&#93; The client idempotency token of the application to update. Its value
#' must be unique for each request.
#' @param initialCapacity The capacity to initialize when the application is updated.
#' @param maximumCapacity The maximum capacity to allocate when the application is updated. This
#' is cumulative across all workers at any given point in time during the
#' lifespan of the application. No new resources will be created once any
#' one of the defined limits is hit.
#' @param autoStartConfiguration The configuration for an application to automatically start on job
#' submission.
#' @param autoStopConfiguration The configuration for an application to automatically stop after a
#' certain amount of time being idle.
#' @param networkConfiguration 
#' @param architecture The CPU architecture of an application.
#' @param imageConfiguration The image configuration to be used for all worker types. You can either
#' set this parameter or `imageConfiguration` for each worker type in
#' `WorkerTypeSpecificationInput`.
#' @param workerTypeSpecifications The key-value pairs that specify worker type to
#' `WorkerTypeSpecificationInput`. This parameter must contain all valid
#' worker types for a Spark or Hive application. Valid worker types include
#' `Driver` and `Executor` for Spark applications and `HiveDriver` and
#' `TezTask` for Hive applications. You can either set image details in
#' this parameter for each worker type, or in `imageConfiguration` for all
#' worker types.
#' @param releaseLabel The Amazon EMR release label for the application. You can change the
#' release label to use a different release of Amazon EMR.
#' @param runtimeConfiguration The
#' [Configuration](https://docs.aws.amazon.com/emr-serverless/latest/APIReference/API_Configuration.html)
#' specifications to use when updating an application. Each configuration
#' consists of a classification and properties. This configuration is
#' applied across all the job runs submitted under the application.
#' @param monitoringConfiguration The configuration setting for monitoring.
#'
#' @keywords internal
#'
#' @rdname emrserverless_update_application
emrserverless_update_application <- function(applicationId, clientToken, initialCapacity = NULL, maximumCapacity = NULL, autoStartConfiguration = NULL, autoStopConfiguration = NULL, networkConfiguration = NULL, architecture = NULL, imageConfiguration = NULL, workerTypeSpecifications = NULL, releaseLabel = NULL, runtimeConfiguration = NULL, monitoringConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateApplication",
    http_method = "PATCH",
    http_path = "/applications/{applicationId}",
    paginator = list()
  )
  input <- .emrserverless$update_application_input(applicationId = applicationId, clientToken = clientToken, initialCapacity = initialCapacity, maximumCapacity = maximumCapacity, autoStartConfiguration = autoStartConfiguration, autoStopConfiguration = autoStopConfiguration, networkConfiguration = networkConfiguration, architecture = architecture, imageConfiguration = imageConfiguration, workerTypeSpecifications = workerTypeSpecifications, releaseLabel = releaseLabel, runtimeConfiguration = runtimeConfiguration, monitoringConfiguration = monitoringConfiguration)
  output <- .emrserverless$update_application_output()
  config <- get_config()
  svc <- .emrserverless$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.emrserverless$operations$update_application <- emrserverless_update_application
