% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecr_operations.R
\name{ecr_get_authorization_token}
\alias{ecr_get_authorization_token}
\title{Retrieves a token that is valid for a specified registry for 12 hours}
\usage{
ecr_get_authorization_token(registryIds)
}
\arguments{
\item{registryIds}{A list of AWS account IDs that are associated with the registries for
which to get authorization tokens. If you do not specify a registry, the
default registry is assumed.}
}
\description{
Retrieves a token that is valid for a specified registry for 12 hours.
This command allows you to use the \code{docker} CLI to push and pull images
with Amazon ECR. If you do not specify a registry, the default registry
is assumed.
}
\details{
The \code{authorizationToken} returned for each registry specified is a
base64 encoded string that can be decoded and used in a \verb{docker login}
command to authenticate to a registry. The AWS CLI offers an
\verb{aws ecr get-login} command that simplifies the login process.
}
\section{Request syntax}{
\preformatted{svc$get_authorization_token(
  registryIds = list(
    "string"
  )
)
}
}

\examples{
# This example gets an authorization token for your default registry.
\dontrun{svc$get_authorization_token()}

}
\keyword{internal}
