% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_spot_instance_requests}
\alias{ec2_describe_spot_instance_requests}
\title{Describes the specified Spot Instance requests}
\usage{
ec2_describe_spot_instance_requests(Filters, DryRun,
  SpotInstanceRequestIds, NextToken, MaxResults)
}
\arguments{
\item{Filters}{One or more filters.
\itemize{
\item \code{availability-zone-group} - The Availability Zone group.
\item \code{create-time} - The time stamp when the Spot Instance request was
created.
\item \code{fault-code} - The fault code related to the request.
\item \code{fault-message} - The fault message related to the request.
\item \code{instance-id} - The ID of the instance that fulfilled the request.
\item \code{launch-group} - The Spot Instance launch group.
\item \code{launch.block-device-mapping.delete-on-termination} - Indicates
whether the EBS volume is deleted on instance termination.
\item \code{launch.block-device-mapping.device-name} - The device name for the
volume in the block device mapping (for example, \verb{/dev/sdh} or
\code{xvdh}).
\item \code{launch.block-device-mapping.snapshot-id} - The ID of the snapshot
for the EBS volume.
\item \code{launch.block-device-mapping.volume-size} - The size of the EBS
volume, in GiB.
\item \code{launch.block-device-mapping.volume-type} - The type of EBS volume:
\code{gp2} for General Purpose SSD, \code{io1} for Provisioned IOPS SSD, \code{st1}
for Throughput Optimized HDD, \code{sc1}for Cold HDD, or \code{standard} for
Magnetic.
\item \code{launch.group-id} - The ID of the security group for the instance.
\item \code{launch.group-name} - The name of the security group for the
instance.
\item \code{launch.image-id} - The ID of the AMI.
\item \code{launch.instance-type} - The type of instance (for example,
\code{m3.medium}).
\item \code{launch.kernel-id} - The kernel ID.
\item \code{launch.key-name} - The name of the key pair the instance launched
with.
\item \code{launch.monitoring-enabled} - Whether detailed monitoring is enabled
for the Spot Instance.
\item \code{launch.ramdisk-id} - The RAM disk ID.
\item \code{launched-availability-zone} - The Availability Zone in which the
request is launched.
\item \code{network-interface.addresses.primary} - Indicates whether the IP
address is the primary private IP address.
\item \code{network-interface.delete-on-termination} - Indicates whether the
network interface is deleted when the instance is terminated.
\item \code{network-interface.description} - A description of the network
interface.
\item \code{network-interface.device-index} - The index of the device for the
network interface attachment on the instance.
\item \code{network-interface.group-id} - The ID of the security group
associated with the network interface.
\item \code{network-interface.network-interface-id} - The ID of the network
interface.
\item \code{network-interface.private-ip-address} - The primary private IP
address of the network interface.
\item \code{network-interface.subnet-id} - The ID of the subnet for the
instance.
\item \code{product-description} - The product description associated with the
instance (\code{Linux/UNIX} \\| \code{Windows}).
\item \code{spot-instance-request-id} - The Spot Instance request ID.
\item \code{spot-price} - The maximum hourly price for any Spot Instance
launched to fulfill the request.
\item \code{state} - The state of the Spot Instance request (\code{open} \\| \code{active}
\\| \code{closed} \\| \code{cancelled} \\| \code{failed}). Spot request status
information can help you track your Amazon EC2 Spot Instance
requests. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html}{Spot Request Status}
in the \emph{Amazon EC2 User Guide for Linux Instances}.
\item \code{status-code} - The short code describing the most recent evaluation
of your Spot Instance request.
\item \code{status-message} - The message explaining the status of the Spot
Instance request.
\item \code{tag}:\\<key\\> - The key/value combination of a tag assigned to the
resource. Use the tag key in the filter name and the tag value as
the filter value. For example, to find all resources that have a tag
with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner} for
the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{type} - The type of Spot Instance request (\code{one-time} \\|
\code{persistent}).
\item \code{valid-from} - The start date of the request.
\item \code{valid-until} - The end date of the request.
}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{SpotInstanceRequestIds}{One or more Spot Instance request IDs.}

\item{NextToken}{The token to request the next set of results. This value is \code{null} when
there are no more results to return.}

\item{MaxResults}{The maximum number of results to return in a single call. Specify a
value between 5 and 1000. To retrieve the remaining results, make
another call with the returned \code{NextToken} value.}
}
\description{
Describes the specified Spot Instance requests.
}
\details{
You can use \code{DescribeSpotInstanceRequests} to find a running Spot
Instance by examining the response. If the status of the Spot Instance
is \code{fulfilled}, the instance ID appears in the response and contains the
identifier of the instance. Alternatively, you can use DescribeInstances
with a filter to look for instances where the instance lifecycle is
\code{spot}.

We recommend that you set \code{MaxResults} to a value between 5 and 1000 to
limit the number of results returned. This paginates the output, which
makes the list more manageable and returns the results faster. If the
list of results exceeds your \code{MaxResults} value, then that number of
results is returned along with a \code{NextToken} value that can be passed to
a subsequent \code{DescribeSpotInstanceRequests} request to retrieve the
remaining results.

Spot Instance requests are deleted four hours after they are canceled
and their instances are terminated.
}
\section{Request syntax}{
\preformatted{svc$describe_spot_instance_requests(
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  DryRun = TRUE|FALSE,
  SpotInstanceRequestIds = list(
    "string"
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\examples{
# This example describes the specified Spot Instance request.
\dontrun{svc$describe_spot_instance_requests(
  SpotInstanceRequestIds = list(
    "sir-08b93456"
  )
)}

}
\keyword{internal}
