% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_cancel_capacity_reservation}
\alias{ec2_cancel_capacity_reservation}
\title{Cancels the specified Capacity Reservation, releases the reserved
capacity, and changes the Capacity Reservation's state to cancelled}
\usage{
ec2_cancel_capacity_reservation(CapacityReservationId, DryRun)
}
\arguments{
\item{CapacityReservationId}{[required] The ID of the Capacity Reservation to be cancelled.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Cancels the specified Capacity Reservation, releases the reserved
capacity, and changes the Capacity Reservation's state to \code{cancelled}.
}
\details{
Instances running in the reserved capacity continue running until you
stop them. Stopped instances that target the Capacity Reservation can no
longer launch. Modify these instances to either target a different
Capacity Reservation, launch On-Demand Instance capacity, or run in any
open Capacity Reservation that has matching attributes and sufficient
capacity.
}
\section{Request syntax}{
\preformatted{svc$cancel_capacity_reservation(
  CapacityReservationId = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
