% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_get_managed_prefix_list_entries}
\alias{ec2_get_managed_prefix_list_entries}
\title{Gets information about the entries for a specified managed prefix list}
\usage{
ec2_get_managed_prefix_list_entries(DryRun, PrefixListId, TargetVersion,
  MaxResults, NextToken)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{PrefixListId}{[required] The ID of the prefix list.}

\item{TargetVersion}{The version of the prefix list for which to return the entries. The
default is the current version.}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  Entries = list(
    list(
      Cidr = "string",
      Description = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Gets information about the entries for a specified managed prefix list.
}
\section{Request syntax}{
\preformatted{svc$get_managed_prefix_list_entries(
  DryRun = TRUE|FALSE,
  PrefixListId = "string",
  TargetVersion = 123,
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
