% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_domain_entry}
\alias{lightsail_create_domain_entry}
\title{Creates one of the following domain name system (DNS) records in a
domain DNS zone: Address (A), canonical name (CNAME), mail exchanger
(MX), name server (NS), start of authority (SOA), service locator (SRV),
or text (TXT)}
\usage{
lightsail_create_domain_entry(domainName, domainEntry)
}
\arguments{
\item{domainName}{[required] The domain name (e.g., \code{example.com}) for which you want to create the
domain entry.}

\item{domainEntry}{[required] An array of key-value pairs containing information about the domain
entry request.}
}
\description{
Creates one of the following domain name system (DNS) records in a
domain DNS zone: Address (A), canonical name (CNAME), mail exchanger
(MX), name server (NS), start of authority (SOA), service locator (SRV),
or text (TXT).

The \verb{create domain entry} operation supports tag-based access control
via resource tags applied to the resource identified by \verb{domain name}.
For more information, see the Lightsail Dev Guide.
}
\section{Request syntax}{
\preformatted{svc$create_domain_entry(
  domainName = "string",
  domainEntry = list(
    id = "string",
    name = "string",
    target = "string",
    isAlias = TRUE|FALSE,
    type = "string",
    options = list(
      "string"
    )
  )
)
}
}

\keyword{internal}
