% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_update_event_source_mapping}
\alias{lambda_update_event_source_mapping}
\title{Updates an event source mapping}
\usage{
lambda_update_event_source_mapping(UUID, FunctionName, Enabled,
  BatchSize, MaximumBatchingWindowInSeconds, DestinationConfig,
  MaximumRecordAgeInSeconds, BisectBatchOnFunctionError,
  MaximumRetryAttempts, ParallelizationFactor, SourceAccessConfigurations,
  TumblingWindowInSeconds, FunctionResponseTypes)
}
\arguments{
\item{UUID}{[required] The identifier of the event source mapping.}

\item{FunctionName}{The name of the Lambda function.

\strong{Name formats}
\itemize{
\item \strong{Function name} - \code{MyFunction}.
\item \strong{Function ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:MyFunction}.
\item \strong{Version or Alias ARN} -
\verb{arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD}.
\item \strong{Partial ARN} - \verb{123456789012:function:MyFunction}.
}

The length constraint applies only to the full ARN. If you specify only
the function name, it's limited to 64 characters in length.}

\item{Enabled}{If true, the event source mapping is active. Set to false to pause
polling and invocation.}

\item{BatchSize}{The maximum number of items to retrieve in a single batch.
\itemize{
\item \strong{Amazon Kinesis} - Default 100. Max 10,000.
\item \strong{Amazon DynamoDB Streams} - Default 100. Max 1,000.
\item \strong{Amazon Simple Queue Service} - Default 10. For standard queues
the max is 10,000. For FIFO queues the max is 10.
\item \strong{Amazon Managed Streaming for Apache Kafka} - Default 100. Max
10,000.
\item \strong{Self-Managed Apache Kafka} - Default 100. Max 10,000.
}}

\item{MaximumBatchingWindowInSeconds}{(Streams and SQS standard queues) The maximum amount of time to gather
records before invoking the function, in seconds.}

\item{DestinationConfig}{(Streams) An Amazon SQS queue or Amazon SNS topic destination for
discarded records.}

\item{MaximumRecordAgeInSeconds}{(Streams) Discard records older than the specified age. The default
value is infinite (-1).}

\item{BisectBatchOnFunctionError}{(Streams) If the function returns an error, split the batch in two and
retry.}

\item{MaximumRetryAttempts}{(Streams) Discard records after the specified number of retries. The
default value is infinite (-1). When set to infinite (-1), failed
records will be retried until the record expires.}

\item{ParallelizationFactor}{(Streams) The number of batches to process from each shard concurrently.}

\item{SourceAccessConfigurations}{An array of the authentication protocol, or the VPC components to secure
your event source.}

\item{TumblingWindowInSeconds}{(Streams) The duration of a processing window in seconds. The range is
between 1 second up to 15 minutes.}

\item{FunctionResponseTypes}{(Streams) A list of current response type enums applied to the event
source mapping.}
}
\description{
Updates an event source mapping. You can change the function that AWS
Lambda invokes, or pause invocation and resume later from the same
location.

The following error handling options are only available for stream
sources (DynamoDB and Kinesis):
\itemize{
\item \code{BisectBatchOnFunctionError} - If the function returns an error,
split the batch in two and retry.
\item \code{DestinationConfig} - Send discarded records to an Amazon SQS queue
or Amazon SNS topic.
\item \code{MaximumRecordAgeInSeconds} - Discard records older than the
specified age. The default value is infinite (-1). When set to
infinite (-1), failed records are retried until the record expires
\item \code{MaximumRetryAttempts} - Discard records after the specified number
of retries. The default value is infinite (-1). When set to infinite
(-1), failed records are retried until the record expires.
\item \code{ParallelizationFactor} - Process multiple batches from each shard
concurrently.
}
}
\section{Request syntax}{
\preformatted{svc$update_event_source_mapping(
  UUID = "string",
  FunctionName = "string",
  Enabled = TRUE|FALSE,
  BatchSize = 123,
  MaximumBatchingWindowInSeconds = 123,
  DestinationConfig = list(
    OnSuccess = list(
      Destination = "string"
    ),
    OnFailure = list(
      Destination = "string"
    )
  ),
  MaximumRecordAgeInSeconds = 123,
  BisectBatchOnFunctionError = TRUE|FALSE,
  MaximumRetryAttempts = 123,
  ParallelizationFactor = 123,
  SourceAccessConfigurations = list(
    list(
      Type = "BASIC_AUTH"|"VPC_SUBNET"|"VPC_SECURITY_GROUP"|"SASL_SCRAM_512_AUTH"|"SASL_SCRAM_256_AUTH",
      URI = "string"
    )
  ),
  TumblingWindowInSeconds = 123,
  FunctionResponseTypes = list(
    "ReportBatchItemFailures"
  )
)
}
}

\examples{
\dontrun{
# This operation updates a Lambda function event source mapping
svc$update_event_source_mapping(
  BatchSize = 123L,
  Enabled = TRUE,
  FunctionName = "myFunction",
  UUID = "1234xCy789012"
)
}

}
\keyword{internal}
