% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_enable_fast_snapshot_restores}
\alias{ec2_enable_fast_snapshot_restores}
\title{Enables fast snapshot restores for the specified snapshots in the
specified Availability Zones}
\usage{
ec2_enable_fast_snapshot_restores(AvailabilityZones, SourceSnapshotIds,
  DryRun)
}
\arguments{
\item{AvailabilityZones}{[required] One or more Availability Zones. For example, \verb{us-east-2a}.}

\item{SourceSnapshotIds}{[required] The IDs of one or more snapshots. For example, \verb{snap-1234567890abcdef0}.
You can specify a snapshot that was shared with you from another AWS
account.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Enables fast snapshot restores for the specified snapshots in the
specified Availability Zones.

You get the full benefit of fast snapshot restores after they enter the
\code{enabled} state. To get the current state of fast snapshot restores, use
DescribeFastSnapshotRestores. To disable fast snapshot restores, use
DisableFastSnapshotRestores.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-fast-snapshot-restore.html}{Amazon EBS fast snapshot restore}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$enable_fast_snapshot_restores(
  AvailabilityZones = list(
    "string"
  ),
  SourceSnapshotIds = list(
    "string"
  ),
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
