# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include eks_service.R
NULL

#' Creates an Amazon EKS add-on
#'
#' @description
#' Creates an Amazon EKS add-on.
#' 
#' Amazon EKS add-ons help to automate the provisioning and lifecycle
#' management of common operational software for Amazon EKS clusters.
#' Amazon EKS add-ons can only be used with Amazon EKS clusters running
#' version 1.18 with platform version `eks.3` or later because add-ons rely
#' on the Server-side Apply Kubernetes feature, which is only available in
#' Kubernetes 1.18 and later.
#'
#' @usage
#' eks_create_addon(clusterName, addonName, addonVersion,
#'   serviceAccountRoleArn, resolveConflicts, clientRequestToken, tags)
#'
#' @param clusterName &#91;required&#93; The name of the cluster to create the add-on for.
#' @param addonName &#91;required&#93; The name of the add-on. The name must match one of the names returned by
#' [`ListAddons`](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html)
#' .
#' @param addonVersion The version of the add-on. The version must match one of the versions
#' returned by
#' [`DescribeAddonVersions`](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html)
#' .
#' @param serviceAccountRoleArn The Amazon Resource Name (ARN) of an existing IAM role to bind to the
#' add-on's service account. The role must be assigned the IAM permissions
#' required by the add-on. If you don't specify an existing IAM role, then
#' the add-on uses the permissions assigned to the node IAM role. For more
#' information, see [Amazon EKS node IAM
#' role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
#' in the *Amazon EKS User Guide*.
#' 
#' To specify an existing IAM role, you must have an IAM OpenID Connect
#' (OIDC) provider created for your cluster. For more information, see
#' [Enabling IAM roles for service accounts on your
#' cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
#' in the *Amazon EKS User Guide*.
#' @param resolveConflicts How to resolve parameter value conflicts when migrating an existing
#' add-on to an Amazon EKS add-on.
#' @param clientRequestToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param tags The metadata to apply to the cluster to assist with categorization and
#' organization. Each tag consists of a key and an optional value, both of
#' which you define.
#'
#' @section Request syntax:
#' ```
#' svc$create_addon(
#'   clusterName = "string",
#'   addonName = "string",
#'   addonVersion = "string",
#'   serviceAccountRoleArn = "string",
#'   resolveConflicts = "OVERWRITE"|"NONE",
#'   clientRequestToken = "string",
#'   tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_create_addon
eks_create_addon <- function(clusterName, addonName, addonVersion = NULL, serviceAccountRoleArn = NULL, resolveConflicts = NULL, clientRequestToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateAddon",
    http_method = "POST",
    http_path = "/clusters/{name}/addons",
    paginator = list()
  )
  input <- .eks$create_addon_input(clusterName = clusterName, addonName = addonName, addonVersion = addonVersion, serviceAccountRoleArn = serviceAccountRoleArn, resolveConflicts = resolveConflicts, clientRequestToken = clientRequestToken, tags = tags)
  output <- .eks$create_addon_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$create_addon <- eks_create_addon

#' Creates an Amazon EKS control plane
#'
#' @description
#' Creates an Amazon EKS control plane.
#' 
#' The Amazon EKS control plane consists of control plane instances that
#' run the Kubernetes software, such as `etcd` and the API server. The
#' control plane runs in an account managed by AWS, and the Kubernetes API
#' is exposed via the Amazon EKS API server endpoint. Each Amazon EKS
#' cluster control plane is single-tenant and unique and runs on its own
#' set of Amazon EC2 instances.
#' 
#' The cluster control plane is provisioned across multiple Availability
#' Zones and fronted by an Elastic Load Balancing Network Load Balancer.
#' Amazon EKS also provisions elastic network interfaces in your VPC
#' subnets to provide connectivity from the control plane instances to the
#' worker nodes (for example, to support `kubectl exec`, `logs`, and
#' `proxy` data flows).
#' 
#' Amazon EKS worker nodes run in your AWS account and connect to your
#' cluster's control plane via the Kubernetes API server endpoint and a
#' certificate file that is created for your cluster.
#' 
#' You can use the `endpointPublicAccess` and `endpointPrivateAccess`
#' parameters to enable or disable public and private access to your
#' cluster's Kubernetes API server endpoint. By default, public access is
#' enabled, and private access is disabled. For more information, see
#' [Amazon EKS Cluster Endpoint Access
#' Control](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
#' in the **Amazon EKS User Guide** .
#' 
#' You can use the `logging` parameter to enable or disable exporting the
#' Kubernetes control plane logs for your cluster to CloudWatch Logs. By
#' default, cluster control plane logs aren't exported to CloudWatch Logs.
#' For more information, see [Amazon EKS Cluster Control Plane
#' Logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
#' in the **Amazon EKS User Guide** .
#' 
#' CloudWatch Logs ingestion, archive storage, and data scanning rates
#' apply to exported control plane logs. For more information, see [Amazon
#' CloudWatch Pricing](https://aws.amazon.com/cloudwatch/pricing/).
#' 
#' Cluster creation typically takes between 10 and 15 minutes. After you
#' create an Amazon EKS cluster, you must configure your Kubernetes tooling
#' to communicate with the API server and launch worker nodes into your
#' cluster. For more information, see [Managing Cluster
#' Authentication](https://docs.aws.amazon.com/eks/latest/userguide/managing-auth.html)
#' and [Launching Amazon EKS Worker
#' Nodes](https://docs.aws.amazon.com/eks/latest/userguide/launch-workers.html)
#' in the *Amazon EKS User Guide*.
#'
#' @usage
#' eks_create_cluster(name, version, roleArn, resourcesVpcConfig,
#'   kubernetesNetworkConfig, logging, clientRequestToken, tags,
#'   encryptionConfig)
#'
#' @param name &#91;required&#93; The unique name to give to your cluster.
#' @param version The desired Kubernetes version for your cluster. If you don't specify a
#' value here, the latest version available in Amazon EKS is used.
#' @param roleArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role that provides permissions
#' for the Kubernetes control plane to make calls to AWS API operations on
#' your behalf. For more information, see [Amazon EKS Service IAM
#' Role](https://docs.aws.amazon.com/eks/latest/userguide/service_IAM_role.html)
#' in the **Amazon EKS User Guide** .
#' @param resourcesVpcConfig &#91;required&#93; The VPC configuration used by the cluster control plane. Amazon EKS VPC
#' resources have specific requirements to work properly with Kubernetes.
#' For more information, see [Cluster VPC
#' Considerations](https://docs.aws.amazon.com/eks/latest/userguide/network_reqs.html)
#' and [Cluster Security Group
#' Considerations](https://docs.aws.amazon.com/eks/latest/userguide/sec-group-reqs.html)
#' in the *Amazon EKS User Guide*. You must specify at least two subnets.
#' You can specify up to five security groups, but we recommend that you
#' use a dedicated security group for your cluster control plane.
#' @param kubernetesNetworkConfig The Kubernetes network configuration for the cluster.
#' @param logging Enable or disable exporting the Kubernetes control plane logs for your
#' cluster to CloudWatch Logs. By default, cluster control plane logs
#' aren't exported to CloudWatch Logs. For more information, see [Amazon
#' EKS Cluster Control Plane
#' Logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
#' in the **Amazon EKS User Guide** .
#' 
#' CloudWatch Logs ingestion, archive storage, and data scanning rates
#' apply to exported control plane logs. For more information, see [Amazon
#' CloudWatch Pricing](https://aws.amazon.com/cloudwatch/pricing/).
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param tags The metadata to apply to the cluster to assist with categorization and
#' organization. Each tag consists of a key and an optional value, both of
#' which you define.
#' @param encryptionConfig The encryption configuration for the cluster.
#'
#' @section Request syntax:
#' ```
#' svc$create_cluster(
#'   name = "string",
#'   version = "string",
#'   roleArn = "string",
#'   resourcesVpcConfig = list(
#'     subnetIds = list(
#'       "string"
#'     ),
#'     securityGroupIds = list(
#'       "string"
#'     ),
#'     endpointPublicAccess = TRUE|FALSE,
#'     endpointPrivateAccess = TRUE|FALSE,
#'     publicAccessCidrs = list(
#'       "string"
#'     )
#'   ),
#'   kubernetesNetworkConfig = list(
#'     serviceIpv4Cidr = "string"
#'   ),
#'   logging = list(
#'     clusterLogging = list(
#'       list(
#'         types = list(
#'           "api"|"audit"|"authenticator"|"controllerManager"|"scheduler"
#'         ),
#'         enabled = TRUE|FALSE
#'       )
#'     )
#'   ),
#'   clientRequestToken = "string",
#'   tags = list(
#'     "string"
#'   ),
#'   encryptionConfig = list(
#'     list(
#'       resources = list(
#'         "string"
#'       ),
#'       provider = list(
#'         keyArn = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following example creates an Amazon EKS cluster called prod.
#' svc$create_cluster(
#'   version = "1.10",
#'   name = "prod",
#'   clientRequestToken = "1d2129a1-3d38-460a-9756-e5b91fddb951",
#'   resourcesVpcConfig = list(
#'     securityGroupIds = list(
#'       "sg-6979fe18"
#'     ),
#'     subnetIds = list(
#'       "subnet-6782e71e",
#'       "subnet-e7e761ac"
#'     )
#'   ),
#'   roleArn = "arn:aws:iam::012345678910:role/eks-service-role-AWSServiceRoleForAmazonEKS-J7ON..."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname eks_create_cluster
eks_create_cluster <- function(name, version = NULL, roleArn, resourcesVpcConfig, kubernetesNetworkConfig = NULL, logging = NULL, clientRequestToken = NULL, tags = NULL, encryptionConfig = NULL) {
  op <- new_operation(
    name = "CreateCluster",
    http_method = "POST",
    http_path = "/clusters",
    paginator = list()
  )
  input <- .eks$create_cluster_input(name = name, version = version, roleArn = roleArn, resourcesVpcConfig = resourcesVpcConfig, kubernetesNetworkConfig = kubernetesNetworkConfig, logging = logging, clientRequestToken = clientRequestToken, tags = tags, encryptionConfig = encryptionConfig)
  output <- .eks$create_cluster_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$create_cluster <- eks_create_cluster

#' Creates an AWS Fargate profile for your Amazon EKS cluster
#'
#' @description
#' Creates an AWS Fargate profile for your Amazon EKS cluster. You must
#' have at least one Fargate profile in a cluster to be able to run pods on
#' Fargate.
#' 
#' The Fargate profile allows an administrator to declare which pods run on
#' Fargate and specify which pods run on which Fargate profile. This
#' declaration is done through the profile’s selectors. Each profile can
#' have up to five selectors that contain a namespace and labels. A
#' namespace is required for every selector. The label field consists of
#' multiple optional key-value pairs. Pods that match the selectors are
#' scheduled on Fargate. If a to-be-scheduled pod matches any of the
#' selectors in the Fargate profile, then that pod is run on Fargate.
#' 
#' When you create a Fargate profile, you must specify a pod execution role
#' to use with the pods that are scheduled with the profile. This role is
#' added to the cluster's Kubernetes [Role Based Access
#' Control](https://kubernetes.io/docs/reference/access-authn-authz/rbac/)
#' (RBAC) for authorization so that the `kubelet` that is running on the
#' Fargate infrastructure can register with your Amazon EKS cluster so that
#' it can appear in your cluster as a node. The pod execution role also
#' provides IAM permissions to the Fargate infrastructure to allow read
#' access to Amazon ECR image repositories. For more information, see [Pod
#' Execution
#' Role](https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html)
#' in the *Amazon EKS User Guide*.
#' 
#' Fargate profiles are immutable. However, you can create a new updated
#' profile to replace an existing profile and then delete the original
#' after the updated profile has finished creating.
#' 
#' If any Fargate profiles in a cluster are in the `DELETING` status, you
#' must wait for that Fargate profile to finish deleting before you can
#' create any other profiles in that cluster.
#' 
#' For more information, see [AWS Fargate
#' Profile](https://docs.aws.amazon.com/eks/latest/userguide/fargate-profile.html)
#' in the *Amazon EKS User Guide*.
#'
#' @usage
#' eks_create_fargate_profile(fargateProfileName, clusterName,
#'   podExecutionRoleArn, subnets, selectors, clientRequestToken, tags)
#'
#' @param fargateProfileName &#91;required&#93; The name of the Fargate profile.
#' @param clusterName &#91;required&#93; The name of the Amazon EKS cluster to apply the Fargate profile to.
#' @param podExecutionRoleArn &#91;required&#93; The Amazon Resource Name (ARN) of the pod execution role to use for pods
#' that match the selectors in the Fargate profile. The pod execution role
#' allows Fargate infrastructure to register with your cluster as a node,
#' and it provides read access to Amazon ECR image repositories. For more
#' information, see [Pod Execution
#' Role](https://docs.aws.amazon.com/eks/latest/userguide/pod-execution-role.html)
#' in the *Amazon EKS User Guide*.
#' @param subnets The IDs of subnets to launch your pods into. At this time, pods running
#' on Fargate are not assigned public IP addresses, so only private subnets
#' (with no direct route to an Internet Gateway) are accepted for this
#' parameter.
#' @param selectors The selectors to match for pods to use this Fargate profile. Each
#' selector must have an associated namespace. Optionally, you can also
#' specify labels for a namespace. You may specify up to five selectors in
#' a Fargate profile.
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param tags The metadata to apply to the Fargate profile to assist with
#' categorization and organization. Each tag consists of a key and an
#' optional value, both of which you define. Fargate profile tags do not
#' propagate to any other resources associated with the Fargate profile,
#' such as the pods that are scheduled with it.
#'
#' @section Request syntax:
#' ```
#' svc$create_fargate_profile(
#'   fargateProfileName = "string",
#'   clusterName = "string",
#'   podExecutionRoleArn = "string",
#'   subnets = list(
#'     "string"
#'   ),
#'   selectors = list(
#'     list(
#'       namespace = "string",
#'       labels = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   clientRequestToken = "string",
#'   tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_create_fargate_profile
eks_create_fargate_profile <- function(fargateProfileName, clusterName, podExecutionRoleArn, subnets = NULL, selectors = NULL, clientRequestToken = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateFargateProfile",
    http_method = "POST",
    http_path = "/clusters/{name}/fargate-profiles",
    paginator = list()
  )
  input <- .eks$create_fargate_profile_input(fargateProfileName = fargateProfileName, clusterName = clusterName, podExecutionRoleArn = podExecutionRoleArn, subnets = subnets, selectors = selectors, clientRequestToken = clientRequestToken, tags = tags)
  output <- .eks$create_fargate_profile_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$create_fargate_profile <- eks_create_fargate_profile

#' Creates a managed worker node group for an Amazon EKS cluster
#'
#' @description
#' Creates a managed worker node group for an Amazon EKS cluster. You can
#' only create a node group for your cluster that is equal to the current
#' Kubernetes version for the cluster. All node groups are created with the
#' latest AMI release version for the respective minor Kubernetes version
#' of the cluster, unless you deploy a custom AMI using a launch template.
#' For more information about using launch templates, see [Launch template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html).
#' 
#' An Amazon EKS managed node group is an Amazon EC2 Auto Scaling group and
#' associated Amazon EC2 instances that are managed by AWS for an Amazon
#' EKS cluster. Each node group uses a version of the Amazon EKS optimized
#' Amazon Linux 2 AMI. For more information, see [Managed Node
#' Groups](https://docs.aws.amazon.com/eks/latest/userguide/managed-node-groups.html)
#' in the *Amazon EKS User Guide*.
#'
#' @usage
#' eks_create_nodegroup(clusterName, nodegroupName, scalingConfig,
#'   diskSize, subnets, instanceTypes, amiType, remoteAccess, nodeRole,
#'   labels, tags, clientRequestToken, launchTemplate, capacityType, version,
#'   releaseVersion)
#'
#' @param clusterName &#91;required&#93; The name of the cluster to create the node group in.
#' @param nodegroupName &#91;required&#93; The unique name to give your node group.
#' @param scalingConfig The scaling configuration details for the Auto Scaling group that is
#' created for your node group.
#' @param diskSize The root device disk size (in GiB) for your node group instances. The
#' default disk size is 20 GiB. If you specify `launchTemplate`, then don't
#' specify `diskSize`, or the node group deployment will fail. For more
#' information about using launch templates with Amazon EKS, see [Launch
#' template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the Amazon EKS User Guide.
#' @param subnets &#91;required&#93; The subnets to use for the Auto Scaling group that is created for your
#' node group. These subnets must have the tag key
#' `kubernetes.io/cluster/CLUSTER_NAME` with a value of `shared`, where
#' `CLUSTER_NAME` is replaced with the name of your cluster. If you specify
#' `launchTemplate`, then don't specify
#' [`SubnetId`](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateNetworkInterface.html)
#' in your launch template, or the node group deployment will fail. For
#' more information about using launch templates with Amazon EKS, see
#' [Launch template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the Amazon EKS User Guide.
#' @param instanceTypes Specify the instance types for a node group. If you specify a GPU
#' instance type, be sure to specify `AL2_x86_64_GPU` with the `amiType`
#' parameter. If you specify `launchTemplate`, then you can specify zero or
#' one instance type in your launch template *or* you can specify 0-20
#' instance types for `instanceTypes`. If however, you specify an instance
#' type in your launch template *and* specify any `instanceTypes`, the node
#' group deployment will fail. If you don't specify an instance type in a
#' launch template or for `instanceTypes`, then `t3.medium` is used, by
#' default. If you specify `Spot` for `capacityType`, then we recommend
#' specifying multiple values for `instanceTypes`. For more information,
#' see Managed node group capacity types and [Launch template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the *Amazon EKS User Guide*.
#' @param amiType The AMI type for your node group. GPU instance types should use the
#' `AL2_x86_64_GPU` AMI type. Non-GPU instances should use the `AL2_x86_64`
#' AMI type. Arm instances should use the `AL2_ARM_64` AMI type. All types
#' use the Amazon EKS optimized Amazon Linux 2 AMI. If you specify
#' `launchTemplate`, and your launch template uses a custom AMI, then don't
#' specify `amiType`, or the node group deployment will fail. For more
#' information about using launch templates with Amazon EKS, see [Launch
#' template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the Amazon EKS User Guide.
#' @param remoteAccess The remote access (SSH) configuration to use with your node group. If
#' you specify `launchTemplate`, then don't specify `remoteAccess`, or the
#' node group deployment will fail. For more information about using launch
#' templates with Amazon EKS, see [Launch template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the Amazon EKS User Guide.
#' @param nodeRole &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role to associate with your
#' node group. The Amazon EKS worker node `kubelet` daemon makes calls to
#' AWS APIs on your behalf. Worker nodes receive permissions for these API
#' calls through an IAM instance profile and associated policies. Before
#' you can launch worker nodes and register them into a cluster, you must
#' create an IAM role for those worker nodes to use when they are launched.
#' For more information, see [Amazon EKS Worker Node IAM
#' Role](https://docs.aws.amazon.com/eks/latest/userguide/) in the **Amazon
#' EKS User Guide** . If you specify `launchTemplate`, then don't specify
#' [`IamInstanceProfile`](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_IamInstanceProfile.html)
#' in your launch template, or the node group deployment will fail. For
#' more information about using launch templates with Amazon EKS, see
#' [Launch template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the Amazon EKS User Guide.
#' @param labels The Kubernetes labels to be applied to the nodes in the node group when
#' they are created.
#' @param tags The metadata to apply to the node group to assist with categorization
#' and organization. Each tag consists of a key and an optional value, both
#' of which you define. Node group tags do not propagate to any other
#' resources associated with the node group, such as the Amazon EC2
#' instances or subnets.
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#' @param launchTemplate An object representing a node group's launch template specification. If
#' specified, then do not specify `instanceTypes`, `diskSize`, or
#' `remoteAccess` and make sure that the launch template meets the
#' requirements in `launchTemplateSpecification`.
#' @param capacityType The capacity type for your node group.
#' @param version The Kubernetes version to use for your managed nodes. By default, the
#' Kubernetes version of the cluster is used, and this is the only accepted
#' specified value. If you specify `launchTemplate`, and your launch
#' template uses a custom AMI, then don't specify `version`, or the node
#' group deployment will fail. For more information about using launch
#' templates with Amazon EKS, see [Launch template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the Amazon EKS User Guide.
#' @param releaseVersion The AMI version of the Amazon EKS optimized AMI to use with your node
#' group. By default, the latest available AMI version for the node group's
#' current Kubernetes version is used. For more information, see [Amazon
#' EKS optimized Amazon Linux 2 AMI
#' versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
#' in the *Amazon EKS User Guide*. If you specify `launchTemplate`, and
#' your launch template uses a custom AMI, then don't specify
#' `releaseVersion`, or the node group deployment will fail. For more
#' information about using launch templates with Amazon EKS, see [Launch
#' template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the Amazon EKS User Guide.
#'
#' @section Request syntax:
#' ```
#' svc$create_nodegroup(
#'   clusterName = "string",
#'   nodegroupName = "string",
#'   scalingConfig = list(
#'     minSize = 123,
#'     maxSize = 123,
#'     desiredSize = 123
#'   ),
#'   diskSize = 123,
#'   subnets = list(
#'     "string"
#'   ),
#'   instanceTypes = list(
#'     "string"
#'   ),
#'   amiType = "AL2_x86_64"|"AL2_x86_64_GPU"|"AL2_ARM_64",
#'   remoteAccess = list(
#'     ec2SshKey = "string",
#'     sourceSecurityGroups = list(
#'       "string"
#'     )
#'   ),
#'   nodeRole = "string",
#'   labels = list(
#'     "string"
#'   ),
#'   tags = list(
#'     "string"
#'   ),
#'   clientRequestToken = "string",
#'   launchTemplate = list(
#'     name = "string",
#'     version = "string",
#'     id = "string"
#'   ),
#'   capacityType = "ON_DEMAND"|"SPOT",
#'   version = "string",
#'   releaseVersion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_create_nodegroup
eks_create_nodegroup <- function(clusterName, nodegroupName, scalingConfig = NULL, diskSize = NULL, subnets, instanceTypes = NULL, amiType = NULL, remoteAccess = NULL, nodeRole, labels = NULL, tags = NULL, clientRequestToken = NULL, launchTemplate = NULL, capacityType = NULL, version = NULL, releaseVersion = NULL) {
  op <- new_operation(
    name = "CreateNodegroup",
    http_method = "POST",
    http_path = "/clusters/{name}/node-groups",
    paginator = list()
  )
  input <- .eks$create_nodegroup_input(clusterName = clusterName, nodegroupName = nodegroupName, scalingConfig = scalingConfig, diskSize = diskSize, subnets = subnets, instanceTypes = instanceTypes, amiType = amiType, remoteAccess = remoteAccess, nodeRole = nodeRole, labels = labels, tags = tags, clientRequestToken = clientRequestToken, launchTemplate = launchTemplate, capacityType = capacityType, version = version, releaseVersion = releaseVersion)
  output <- .eks$create_nodegroup_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$create_nodegroup <- eks_create_nodegroup

#' Delete an Amazon EKS add-on
#'
#' @description
#' Delete an Amazon EKS add-on.
#' 
#' When you remove the add-on, it will also be deleted from the cluster.
#' You can always manually start an add-on on the cluster using the
#' Kubernetes API.
#'
#' @usage
#' eks_delete_addon(clusterName, addonName)
#'
#' @param clusterName &#91;required&#93; The name of the cluster to delete the add-on from.
#' @param addonName &#91;required&#93; The name of the add-on. The name must match one of the names returned by
#' [`ListAddons`](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html)
#' .
#'
#' @section Request syntax:
#' ```
#' svc$delete_addon(
#'   clusterName = "string",
#'   addonName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_delete_addon
eks_delete_addon <- function(clusterName, addonName) {
  op <- new_operation(
    name = "DeleteAddon",
    http_method = "DELETE",
    http_path = "/clusters/{name}/addons/{addonName}",
    paginator = list()
  )
  input <- .eks$delete_addon_input(clusterName = clusterName, addonName = addonName)
  output <- .eks$delete_addon_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$delete_addon <- eks_delete_addon

#' Deletes the Amazon EKS cluster control plane
#'
#' @description
#' Deletes the Amazon EKS cluster control plane.
#' 
#' If you have active services in your cluster that are associated with a
#' load balancer, you must delete those services before deleting the
#' cluster so that the load balancers are deleted properly. Otherwise, you
#' can have orphaned resources in your VPC that prevent you from being able
#' to delete the VPC. For more information, see [Deleting a
#' Cluster](https://docs.aws.amazon.com/eks/latest/userguide/delete-cluster.html)
#' in the *Amazon EKS User Guide*.
#' 
#' If you have managed node groups or Fargate profiles attached to the
#' cluster, you must delete them first. For more information, see
#' DeleteNodegroup and DeleteFargateProfile.
#'
#' @usage
#' eks_delete_cluster(name)
#'
#' @param name &#91;required&#93; The name of the cluster to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_cluster(
#'   name = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example command deletes a cluster named `devel` in your default
#' # region.
#' svc$delete_cluster(
#'   name = "devel"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname eks_delete_cluster
eks_delete_cluster <- function(name) {
  op <- new_operation(
    name = "DeleteCluster",
    http_method = "DELETE",
    http_path = "/clusters/{name}",
    paginator = list()
  )
  input <- .eks$delete_cluster_input(name = name)
  output <- .eks$delete_cluster_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$delete_cluster <- eks_delete_cluster

#' Deletes an AWS Fargate profile
#'
#' @description
#' Deletes an AWS Fargate profile.
#' 
#' When you delete a Fargate profile, any pods running on Fargate that were
#' created with the profile are deleted. If those pods match another
#' Fargate profile, then they are scheduled on Fargate with that profile.
#' If they no longer match any Fargate profiles, then they are not
#' scheduled on Fargate and they may remain in a pending state.
#' 
#' Only one Fargate profile in a cluster can be in the `DELETING` status at
#' a time. You must wait for a Fargate profile to finish deleting before
#' you can delete any other profiles in that cluster.
#'
#' @usage
#' eks_delete_fargate_profile(clusterName, fargateProfileName)
#'
#' @param clusterName &#91;required&#93; The name of the Amazon EKS cluster associated with the Fargate profile
#' to delete.
#' @param fargateProfileName &#91;required&#93; The name of the Fargate profile to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_fargate_profile(
#'   clusterName = "string",
#'   fargateProfileName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_delete_fargate_profile
eks_delete_fargate_profile <- function(clusterName, fargateProfileName) {
  op <- new_operation(
    name = "DeleteFargateProfile",
    http_method = "DELETE",
    http_path = "/clusters/{name}/fargate-profiles/{fargateProfileName}",
    paginator = list()
  )
  input <- .eks$delete_fargate_profile_input(clusterName = clusterName, fargateProfileName = fargateProfileName)
  output <- .eks$delete_fargate_profile_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$delete_fargate_profile <- eks_delete_fargate_profile

#' Deletes an Amazon EKS node group for a cluster
#'
#' @description
#' Deletes an Amazon EKS node group for a cluster.
#'
#' @usage
#' eks_delete_nodegroup(clusterName, nodegroupName)
#'
#' @param clusterName &#91;required&#93; The name of the Amazon EKS cluster that is associated with your node
#' group.
#' @param nodegroupName &#91;required&#93; The name of the node group to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_nodegroup(
#'   clusterName = "string",
#'   nodegroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_delete_nodegroup
eks_delete_nodegroup <- function(clusterName, nodegroupName) {
  op <- new_operation(
    name = "DeleteNodegroup",
    http_method = "DELETE",
    http_path = "/clusters/{name}/node-groups/{nodegroupName}",
    paginator = list()
  )
  input <- .eks$delete_nodegroup_input(clusterName = clusterName, nodegroupName = nodegroupName)
  output <- .eks$delete_nodegroup_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$delete_nodegroup <- eks_delete_nodegroup

#' Describes an Amazon EKS add-on
#'
#' @description
#' Describes an Amazon EKS add-on.
#'
#' @usage
#' eks_describe_addon(clusterName, addonName)
#'
#' @param clusterName &#91;required&#93; The name of the cluster.
#' @param addonName &#91;required&#93; The name of the add-on. The name must match one of the names returned by
#' [`ListAddons`](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html)
#' .
#'
#' @section Request syntax:
#' ```
#' svc$describe_addon(
#'   clusterName = "string",
#'   addonName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_describe_addon
eks_describe_addon <- function(clusterName, addonName) {
  op <- new_operation(
    name = "DescribeAddon",
    http_method = "GET",
    http_path = "/clusters/{name}/addons/{addonName}",
    paginator = list()
  )
  input <- .eks$describe_addon_input(clusterName = clusterName, addonName = addonName)
  output <- .eks$describe_addon_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_addon <- eks_describe_addon

#' Describes the Kubernetes versions that the add-on can be used with
#'
#' @description
#' Describes the Kubernetes versions that the add-on can be used with.
#'
#' @usage
#' eks_describe_addon_versions(kubernetesVersion, maxResults, nextToken,
#'   addonName)
#'
#' @param kubernetesVersion The Kubernetes versions that the add-on can be used with.
#' @param maxResults The maximum number of results to return.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' `DescribeAddonVersionsRequest` where `maxResults` was used and the
#' results exceeded the value of that parameter. Pagination continues from
#' the end of the previous results that returned the `nextToken` value.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#' @param addonName The name of the add-on. The name must match one of the names returned by
#' [`ListAddons`](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html)
#' .
#'
#' @section Request syntax:
#' ```
#' svc$describe_addon_versions(
#'   kubernetesVersion = "string",
#'   maxResults = 123,
#'   nextToken = "string",
#'   addonName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_describe_addon_versions
eks_describe_addon_versions <- function(kubernetesVersion = NULL, maxResults = NULL, nextToken = NULL, addonName = NULL) {
  op <- new_operation(
    name = "DescribeAddonVersions",
    http_method = "GET",
    http_path = "/addons/supported-versions",
    paginator = list()
  )
  input <- .eks$describe_addon_versions_input(kubernetesVersion = kubernetesVersion, maxResults = maxResults, nextToken = nextToken, addonName = addonName)
  output <- .eks$describe_addon_versions_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_addon_versions <- eks_describe_addon_versions

#' Returns descriptive information about an Amazon EKS cluster
#'
#' @description
#' Returns descriptive information about an Amazon EKS cluster.
#' 
#' The API server endpoint and certificate authority data returned by this
#' operation are required for `kubelet` and `kubectl` to communicate with
#' your Kubernetes API server. For more information, see [Create a
#' kubeconfig for Amazon
#' EKS](https://docs.aws.amazon.com/eks/latest/userguide/create-kubeconfig.html).
#' 
#' The API server endpoint and certificate authority data aren't available
#' until the cluster reaches the `ACTIVE` state.
#'
#' @usage
#' eks_describe_cluster(name)
#'
#' @param name &#91;required&#93; The name of the cluster to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_cluster(
#'   name = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example command provides a description of the specified cluster in
#' # your default region.
#' svc$describe_cluster(
#'   name = "devel"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname eks_describe_cluster
eks_describe_cluster <- function(name) {
  op <- new_operation(
    name = "DescribeCluster",
    http_method = "GET",
    http_path = "/clusters/{name}",
    paginator = list()
  )
  input <- .eks$describe_cluster_input(name = name)
  output <- .eks$describe_cluster_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_cluster <- eks_describe_cluster

#' Returns descriptive information about an AWS Fargate profile
#'
#' @description
#' Returns descriptive information about an AWS Fargate profile.
#'
#' @usage
#' eks_describe_fargate_profile(clusterName, fargateProfileName)
#'
#' @param clusterName &#91;required&#93; The name of the Amazon EKS cluster associated with the Fargate profile.
#' @param fargateProfileName &#91;required&#93; The name of the Fargate profile to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_fargate_profile(
#'   clusterName = "string",
#'   fargateProfileName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_describe_fargate_profile
eks_describe_fargate_profile <- function(clusterName, fargateProfileName) {
  op <- new_operation(
    name = "DescribeFargateProfile",
    http_method = "GET",
    http_path = "/clusters/{name}/fargate-profiles/{fargateProfileName}",
    paginator = list()
  )
  input <- .eks$describe_fargate_profile_input(clusterName = clusterName, fargateProfileName = fargateProfileName)
  output <- .eks$describe_fargate_profile_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_fargate_profile <- eks_describe_fargate_profile

#' Returns descriptive information about an Amazon EKS node group
#'
#' @description
#' Returns descriptive information about an Amazon EKS node group.
#'
#' @usage
#' eks_describe_nodegroup(clusterName, nodegroupName)
#'
#' @param clusterName &#91;required&#93; The name of the Amazon EKS cluster associated with the node group.
#' @param nodegroupName &#91;required&#93; The name of the node group to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_nodegroup(
#'   clusterName = "string",
#'   nodegroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_describe_nodegroup
eks_describe_nodegroup <- function(clusterName, nodegroupName) {
  op <- new_operation(
    name = "DescribeNodegroup",
    http_method = "GET",
    http_path = "/clusters/{name}/node-groups/{nodegroupName}",
    paginator = list()
  )
  input <- .eks$describe_nodegroup_input(clusterName = clusterName, nodegroupName = nodegroupName)
  output <- .eks$describe_nodegroup_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_nodegroup <- eks_describe_nodegroup

#' Returns descriptive information about an update against your Amazon EKS
#' cluster or associated managed node group
#'
#' @description
#' Returns descriptive information about an update against your Amazon EKS
#' cluster or associated managed node group.
#' 
#' When the status of the update is `Succeeded`, the update is complete. If
#' an update fails, the status is `Failed`, and an error detail explains
#' the reason for the failure.
#'
#' @usage
#' eks_describe_update(name, updateId, nodegroupName, addonName)
#'
#' @param name &#91;required&#93; The name of the Amazon EKS cluster associated with the update.
#' @param updateId &#91;required&#93; The ID of the update to describe.
#' @param nodegroupName The name of the Amazon EKS node group associated with the update.
#' @param addonName The name of the add-on. The name must match one of the names returned by
#' [`ListAddons`](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html)
#' .
#'
#' @section Request syntax:
#' ```
#' svc$describe_update(
#'   name = "string",
#'   updateId = "string",
#'   nodegroupName = "string",
#'   addonName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_describe_update
eks_describe_update <- function(name, updateId, nodegroupName = NULL, addonName = NULL) {
  op <- new_operation(
    name = "DescribeUpdate",
    http_method = "GET",
    http_path = "/clusters/{name}/updates/{updateId}",
    paginator = list()
  )
  input <- .eks$describe_update_input(name = name, updateId = updateId, nodegroupName = nodegroupName, addonName = addonName)
  output <- .eks$describe_update_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$describe_update <- eks_describe_update

#' Lists the available add-ons
#'
#' @description
#' Lists the available add-ons.
#'
#' @usage
#' eks_list_addons(clusterName, maxResults, nextToken)
#'
#' @param clusterName &#91;required&#93; The name of the cluster.
#' @param maxResults The maximum number of add-on results returned by `ListAddonsRequest` in
#' paginated output. When you use this parameter, `ListAddonsRequest`
#' returns only `maxResults` results in a single page along with a
#' `nextToken` response element. You can see the remaining results of the
#' initial request by sending another `ListAddonsRequest` request with the
#' returned `nextToken` value. This value can be between 1 and 100. If you
#' don't use this parameter, `ListAddonsRequest` returns up to 100 results
#' and a `nextToken` value, if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' `ListAddonsRequest` where `maxResults` was used and the results exceeded
#' the value of that parameter. Pagination continues from the end of the
#' previous results that returned the `nextToken` value.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#'
#' @section Request syntax:
#' ```
#' svc$list_addons(
#'   clusterName = "string",
#'   maxResults = 123,
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_list_addons
eks_list_addons <- function(clusterName, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListAddons",
    http_method = "GET",
    http_path = "/clusters/{name}/addons",
    paginator = list()
  )
  input <- .eks$list_addons_input(clusterName = clusterName, maxResults = maxResults, nextToken = nextToken)
  output <- .eks$list_addons_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_addons <- eks_list_addons

#' Lists the Amazon EKS clusters in your AWS account in the specified
#' Region
#'
#' @description
#' Lists the Amazon EKS clusters in your AWS account in the specified
#' Region.
#'
#' @usage
#' eks_list_clusters(maxResults, nextToken)
#'
#' @param maxResults The maximum number of cluster results returned by `ListClusters` in
#' paginated output. When you use this parameter, `ListClusters` returns
#' only `maxResults` results in a single page along with a `nextToken`
#' response element. You can see the remaining results of the initial
#' request by sending another `ListClusters` request with the returned
#' `nextToken` value. This value can be between 1 and 100. If you don't use
#' this parameter, `ListClusters` returns up to 100 results and a
#' `nextToken` value if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated `ListClusters`
#' request where `maxResults` was used and the results exceeded the value
#' of that parameter. Pagination continues from the end of the previous
#' results that returned the `nextToken` value.
#' 
#' This token should be treated as an opaque identifier that is used only
#' to retrieve the next items in a list and not for other programmatic
#' purposes.
#'
#' @section Request syntax:
#' ```
#' svc$list_clusters(
#'   maxResults = 123,
#'   nextToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example command lists all of your available clusters in your
#' # default region.
#' svc$list_clusters()
#' }
#'
#' @keywords internal
#'
#' @rdname eks_list_clusters
eks_list_clusters <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListClusters",
    http_method = "GET",
    http_path = "/clusters",
    paginator = list()
  )
  input <- .eks$list_clusters_input(maxResults = maxResults, nextToken = nextToken)
  output <- .eks$list_clusters_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_clusters <- eks_list_clusters

#' Lists the AWS Fargate profiles associated with the specified cluster in
#' your AWS account in the specified Region
#'
#' @description
#' Lists the AWS Fargate profiles associated with the specified cluster in
#' your AWS account in the specified Region.
#'
#' @usage
#' eks_list_fargate_profiles(clusterName, maxResults, nextToken)
#'
#' @param clusterName &#91;required&#93; The name of the Amazon EKS cluster that you would like to listFargate
#' profiles in.
#' @param maxResults The maximum number of Fargate profile results returned by
#' `ListFargateProfiles` in paginated output. When you use this parameter,
#' `ListFargateProfiles` returns only `maxResults` results in a single page
#' along with a `nextToken` response element. You can see the remaining
#' results of the initial request by sending another `ListFargateProfiles`
#' request with the returned `nextToken` value. This value can be between 1
#' and 100. If you don't use this parameter, `ListFargateProfiles` returns
#' up to 100 results and a `nextToken` value if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' `ListFargateProfiles` request where `maxResults` was used and the
#' results exceeded the value of that parameter. Pagination continues from
#' the end of the previous results that returned the `nextToken` value.
#'
#' @section Request syntax:
#' ```
#' svc$list_fargate_profiles(
#'   clusterName = "string",
#'   maxResults = 123,
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_list_fargate_profiles
eks_list_fargate_profiles <- function(clusterName, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListFargateProfiles",
    http_method = "GET",
    http_path = "/clusters/{name}/fargate-profiles",
    paginator = list()
  )
  input <- .eks$list_fargate_profiles_input(clusterName = clusterName, maxResults = maxResults, nextToken = nextToken)
  output <- .eks$list_fargate_profiles_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_fargate_profiles <- eks_list_fargate_profiles

#' Lists the Amazon EKS managed node groups associated with the specified
#' cluster in your AWS account in the specified Region
#'
#' @description
#' Lists the Amazon EKS managed node groups associated with the specified
#' cluster in your AWS account in the specified Region. Self-managed node
#' groups are not listed.
#'
#' @usage
#' eks_list_nodegroups(clusterName, maxResults, nextToken)
#'
#' @param clusterName &#91;required&#93; The name of the Amazon EKS cluster that you would like to list node
#' groups in.
#' @param maxResults The maximum number of node group results returned by `ListNodegroups` in
#' paginated output. When you use this parameter, `ListNodegroups` returns
#' only `maxResults` results in a single page along with a `nextToken`
#' response element. You can see the remaining results of the initial
#' request by sending another `ListNodegroups` request with the returned
#' `nextToken` value. This value can be between 1 and 100. If you don't use
#' this parameter, `ListNodegroups` returns up to 100 results and a
#' `nextToken` value if applicable.
#' @param nextToken The `nextToken` value returned from a previous paginated
#' `ListNodegroups` request where `maxResults` was used and the results
#' exceeded the value of that parameter. Pagination continues from the end
#' of the previous results that returned the `nextToken` value.
#'
#' @section Request syntax:
#' ```
#' svc$list_nodegroups(
#'   clusterName = "string",
#'   maxResults = 123,
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_list_nodegroups
eks_list_nodegroups <- function(clusterName, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListNodegroups",
    http_method = "GET",
    http_path = "/clusters/{name}/node-groups",
    paginator = list()
  )
  input <- .eks$list_nodegroups_input(clusterName = clusterName, maxResults = maxResults, nextToken = nextToken)
  output <- .eks$list_nodegroups_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_nodegroups <- eks_list_nodegroups

#' List the tags for an Amazon EKS resource
#'
#' @description
#' List the tags for an Amazon EKS resource.
#'
#' @usage
#' eks_list_tags_for_resource(resourceArn)
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) that identifies the resource for which to
#' list the tags. Currently, the supported resources are Amazon EKS
#' clusters and managed node groups.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   resourceArn = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This example lists all of the tags for the `beta` cluster.
#' svc$list_tags_for_resource(
#'   resourceArn = "arn:aws:eks:us-west-2:012345678910:cluster/beta"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname eks_list_tags_for_resource
eks_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .eks$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .eks$list_tags_for_resource_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_tags_for_resource <- eks_list_tags_for_resource

#' Lists the updates associated with an Amazon EKS cluster or managed node
#' group in your AWS account, in the specified Region
#'
#' @description
#' Lists the updates associated with an Amazon EKS cluster or managed node
#' group in your AWS account, in the specified Region.
#'
#' @usage
#' eks_list_updates(name, nodegroupName, addonName, nextToken, maxResults)
#'
#' @param name &#91;required&#93; The name of the Amazon EKS cluster to list updates for.
#' @param nodegroupName The name of the Amazon EKS managed node group to list updates for.
#' @param addonName The names of the installed add-ons that have available updates.
#' @param nextToken The `nextToken` value returned from a previous paginated `ListUpdates`
#' request where `maxResults` was used and the results exceeded the value
#' of that parameter. Pagination continues from the end of the previous
#' results that returned the `nextToken` value.
#' @param maxResults The maximum number of update results returned by `ListUpdates` in
#' paginated output. When you use this parameter, `ListUpdates` returns
#' only `maxResults` results in a single page along with a `nextToken`
#' response element. You can see the remaining results of the initial
#' request by sending another `ListUpdates` request with the returned
#' `nextToken` value. This value can be between 1 and 100. If you don't use
#' this parameter, `ListUpdates` returns up to 100 results and a
#' `nextToken` value if applicable.
#'
#' @section Request syntax:
#' ```
#' svc$list_updates(
#'   name = "string",
#'   nodegroupName = "string",
#'   addonName = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_list_updates
eks_list_updates <- function(name, nodegroupName = NULL, addonName = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListUpdates",
    http_method = "GET",
    http_path = "/clusters/{name}/updates",
    paginator = list()
  )
  input <- .eks$list_updates_input(name = name, nodegroupName = nodegroupName, addonName = addonName, nextToken = nextToken, maxResults = maxResults)
  output <- .eks$list_updates_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$list_updates <- eks_list_updates

#' Associates the specified tags to a resource with the specified
#' resourceArn
#'
#' @description
#' Associates the specified tags to a resource with the specified
#' `resourceArn`. If existing tags on a resource are not specified in the
#' request parameters, they are not changed. When a resource is deleted,
#' the tags associated with that resource are deleted as well. Tags that
#' you create for Amazon EKS resources do not propagate to any other
#' resources associated with the cluster. For example, if you tag a cluster
#' with this operation, that tag does not automatically propagate to the
#' subnets and worker nodes associated with the cluster.
#'
#' @usage
#' eks_tag_resource(resourceArn, tags)
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to which to add tags.
#' Currently, the supported resources are Amazon EKS clusters and managed
#' node groups.
#' @param tags &#91;required&#93; The tags to add to the resource. A tag is an array of key-value pairs.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   resourceArn = "string",
#'   tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_tag_resource
eks_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .eks$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .eks$tag_resource_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$tag_resource <- eks_tag_resource

#' Deletes specified tags from a resource
#'
#' @description
#' Deletes specified tags from a resource.
#'
#' @usage
#' eks_untag_resource(resourceArn, tagKeys)
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource from which to delete
#' tags. Currently, the supported resources are Amazon EKS clusters and
#' managed node groups.
#' @param tagKeys &#91;required&#93; The keys of the tags to be removed.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   resourceArn = "string",
#'   tagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_untag_resource
eks_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    paginator = list()
  )
  input <- .eks$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .eks$untag_resource_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$untag_resource <- eks_untag_resource

#' Updates an Amazon EKS add-on
#'
#' @description
#' Updates an Amazon EKS add-on.
#'
#' @usage
#' eks_update_addon(clusterName, addonName, addonVersion,
#'   serviceAccountRoleArn, resolveConflicts, clientRequestToken)
#'
#' @param clusterName &#91;required&#93; The name of the cluster.
#' @param addonName &#91;required&#93; The name of the add-on. The name must match one of the names returned by
#' [`ListAddons`](https://docs.aws.amazon.com/eks/latest/APIReference/API_ListAddons.html)
#' .
#' @param addonVersion The version of the add-on. The version must match one of the versions
#' returned by
#' [`DescribeAddonVersions`](https://docs.aws.amazon.com/eks/latest/APIReference/API_DescribeAddonVersions.html)
#' .
#' @param serviceAccountRoleArn The Amazon Resource Name (ARN) of an existing IAM role to bind to the
#' add-on's service account. The role must be assigned the IAM permissions
#' required by the add-on. If you don't specify an existing IAM role, then
#' the add-on uses the permissions assigned to the node IAM role. For more
#' information, see [Amazon EKS node IAM
#' role](https://docs.aws.amazon.com/eks/latest/userguide/create-node-role.html)
#' in the *Amazon EKS User Guide*.
#' 
#' To specify an existing IAM role, you must have an IAM OpenID Connect
#' (OIDC) provider created for your cluster. For more information, see
#' [Enabling IAM roles for service accounts on your
#' cluster](https://docs.aws.amazon.com/eks/latest/userguide/enable-iam-roles-for-service-accounts.html)
#' in the *Amazon EKS User Guide*.
#' @param resolveConflicts How to resolve parameter value conflicts when applying the new version
#' of the add-on to the cluster.
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @section Request syntax:
#' ```
#' svc$update_addon(
#'   clusterName = "string",
#'   addonName = "string",
#'   addonVersion = "string",
#'   serviceAccountRoleArn = "string",
#'   resolveConflicts = "OVERWRITE"|"NONE",
#'   clientRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_update_addon
eks_update_addon <- function(clusterName, addonName, addonVersion = NULL, serviceAccountRoleArn = NULL, resolveConflicts = NULL, clientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateAddon",
    http_method = "POST",
    http_path = "/clusters/{name}/addons/{addonName}/update",
    paginator = list()
  )
  input <- .eks$update_addon_input(clusterName = clusterName, addonName = addonName, addonVersion = addonVersion, serviceAccountRoleArn = serviceAccountRoleArn, resolveConflicts = resolveConflicts, clientRequestToken = clientRequestToken)
  output <- .eks$update_addon_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_addon <- eks_update_addon

#' Updates an Amazon EKS cluster configuration
#'
#' @description
#' Updates an Amazon EKS cluster configuration. Your cluster continues to
#' function during the update. The response output includes an update ID
#' that you can use to track the status of your cluster update with the
#' DescribeUpdate API operation.
#' 
#' You can use this API operation to enable or disable exporting the
#' Kubernetes control plane logs for your cluster to CloudWatch Logs. By
#' default, cluster control plane logs aren't exported to CloudWatch Logs.
#' For more information, see [Amazon EKS Cluster Control Plane
#' Logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
#' in the **Amazon EKS User Guide** .
#' 
#' CloudWatch Logs ingestion, archive storage, and data scanning rates
#' apply to exported control plane logs. For more information, see [Amazon
#' CloudWatch Pricing](https://aws.amazon.com/cloudwatch/pricing/).
#' 
#' You can also use this API operation to enable or disable public and
#' private access to your cluster's Kubernetes API server endpoint. By
#' default, public access is enabled, and private access is disabled. For
#' more information, see [Amazon EKS Cluster Endpoint Access
#' Control](https://docs.aws.amazon.com/eks/latest/userguide/cluster-endpoint.html)
#' in the **Amazon EKS User Guide** .
#' 
#' At this time, you can not update the subnets or security group IDs for
#' an existing cluster.
#' 
#' Cluster updates are asynchronous, and they should finish within a few
#' minutes. During an update, the cluster status moves to `UPDATING` (this
#' status transition is eventually consistent). When the update is complete
#' (either `Failed` or `Successful`), the cluster status moves to `Active`.
#'
#' @usage
#' eks_update_cluster_config(name, resourcesVpcConfig, logging,
#'   clientRequestToken)
#'
#' @param name &#91;required&#93; The name of the Amazon EKS cluster to update.
#' @param resourcesVpcConfig 
#' @param logging Enable or disable exporting the Kubernetes control plane logs for your
#' cluster to CloudWatch Logs. By default, cluster control plane logs
#' aren't exported to CloudWatch Logs. For more information, see [Amazon
#' EKS Cluster Control Plane
#' Logs](https://docs.aws.amazon.com/eks/latest/userguide/control-plane-logs.html)
#' in the **Amazon EKS User Guide** .
#' 
#' CloudWatch Logs ingestion, archive storage, and data scanning rates
#' apply to exported control plane logs. For more information, see [Amazon
#' CloudWatch Pricing](https://aws.amazon.com/cloudwatch/pricing/).
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @section Request syntax:
#' ```
#' svc$update_cluster_config(
#'   name = "string",
#'   resourcesVpcConfig = list(
#'     subnetIds = list(
#'       "string"
#'     ),
#'     securityGroupIds = list(
#'       "string"
#'     ),
#'     endpointPublicAccess = TRUE|FALSE,
#'     endpointPrivateAccess = TRUE|FALSE,
#'     publicAccessCidrs = list(
#'       "string"
#'     )
#'   ),
#'   logging = list(
#'     clusterLogging = list(
#'       list(
#'         types = list(
#'           "api"|"audit"|"authenticator"|"controllerManager"|"scheduler"
#'         ),
#'         enabled = TRUE|FALSE
#'       )
#'     )
#'   ),
#'   clientRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_update_cluster_config
eks_update_cluster_config <- function(name, resourcesVpcConfig = NULL, logging = NULL, clientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateClusterConfig",
    http_method = "POST",
    http_path = "/clusters/{name}/update-config",
    paginator = list()
  )
  input <- .eks$update_cluster_config_input(name = name, resourcesVpcConfig = resourcesVpcConfig, logging = logging, clientRequestToken = clientRequestToken)
  output <- .eks$update_cluster_config_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_cluster_config <- eks_update_cluster_config

#' Updates an Amazon EKS cluster to the specified Kubernetes version
#'
#' @description
#' Updates an Amazon EKS cluster to the specified Kubernetes version. Your
#' cluster continues to function during the update. The response output
#' includes an update ID that you can use to track the status of your
#' cluster update with the DescribeUpdate API operation.
#' 
#' Cluster updates are asynchronous, and they should finish within a few
#' minutes. During an update, the cluster status moves to `UPDATING` (this
#' status transition is eventually consistent). When the update is complete
#' (either `Failed` or `Successful`), the cluster status moves to `Active`.
#' 
#' If your cluster has managed node groups attached to it, all of your node
#' groups’ Kubernetes versions must match the cluster’s Kubernetes version
#' in order to update the cluster to a new Kubernetes version.
#'
#' @usage
#' eks_update_cluster_version(name, version, clientRequestToken)
#'
#' @param name &#91;required&#93; The name of the Amazon EKS cluster to update.
#' @param version &#91;required&#93; The desired Kubernetes version following a successful update.
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @section Request syntax:
#' ```
#' svc$update_cluster_version(
#'   name = "string",
#'   version = "string",
#'   clientRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_update_cluster_version
eks_update_cluster_version <- function(name, version, clientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateClusterVersion",
    http_method = "POST",
    http_path = "/clusters/{name}/updates",
    paginator = list()
  )
  input <- .eks$update_cluster_version_input(name = name, version = version, clientRequestToken = clientRequestToken)
  output <- .eks$update_cluster_version_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_cluster_version <- eks_update_cluster_version

#' Updates an Amazon EKS managed node group configuration
#'
#' @description
#' Updates an Amazon EKS managed node group configuration. Your node group
#' continues to function during the update. The response output includes an
#' update ID that you can use to track the status of your node group update
#' with the DescribeUpdate API operation. Currently you can update the
#' Kubernetes labels for a node group or the scaling configuration.
#'
#' @usage
#' eks_update_nodegroup_config(clusterName, nodegroupName, labels,
#'   scalingConfig, clientRequestToken)
#'
#' @param clusterName &#91;required&#93; The name of the Amazon EKS cluster that the managed node group resides
#' in.
#' @param nodegroupName &#91;required&#93; The name of the managed node group to update.
#' @param labels The Kubernetes labels to be applied to the nodes in the node group after
#' the update.
#' @param scalingConfig The scaling configuration details for the Auto Scaling group after the
#' update.
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @section Request syntax:
#' ```
#' svc$update_nodegroup_config(
#'   clusterName = "string",
#'   nodegroupName = "string",
#'   labels = list(
#'     addOrUpdateLabels = list(
#'       "string"
#'     ),
#'     removeLabels = list(
#'       "string"
#'     )
#'   ),
#'   scalingConfig = list(
#'     minSize = 123,
#'     maxSize = 123,
#'     desiredSize = 123
#'   ),
#'   clientRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_update_nodegroup_config
eks_update_nodegroup_config <- function(clusterName, nodegroupName, labels = NULL, scalingConfig = NULL, clientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateNodegroupConfig",
    http_method = "POST",
    http_path = "/clusters/{name}/node-groups/{nodegroupName}/update-config",
    paginator = list()
  )
  input <- .eks$update_nodegroup_config_input(clusterName = clusterName, nodegroupName = nodegroupName, labels = labels, scalingConfig = scalingConfig, clientRequestToken = clientRequestToken)
  output <- .eks$update_nodegroup_config_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_nodegroup_config <- eks_update_nodegroup_config

#' Updates the Kubernetes version or AMI version of an Amazon EKS managed
#' node group
#'
#' @description
#' Updates the Kubernetes version or AMI version of an Amazon EKS managed
#' node group.
#' 
#' You can update a node group using a launch template only if the node
#' group was originally deployed with a launch template. If you need to
#' update a custom AMI in a node group that was deployed with a launch
#' template, then update your custom AMI, specify the new ID in a new
#' version of the launch template, and then update the node group to the
#' new version of the launch template.
#' 
#' If you update without a launch template, then you can update to the
#' latest available AMI version of a node group's current Kubernetes
#' version by not specifying a Kubernetes version in the request. You can
#' update to the latest AMI version of your cluster's current Kubernetes
#' version by specifying your cluster's Kubernetes version in the request.
#' For more information, see [Amazon EKS optimized Amazon Linux 2 AMI
#' versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
#' in the *Amazon EKS User Guide*.
#' 
#' You cannot roll back a node group to an earlier Kubernetes version or
#' AMI version.
#' 
#' When a node in a managed node group is terminated due to a scaling
#' action or update, the pods in that node are drained first. Amazon EKS
#' attempts to drain the nodes gracefully and will fail if it is unable to
#' do so. You can `force` the update if Amazon EKS is unable to drain the
#' nodes as a result of a pod disruption budget issue.
#'
#' @usage
#' eks_update_nodegroup_version(clusterName, nodegroupName, version,
#'   releaseVersion, launchTemplate, force, clientRequestToken)
#'
#' @param clusterName &#91;required&#93; The name of the Amazon EKS cluster that is associated with the managed
#' node group to update.
#' @param nodegroupName &#91;required&#93; The name of the managed node group to update.
#' @param version The Kubernetes version to update to. If no version is specified, then
#' the Kubernetes version of the node group does not change. You can
#' specify the Kubernetes version of the cluster to update the node group
#' to the latest AMI version of the cluster's Kubernetes version. If you
#' specify `launchTemplate`, and your launch template uses a custom AMI,
#' then don't specify `version`, or the node group update will fail. For
#' more information about using launch templates with Amazon EKS, see
#' [Launch template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the Amazon EKS User Guide.
#' @param releaseVersion The AMI version of the Amazon EKS optimized AMI to use for the update.
#' By default, the latest available AMI version for the node group's
#' Kubernetes version is used. For more information, see [Amazon EKS
#' optimized Amazon Linux 2 AMI
#' versions](https://docs.aws.amazon.com/eks/latest/userguide/eks-linux-ami-versions.html)
#' in the *Amazon EKS User Guide*. If you specify `launchTemplate`, and
#' your launch template uses a custom AMI, then don't specify
#' `releaseVersion`, or the node group update will fail. For more
#' information about using launch templates with Amazon EKS, see [Launch
#' template
#' support](https://docs.aws.amazon.com/eks/latest/userguide/launch-templates.html)
#' in the Amazon EKS User Guide.
#' @param launchTemplate An object representing a node group's launch template specification. You
#' can only update a node group using a launch template if the node group
#' was originally deployed with a launch template.
#' @param force Force the update if the existing node group's pods are unable to be
#' drained due to a pod disruption budget issue. If an update fails because
#' pods could not be drained, you can force the update after it fails to
#' terminate the old node whether or not any pods are running on the node.
#' @param clientRequestToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request.
#'
#' @section Request syntax:
#' ```
#' svc$update_nodegroup_version(
#'   clusterName = "string",
#'   nodegroupName = "string",
#'   version = "string",
#'   releaseVersion = "string",
#'   launchTemplate = list(
#'     name = "string",
#'     version = "string",
#'     id = "string"
#'   ),
#'   force = TRUE|FALSE,
#'   clientRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname eks_update_nodegroup_version
eks_update_nodegroup_version <- function(clusterName, nodegroupName, version = NULL, releaseVersion = NULL, launchTemplate = NULL, force = NULL, clientRequestToken = NULL) {
  op <- new_operation(
    name = "UpdateNodegroupVersion",
    http_method = "POST",
    http_path = "/clusters/{name}/node-groups/{nodegroupName}/update-version",
    paginator = list()
  )
  input <- .eks$update_nodegroup_version_input(clusterName = clusterName, nodegroupName = nodegroupName, version = version, releaseVersion = releaseVersion, launchTemplate = launchTemplate, force = force, clientRequestToken = clientRequestToken)
  output <- .eks$update_nodegroup_version_output()
  config <- get_config()
  svc <- .eks$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.eks$operations$update_nodegroup_version <- eks_update_nodegroup_version
